package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveCenterTransfer invokes the live.UpdateLiveCenterTransfer API synchronously
func (client *Client) UpdateLiveCenterTransfer(request *UpdateLiveCenterTransferRequest) (response *UpdateLiveCenterTransferResponse, err error) {
	response = CreateUpdateLiveCenterTransferResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveCenterTransferWithChan invokes the live.UpdateLiveCenterTransfer API asynchronously
func (client *Client) UpdateLiveCenterTransferWithChan(request *UpdateLiveCenterTransferRequest) (<-chan *UpdateLiveCenterTransferResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveCenterTransferResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveCenterTransfer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveCenterTransferWithCallback invokes the live.UpdateLiveCenterTransfer API asynchronously
func (client *Client) UpdateLiveCenterTransferWithCallback(request *UpdateLiveCenterTransferRequest, callback func(response *UpdateLiveCenterTransferResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveCenterTransferResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveCenterTransfer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveCenterTransferRequest is the request struct for api UpdateLiveCenterTransfer
type UpdateLiveCenterTransferRequest struct {
	*requests.RpcRequest
	TransferArgs string           `position:"Query" name:"TransferArgs"`
	StartTime    string           `position:"Query" name:"StartTime"`
	AppName      string           `position:"Query" name:"AppName"`
	StreamName   string           `position:"Query" name:"StreamName"`
	DstUrl       string           `position:"Query" name:"DstUrl"`
	DomainName   string           `position:"Query" name:"DomainName"`
	EndTime      string           `position:"Query" name:"EndTime"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// UpdateLiveCenterTransferResponse is the response struct for api UpdateLiveCenterTransfer
type UpdateLiveCenterTransferResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveCenterTransferRequest creates a request to invoke UpdateLiveCenterTransfer API
func CreateUpdateLiveCenterTransferRequest() (request *UpdateLiveCenterTransferRequest) {
	request = &UpdateLiveCenterTransferRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveCenterTransfer", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveCenterTransferResponse creates a response to parse from UpdateLiveCenterTransfer response
func CreateUpdateLiveCenterTransferResponse() (response *UpdateLiveCenterTransferResponse) {
	response = &UpdateLiveCenterTransferResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
