package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamWatermarks invokes the live.DescribeLiveStreamWatermarks API synchronously
func (client *Client) DescribeLiveStreamWatermarks(request *DescribeLiveStreamWatermarksRequest) (response *DescribeLiveStreamWatermarksResponse, err error) {
	response = CreateDescribeLiveStreamWatermarksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamWatermarksWithChan invokes the live.DescribeLiveStreamWatermarks API asynchronously
func (client *Client) DescribeLiveStreamWatermarksWithChan(request *DescribeLiveStreamWatermarksRequest) (<-chan *DescribeLiveStreamWatermarksResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamWatermarksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamWatermarks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamWatermarksWithCallback invokes the live.DescribeLiveStreamWatermarks API asynchronously
func (client *Client) DescribeLiveStreamWatermarksWithCallback(request *DescribeLiveStreamWatermarksRequest, callback func(response *DescribeLiveStreamWatermarksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamWatermarksResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamWatermarks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamWatermarksRequest is the request struct for api DescribeLiveStreamWatermarks
type DescribeLiveStreamWatermarksRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	KeyWord    string           `position:"Query" name:"KeyWord"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Domain     string           `position:"Query" name:"Domain"`
}

// DescribeLiveStreamWatermarksResponse is the response struct for api DescribeLiveStreamWatermarks
type DescribeLiveStreamWatermarksResponse struct {
	*responses.BaseResponse
	Total         int           `json:"Total" xml:"Total"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	WatermarkList WatermarkList `json:"WatermarkList" xml:"WatermarkList"`
}

// CreateDescribeLiveStreamWatermarksRequest creates a request to invoke DescribeLiveStreamWatermarks API
func CreateDescribeLiveStreamWatermarksRequest() (request *DescribeLiveStreamWatermarksRequest) {
	request = &DescribeLiveStreamWatermarksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamWatermarks", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamWatermarksResponse creates a response to parse from DescribeLiveStreamWatermarks response
func CreateDescribeLiveStreamWatermarksResponse() (response *DescribeLiveStreamWatermarksResponse) {
	response = &DescribeLiveStreamWatermarksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
