package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLiveStreamMonitor invokes the live.CreateLiveStreamMonitor API synchronously
func (client *Client) CreateLiveStreamMonitor(request *CreateLiveStreamMonitorRequest) (response *CreateLiveStreamMonitorResponse, err error) {
	response = CreateCreateLiveStreamMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLiveStreamMonitorWithChan invokes the live.CreateLiveStreamMonitor API asynchronously
func (client *Client) CreateLiveStreamMonitorWithChan(request *CreateLiveStreamMonitorRequest) (<-chan *CreateLiveStreamMonitorResponse, <-chan error) {
	responseChan := make(chan *CreateLiveStreamMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLiveStreamMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLiveStreamMonitorWithCallback invokes the live.CreateLiveStreamMonitor API asynchronously
func (client *Client) CreateLiveStreamMonitorWithCallback(request *CreateLiveStreamMonitorRequest, callback func(response *CreateLiveStreamMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLiveStreamMonitorResponse
		var err error
		defer close(result)
		response, err = client.CreateLiveStreamMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLiveStreamMonitorRequest is the request struct for api CreateLiveStreamMonitor
type CreateLiveStreamMonitorRequest struct {
	*requests.RpcRequest
	MonitorConfig  string           `position:"Query" name:"MonitorConfig"`
	MonitorName    string           `position:"Query" name:"MonitorName"`
	Stream         string           `position:"Query" name:"Stream"`
	OutputTemplate string           `position:"Query" name:"OutputTemplate"`
	App            string           `position:"Query" name:"App"`
	InputList      string           `position:"Query" name:"InputList"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Domain         string           `position:"Query" name:"Domain"`
}

// CreateLiveStreamMonitorResponse is the response struct for api CreateLiveStreamMonitor
type CreateLiveStreamMonitorResponse struct {
	*responses.BaseResponse
	MonitorId string `json:"MonitorId" xml:"MonitorId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateLiveStreamMonitorRequest creates a request to invoke CreateLiveStreamMonitor API
func CreateCreateLiveStreamMonitorRequest() (request *CreateLiveStreamMonitorRequest) {
	request = &CreateLiveStreamMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateLiveStreamMonitor", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLiveStreamMonitorResponse creates a response to parse from CreateLiveStreamMonitor response
func CreateCreateLiveStreamMonitorResponse() (response *CreateLiveStreamMonitorResponse) {
	response = &CreateLiveStreamMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
