package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDestination invokes the iot.ListDestination API synchronously
func (client *Client) ListDestination(request *ListDestinationRequest) (response *ListDestinationResponse, err error) {
	response = CreateListDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// ListDestinationWithChan invokes the iot.ListDestination API asynchronously
func (client *Client) ListDestinationWithChan(request *ListDestinationRequest) (<-chan *ListDestinationResponse, <-chan error) {
	responseChan := make(chan *ListDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDestinationWithCallback invokes the iot.ListDestination API asynchronously
func (client *Client) ListDestinationWithCallback(request *ListDestinationRequest, callback func(response *ListDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDestinationResponse
		var err error
		defer close(result)
		response, err = client.ListDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDestinationRequest is the request struct for api ListDestination
type ListDestinationRequest struct {
	*requests.RpcRequest
	SearchName    string           `position:"Query" name:"SearchName"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Types         *[]string        `position:"Query" name:"Types"  type:"Repeated"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	Page          requests.Integer `position:"Query" name:"Page"`
}

// ListDestinationResponse is the response struct for api ListDestination
type ListDestinationResponse struct {
	*responses.BaseResponse
	RequestId    string                        `json:"RequestId" xml:"RequestId"`
	Success      bool                          `json:"Success" xml:"Success"`
	Code         string                        `json:"Code" xml:"Code"`
	ErrorMessage string                        `json:"ErrorMessage" xml:"ErrorMessage"`
	Page         int                           `json:"Page" xml:"Page"`
	PageSize     int                           `json:"PageSize" xml:"PageSize"`
	Total        int                           `json:"Total" xml:"Total"`
	Destinations DestinationsInListDestination `json:"Destinations" xml:"Destinations"`
}

// CreateListDestinationRequest creates a request to invoke ListDestination API
func CreateListDestinationRequest() (request *ListDestinationRequest) {
	request = &ListDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateListDestinationResponse creates a response to parse from ListDestination response
func CreateListDestinationResponse() (response *ListDestinationResponse) {
	response = &ListDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
