package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddShareTaskDevice invokes the iot.AddShareTaskDevice API synchronously
func (client *Client) AddShareTaskDevice(request *AddShareTaskDeviceRequest) (response *AddShareTaskDeviceResponse, err error) {
	response = CreateAddShareTaskDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// AddShareTaskDeviceWithChan invokes the iot.AddShareTaskDevice API asynchronously
func (client *Client) AddShareTaskDeviceWithChan(request *AddShareTaskDeviceRequest) (<-chan *AddShareTaskDeviceResponse, <-chan error) {
	responseChan := make(chan *AddShareTaskDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddShareTaskDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddShareTaskDeviceWithCallback invokes the iot.AddShareTaskDevice API asynchronously
func (client *Client) AddShareTaskDeviceWithCallback(request *AddShareTaskDeviceRequest, callback func(response *AddShareTaskDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddShareTaskDeviceResponse
		var err error
		defer close(result)
		response, err = client.AddShareTaskDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddShareTaskDeviceRequest is the request struct for api AddShareTaskDevice
type AddShareTaskDeviceRequest struct {
	*requests.RpcRequest
	IotInstanceId string    `position:"Body" name:"IotInstanceId"`
	IotIdList     *[]string `position:"Body" name:"IotIdList"  type:"Repeated"`
	ShareTaskId   string    `position:"Body" name:"ShareTaskId"`
	ProductKey    string    `position:"Body" name:"ProductKey"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
}

// AddShareTaskDeviceResponse is the response struct for api AddShareTaskDevice
type AddShareTaskDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateAddShareTaskDeviceRequest creates a request to invoke AddShareTaskDevice API
func CreateAddShareTaskDeviceRequest() (request *AddShareTaskDeviceRequest) {
	request = &AddShareTaskDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "AddShareTaskDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateAddShareTaskDeviceResponse creates a response to parse from AddShareTaskDevice response
func CreateAddShareTaskDeviceResponse() (response *AddShareTaskDeviceResponse) {
	response = &AddShareTaskDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
