package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCostUnitOrders invokes the idaas_doraemon.ListCostUnitOrders API synchronously
func (client *Client) ListCostUnitOrders(request *ListCostUnitOrdersRequest) (response *ListCostUnitOrdersResponse, err error) {
	response = CreateListCostUnitOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// ListCostUnitOrdersWithChan invokes the idaas_doraemon.ListCostUnitOrders API asynchronously
func (client *Client) ListCostUnitOrdersWithChan(request *ListCostUnitOrdersRequest) (<-chan *ListCostUnitOrdersResponse, <-chan error) {
	responseChan := make(chan *ListCostUnitOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCostUnitOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCostUnitOrdersWithCallback invokes the idaas_doraemon.ListCostUnitOrders API asynchronously
func (client *Client) ListCostUnitOrdersWithCallback(request *ListCostUnitOrdersRequest, callback func(response *ListCostUnitOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCostUnitOrdersResponse
		var err error
		defer close(result)
		response, err = client.ListCostUnitOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCostUnitOrdersRequest is the request struct for api ListCostUnitOrders
type ListCostUnitOrdersRequest struct {
	*requests.RpcRequest
	BeginDate  string           `position:"Query" name:"BeginDate"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	FinalDate  string           `position:"Query" name:"FinalDate"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListCostUnitOrdersResponse is the response struct for api ListCostUnitOrders
type ListCostUnitOrdersResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	TotalPages    int64  `json:"TotalPages" xml:"TotalPages"`
	TotalElements int64  `json:"TotalElements" xml:"TotalElements"`
	PageSize      int64  `json:"PageSize" xml:"PageSize"`
	Items         []Item `json:"Items" xml:"Items"`
}

// CreateListCostUnitOrdersRequest creates a request to invoke ListCostUnitOrders API
func CreateListCostUnitOrdersRequest() (request *ListCostUnitOrdersRequest) {
	request = &ListCostUnitOrdersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "ListCostUnitOrders", "", "")
	request.Method = requests.POST
	return
}

// CreateListCostUnitOrdersResponse creates a response to parse from ListCostUnitOrders response
func CreateListCostUnitOrdersResponse() (response *ListCostUnitOrdersResponse) {
	response = &ListCostUnitOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
