package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAccelerator invokes the ga.DeleteAccelerator API synchronously
func (client *Client) DeleteAccelerator(request *DeleteAcceleratorRequest) (response *DeleteAcceleratorResponse, err error) {
	response = CreateDeleteAcceleratorResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAcceleratorWithChan invokes the ga.DeleteAccelerator API asynchronously
func (client *Client) DeleteAcceleratorWithChan(request *DeleteAcceleratorRequest) (<-chan *DeleteAcceleratorResponse, <-chan error) {
	responseChan := make(chan *DeleteAcceleratorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAccelerator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAcceleratorWithCallback invokes the ga.DeleteAccelerator API asynchronously
func (client *Client) DeleteAcceleratorWithCallback(request *DeleteAcceleratorRequest, callback func(response *DeleteAcceleratorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAcceleratorResponse
		var err error
		defer close(result)
		response, err = client.DeleteAccelerator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAcceleratorRequest is the request struct for api DeleteAccelerator
type DeleteAcceleratorRequest struct {
	*requests.RpcRequest
	AcceleratorId string `position:"Query" name:"AcceleratorId"`
}

// DeleteAcceleratorResponse is the response struct for api DeleteAccelerator
type DeleteAcceleratorResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	AcceleratorId string `json:"AcceleratorId" xml:"AcceleratorId"`
}

// CreateDeleteAcceleratorRequest creates a request to invoke DeleteAccelerator API
func CreateDeleteAcceleratorRequest() (request *DeleteAcceleratorRequest) {
	request = &DeleteAcceleratorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "DeleteAccelerator", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAcceleratorResponse creates a response to parse from DeleteAccelerator response
func CreateDeleteAcceleratorResponse() (response *DeleteAcceleratorResponse) {
	response = &DeleteAcceleratorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
