package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEventStreamings invokes the eventbridge.ListEventStreamings API synchronously
func (client *Client) ListEventStreamings(request *ListEventStreamingsRequest) (response *ListEventStreamingsResponse, err error) {
	response = CreateListEventStreamingsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEventStreamingsWithChan invokes the eventbridge.ListEventStreamings API asynchronously
func (client *Client) ListEventStreamingsWithChan(request *ListEventStreamingsRequest) (<-chan *ListEventStreamingsResponse, <-chan error) {
	responseChan := make(chan *ListEventStreamingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEventStreamings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEventStreamingsWithCallback invokes the eventbridge.ListEventStreamings API asynchronously
func (client *Client) ListEventStreamingsWithCallback(request *ListEventStreamingsRequest, callback func(response *ListEventStreamingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEventStreamingsResponse
		var err error
		defer close(result)
		response, err = client.ListEventStreamings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEventStreamingsRequest is the request struct for api ListEventStreamings
type ListEventStreamingsRequest struct {
	*requests.RpcRequest
	SinkType   string           `position:"Body" name:"SinkType"`
	NextToken  string           `position:"Body" name:"NextToken"`
	Limit      requests.Integer `position:"Body" name:"Limit"`
	SourceType string           `position:"Body" name:"SourceType"`
	NamePrefix string           `position:"Body" name:"NamePrefix"`
	Tag        string           `position:"Body" name:"Tag"`
}

// ListEventStreamingsResponse is the response struct for api ListEventStreamings
type ListEventStreamingsResponse struct {
	*responses.BaseResponse
	Message   string                    `json:"Message" xml:"Message"`
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Code      string                    `json:"Code" xml:"Code"`
	Success   bool                      `json:"Success" xml:"Success"`
	Data      DataInListEventStreamings `json:"Data" xml:"Data"`
}

// CreateListEventStreamingsRequest creates a request to invoke ListEventStreamings API
func CreateListEventStreamingsRequest() (request *ListEventStreamingsRequest) {
	request = &ListEventStreamingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "ListEventStreamings", "", "")
	request.Method = requests.POST
	return
}

// CreateListEventStreamingsResponse creates a response to parse from ListEventStreamings response
func CreateListEventStreamingsResponse() (response *ListEventStreamingsResponse) {
	response = &ListEventStreamingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
