package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOssStorageAndAccByBuckets invokes the ens.GetOssStorageAndAccByBuckets API synchronously
func (client *Client) GetOssStorageAndAccByBuckets(request *GetOssStorageAndAccByBucketsRequest) (response *GetOssStorageAndAccByBucketsResponse, err error) {
	response = CreateGetOssStorageAndAccByBucketsResponse()
	err = client.DoAction(request, response)
	return
}

// GetOssStorageAndAccByBucketsWithChan invokes the ens.GetOssStorageAndAccByBuckets API asynchronously
func (client *Client) GetOssStorageAndAccByBucketsWithChan(request *GetOssStorageAndAccByBucketsRequest) (<-chan *GetOssStorageAndAccByBucketsResponse, <-chan error) {
	responseChan := make(chan *GetOssStorageAndAccByBucketsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOssStorageAndAccByBuckets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOssStorageAndAccByBucketsWithCallback invokes the ens.GetOssStorageAndAccByBuckets API asynchronously
func (client *Client) GetOssStorageAndAccByBucketsWithCallback(request *GetOssStorageAndAccByBucketsRequest, callback func(response *GetOssStorageAndAccByBucketsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOssStorageAndAccByBucketsResponse
		var err error
		defer close(result)
		response, err = client.GetOssStorageAndAccByBuckets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOssStorageAndAccByBucketsRequest is the request struct for api GetOssStorageAndAccByBuckets
type GetOssStorageAndAccByBucketsRequest struct {
	*requests.RpcRequest
	BucketList string `position:"Query" name:"BucketList"`
}

// GetOssStorageAndAccByBucketsResponse is the response struct for api GetOssStorageAndAccByBuckets
type GetOssStorageAndAccByBucketsResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	BucketList []BucketListItem `json:"BucketList" xml:"BucketList"`
}

// CreateGetOssStorageAndAccByBucketsRequest creates a request to invoke GetOssStorageAndAccByBuckets API
func CreateGetOssStorageAndAccByBucketsRequest() (request *GetOssStorageAndAccByBucketsRequest) {
	request = &GetOssStorageAndAccByBucketsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "GetOssStorageAndAccByBuckets", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetOssStorageAndAccByBucketsResponse creates a response to parse from GetOssStorageAndAccByBuckets response
func CreateGetOssStorageAndAccByBucketsResponse() (response *GetOssStorageAndAccByBucketsResponse) {
	response = &GetOssStorageAndAccByBucketsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
