package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePartnerReservePrice invokes the domain.UpdatePartnerReservePrice API synchronously
func (client *Client) UpdatePartnerReservePrice(request *UpdatePartnerReservePriceRequest) (response *UpdatePartnerReservePriceResponse, err error) {
	response = CreateUpdatePartnerReservePriceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePartnerReservePriceWithChan invokes the domain.UpdatePartnerReservePrice API asynchronously
func (client *Client) UpdatePartnerReservePriceWithChan(request *UpdatePartnerReservePriceRequest) (<-chan *UpdatePartnerReservePriceResponse, <-chan error) {
	responseChan := make(chan *UpdatePartnerReservePriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePartnerReservePrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePartnerReservePriceWithCallback invokes the domain.UpdatePartnerReservePrice API asynchronously
func (client *Client) UpdatePartnerReservePriceWithCallback(request *UpdatePartnerReservePriceRequest, callback func(response *UpdatePartnerReservePriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePartnerReservePriceResponse
		var err error
		defer close(result)
		response, err = client.UpdatePartnerReservePrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePartnerReservePriceRequest is the request struct for api UpdatePartnerReservePrice
type UpdatePartnerReservePriceRequest struct {
	*requests.RpcRequest
	PartnerType  string           `position:"Body" name:"PartnerType"`
	DomainName   string           `position:"Body" name:"DomainName"`
	BiddingId    requests.Integer `position:"Body" name:"BiddingId"`
	ReservePrice string           `position:"Body" name:"ReservePrice"`
}

// UpdatePartnerReservePriceResponse is the response struct for api UpdatePartnerReservePrice
type UpdatePartnerReservePriceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdatePartnerReservePriceRequest creates a request to invoke UpdatePartnerReservePrice API
func CreateUpdatePartnerReservePriceRequest() (request *UpdatePartnerReservePriceRequest) {
	request = &UpdatePartnerReservePriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-02-08", "UpdatePartnerReservePrice", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdatePartnerReservePriceResponse creates a response to parse from UpdatePartnerReservePrice response
func CreateUpdatePartnerReservePriceResponse() (response *UpdatePartnerReservePriceResponse) {
	response = &UpdatePartnerReservePriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
