package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAggregateConfigRules invokes the config.ListAggregateConfigRules API synchronously
func (client *Client) ListAggregateConfigRules(request *ListAggregateConfigRulesRequest) (response *ListAggregateConfigRulesResponse, err error) {
	response = CreateListAggregateConfigRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAggregateConfigRulesWithChan invokes the config.ListAggregateConfigRules API asynchronously
func (client *Client) ListAggregateConfigRulesWithChan(request *ListAggregateConfigRulesRequest) (<-chan *ListAggregateConfigRulesResponse, <-chan error) {
	responseChan := make(chan *ListAggregateConfigRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAggregateConfigRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAggregateConfigRulesWithCallback invokes the config.ListAggregateConfigRules API asynchronously
func (client *Client) ListAggregateConfigRulesWithCallback(request *ListAggregateConfigRulesRequest, callback func(response *ListAggregateConfigRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAggregateConfigRulesResponse
		var err error
		defer close(result)
		response, err = client.ListAggregateConfigRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAggregateConfigRulesRequest is the request struct for api ListAggregateConfigRules
type ListAggregateConfigRulesRequest struct {
	*requests.RpcRequest
	FilterInCompliancePack           requests.Boolean            `position:"Query" name:"FilterInCompliancePack"`
	MessageType                      string                      `position:"Query" name:"MessageType"`
	ConfigRuleState                  string                      `position:"Query" name:"ConfigRuleState"`
	AggregatorId                     string                      `position:"Query" name:"AggregatorId"`
	FilterInCompliancePackExcludeIds string                      `position:"Query" name:"FilterInCompliancePackExcludeIds"`
	PageNumber                       requests.Integer            `position:"Query" name:"PageNumber"`
	PageSize                         requests.Integer            `position:"Query" name:"PageSize"`
	CompliancePackId                 string                      `position:"Query" name:"CompliancePackId"`
	Tag                              ListAggregateConfigRulesTag `position:"Query" name:"Tag"  type:"Struct"`
	Keyword                          string                      `position:"Query" name:"Keyword"`
	ComplianceType                   string                      `position:"Query" name:"ComplianceType"`
	RiskLevel                        requests.Integer            `position:"Query" name:"RiskLevel"`
	ConfigRuleName                   string                      `position:"Query" name:"ConfigRuleName"`
}

// ListAggregateConfigRulesTag is a repeated param struct in ListAggregateConfigRulesRequest
type ListAggregateConfigRulesTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListAggregateConfigRulesResponse is the response struct for api ListAggregateConfigRules
type ListAggregateConfigRulesResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	ConfigRules ConfigRules `json:"ConfigRules" xml:"ConfigRules"`
}

// CreateListAggregateConfigRulesRequest creates a request to invoke ListAggregateConfigRules API
func CreateListAggregateConfigRulesRequest() (request *ListAggregateConfigRulesRequest) {
	request = &ListAggregateConfigRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListAggregateConfigRules", "", "")
	request.Method = requests.POST
	return
}

// CreateListAggregateConfigRulesResponse creates a response to parse from ListAggregateConfigRules response
func CreateListAggregateConfigRulesResponse() (response *ListAggregateConfigRulesResponse) {
	response = &ListAggregateConfigRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
