package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUmengPagePermission4Root invokes the cloudwf.GetUmengPagePermission4Root API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getumengpagepermission4root.html
func (client *Client) GetUmengPagePermission4Root(request *GetUmengPagePermission4RootRequest) (response *GetUmengPagePermission4RootResponse, err error) {
	response = CreateGetUmengPagePermission4RootResponse()
	err = client.DoAction(request, response)
	return
}

// GetUmengPagePermission4RootWithChan invokes the cloudwf.GetUmengPagePermission4Root API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getumengpagepermission4root.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUmengPagePermission4RootWithChan(request *GetUmengPagePermission4RootRequest) (<-chan *GetUmengPagePermission4RootResponse, <-chan error) {
	responseChan := make(chan *GetUmengPagePermission4RootResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUmengPagePermission4Root(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUmengPagePermission4RootWithCallback invokes the cloudwf.GetUmengPagePermission4Root API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getumengpagepermission4root.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUmengPagePermission4RootWithCallback(request *GetUmengPagePermission4RootRequest, callback func(response *GetUmengPagePermission4RootResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUmengPagePermission4RootResponse
		var err error
		defer close(result)
		response, err = client.GetUmengPagePermission4Root(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUmengPagePermission4RootRequest is the request struct for api GetUmengPagePermission4Root
type GetUmengPagePermission4RootRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// GetUmengPagePermission4RootResponse is the response struct for api GetUmengPagePermission4Root
type GetUmengPagePermission4RootResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetUmengPagePermission4RootRequest creates a request to invoke GetUmengPagePermission4Root API
func CreateGetUmengPagePermission4RootRequest() (request *GetUmengPagePermission4RootRequest) {
	request = &GetUmengPagePermission4RootRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetUmengPagePermission4Root", "cloudwf", "openAPI")
	return
}

// CreateGetUmengPagePermission4RootResponse creates a response to parse from GetUmengPagePermission4Root response
func CreateGetUmengPagePermission4RootResponse() (response *GetUmengPagePermission4RootResponse) {
	response = &GetUmengPagePermission4RootResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
