package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStaTop invokes the cloudwf.GetStaTop API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getstatop.html
func (client *Client) GetStaTop(request *GetStaTopRequest) (response *GetStaTopResponse, err error) {
	response = CreateGetStaTopResponse()
	err = client.DoAction(request, response)
	return
}

// GetStaTopWithChan invokes the cloudwf.GetStaTop API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getstatop.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetStaTopWithChan(request *GetStaTopRequest) (<-chan *GetStaTopResponse, <-chan error) {
	responseChan := make(chan *GetStaTopResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStaTop(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStaTopWithCallback invokes the cloudwf.GetStaTop API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getstatop.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetStaTopWithCallback(request *GetStaTopRequest, callback func(response *GetStaTopResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStaTopResponse
		var err error
		defer close(result)
		response, err = client.GetStaTop(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStaTopRequest is the request struct for api GetStaTop
type GetStaTopRequest struct {
	*requests.RpcRequest
	ApgroupId requests.Integer `position:"Query" name:"ApgroupId"`
}

// GetStaTopResponse is the response struct for api GetStaTop
type GetStaTopResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetStaTopRequest creates a request to invoke GetStaTop API
func CreateGetStaTopRequest() (request *GetStaTopRequest) {
	request = &GetStaTopRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetStaTop", "cloudwf", "openAPI")
	return
}

// CreateGetStaTopResponse creates a response to parse from GetStaTop response
func CreateGetStaTopResponse() (response *GetStaTopResponse) {
	response = &GetStaTopResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
