package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVnRedirection invokes the cloudcallcenter.CreateVnRedirection API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvnredirection.html
func (client *Client) CreateVnRedirection(request *CreateVnRedirectionRequest) (response *CreateVnRedirectionResponse, err error) {
	response = CreateCreateVnRedirectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVnRedirectionWithChan invokes the cloudcallcenter.CreateVnRedirection API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvnredirection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVnRedirectionWithChan(request *CreateVnRedirectionRequest) (<-chan *CreateVnRedirectionResponse, <-chan error) {
	responseChan := make(chan *CreateVnRedirectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVnRedirection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVnRedirectionWithCallback invokes the cloudcallcenter.CreateVnRedirection API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvnredirection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVnRedirectionWithCallback(request *CreateVnRedirectionRequest, callback func(response *CreateVnRedirectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVnRedirectionResponse
		var err error
		defer close(result)
		response, err = client.CreateVnRedirection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVnRedirectionRequest is the request struct for api CreateVnRedirection
type CreateVnRedirectionRequest struct {
	*requests.RpcRequest
	RedirectionType   string           `position:"Query" name:"RedirectionType"`
	UserUtterance     string           `position:"Query" name:"UserUtterance"`
	Interruptible     requests.Boolean `position:"Query" name:"Interruptible"`
	InstanceId        string           `position:"Query" name:"InstanceId"`
	SimilarUtterances *[]string        `position:"Query" name:"SimilarUtterances"  type:"Repeated"`
	RedirectionTarget string           `position:"Query" name:"RedirectionTarget"`
	Prompt            string           `position:"Query" name:"Prompt"`
	CategoryId        string           `position:"Query" name:"CategoryId"`
}

// CreateVnRedirectionResponse is the response struct for api CreateVnRedirection
type CreateVnRedirectionResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	NavigationScriptId string `json:"NavigationScriptId" xml:"NavigationScriptId"`
}

// CreateCreateVnRedirectionRequest creates a request to invoke CreateVnRedirection API
func CreateCreateVnRedirectionRequest() (request *CreateVnRedirectionRequest) {
	request = &CreateVnRedirectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateVnRedirection", "", "")
	request.Method = requests.GET
	return
}

// CreateCreateVnRedirectionResponse creates a response to parse from CreateVnRedirection response
func CreateCreateVnRedirectionResponse() (response *CreateVnRedirectionResponse) {
	response = &CreateVnRedirectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
