package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRequestLogs invokes the cloudapi.QueryRequestLogs API synchronously
func (client *Client) QueryRequestLogs(request *QueryRequestLogsRequest) (response *QueryRequestLogsResponse, err error) {
	response = CreateQueryRequestLogsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRequestLogsWithChan invokes the cloudapi.QueryRequestLogs API asynchronously
func (client *Client) QueryRequestLogsWithChan(request *QueryRequestLogsRequest) (<-chan *QueryRequestLogsResponse, <-chan error) {
	responseChan := make(chan *QueryRequestLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRequestLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRequestLogsWithCallback invokes the cloudapi.QueryRequestLogs API asynchronously
func (client *Client) QueryRequestLogsWithCallback(request *QueryRequestLogsRequest, callback func(response *QueryRequestLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRequestLogsResponse
		var err error
		defer close(result)
		response, err = client.QueryRequestLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRequestLogsRequest is the request struct for api QueryRequestLogs
type QueryRequestLogsRequest struct {
	*requests.RpcRequest
	RequestLogId  string `position:"Query" name:"RequestLogId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// QueryRequestLogsResponse is the response struct for api QueryRequestLogs
type QueryRequestLogsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	RequestLogs RequestLogs `json:"RequestLogs" xml:"RequestLogs"`
}

// CreateQueryRequestLogsRequest creates a request to invoke QueryRequestLogs API
func CreateQueryRequestLogsRequest() (request *QueryRequestLogsRequest) {
	request = &QueryRequestLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "QueryRequestLogs", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRequestLogsResponse creates a response to parse from QueryRequestLogs response
func CreateQueryRequestLogsResponse() (response *QueryRequestLogsResponse) {
	response = &QueryRequestLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
