package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDataset invokes the cloudapi.ModifyDataset API synchronously
func (client *Client) ModifyDataset(request *ModifyDatasetRequest) (response *ModifyDatasetResponse, err error) {
	response = CreateModifyDatasetResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDatasetWithChan invokes the cloudapi.ModifyDataset API asynchronously
func (client *Client) ModifyDatasetWithChan(request *ModifyDatasetRequest) (<-chan *ModifyDatasetResponse, <-chan error) {
	responseChan := make(chan *ModifyDatasetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDataset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDatasetWithCallback invokes the cloudapi.ModifyDataset API asynchronously
func (client *Client) ModifyDatasetWithCallback(request *ModifyDatasetRequest, callback func(response *ModifyDatasetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDatasetResponse
		var err error
		defer close(result)
		response, err = client.ModifyDataset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDatasetRequest is the request struct for api ModifyDataset
type ModifyDatasetRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	DatasetId     string `position:"Query" name:"DatasetId"`
	DatasetName   string `position:"Query" name:"DatasetName"`
}

// ModifyDatasetResponse is the response struct for api ModifyDataset
type ModifyDatasetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDatasetRequest creates a request to invoke ModifyDataset API
func CreateModifyDatasetRequest() (request *ModifyDatasetRequest) {
	request = &ModifyDatasetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyDataset", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDatasetResponse creates a response to parse from ModifyDataset response
func CreateModifyDatasetResponse() (response *ModifyDatasetResponse) {
	response = &ModifyDatasetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
