package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePurchasedApis invokes the cloudapi.DescribePurchasedApis API synchronously
func (client *Client) DescribePurchasedApis(request *DescribePurchasedApisRequest) (response *DescribePurchasedApisResponse, err error) {
	response = CreateDescribePurchasedApisResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePurchasedApisWithChan invokes the cloudapi.DescribePurchasedApis API asynchronously
func (client *Client) DescribePurchasedApisWithChan(request *DescribePurchasedApisRequest) (<-chan *DescribePurchasedApisResponse, <-chan error) {
	responseChan := make(chan *DescribePurchasedApisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePurchasedApis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePurchasedApisWithCallback invokes the cloudapi.DescribePurchasedApis API asynchronously
func (client *Client) DescribePurchasedApisWithCallback(request *DescribePurchasedApisRequest, callback func(response *DescribePurchasedApisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePurchasedApisResponse
		var err error
		defer close(result)
		response, err = client.DescribePurchasedApis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePurchasedApisRequest is the request struct for api DescribePurchasedApis
type DescribePurchasedApisRequest struct {
	*requests.RpcRequest
	StageName     string           `position:"Query" name:"StageName"`
	Visibility    string           `position:"Query" name:"Visibility"`
	GroupId       string           `position:"Query" name:"GroupId"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	ApiName       string           `position:"Query" name:"ApiName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ApiId         string           `position:"Query" name:"ApiId"`
}

// DescribePurchasedApisResponse is the response struct for api DescribePurchasedApis
type DescribePurchasedApisResponse struct {
	*responses.BaseResponse
	PageNumber    int           `json:"PageNumber" xml:"PageNumber"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	PageSize      int           `json:"PageSize" xml:"PageSize"`
	TotalCount    int           `json:"TotalCount" xml:"TotalCount"`
	PurchasedApis PurchasedApis `json:"PurchasedApis" xml:"PurchasedApis"`
}

// CreateDescribePurchasedApisRequest creates a request to invoke DescribePurchasedApis API
func CreateDescribePurchasedApisRequest() (request *DescribePurchasedApisRequest) {
	request = &DescribePurchasedApisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribePurchasedApis", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePurchasedApisResponse creates a response to parse from DescribePurchasedApis response
func CreateDescribePurchasedApisResponse() (response *DescribePurchasedApisResponse) {
	response = &DescribePurchasedApisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
