package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRealtimeLogDelivery invokes the cdn.DeleteRealtimeLogDelivery API synchronously
func (client *Client) DeleteRealtimeLogDelivery(request *DeleteRealtimeLogDeliveryRequest) (response *DeleteRealtimeLogDeliveryResponse, err error) {
	response = CreateDeleteRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRealtimeLogDeliveryWithChan invokes the cdn.DeleteRealtimeLogDelivery API asynchronously
func (client *Client) DeleteRealtimeLogDeliveryWithChan(request *DeleteRealtimeLogDeliveryRequest) (<-chan *DeleteRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DeleteRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRealtimeLogDeliveryWithCallback invokes the cdn.DeleteRealtimeLogDelivery API asynchronously
func (client *Client) DeleteRealtimeLogDeliveryWithCallback(request *DeleteRealtimeLogDeliveryRequest, callback func(response *DeleteRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DeleteRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRealtimeLogDeliveryRequest is the request struct for api DeleteRealtimeLogDelivery
type DeleteRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	Domain   string `position:"Query" name:"Domain"`
	Project  string `position:"Query" name:"Project"`
	Region   string `position:"Query" name:"Region"`
	Logstore string `position:"Query" name:"Logstore"`
}

// DeleteRealtimeLogDeliveryResponse is the response struct for api DeleteRealtimeLogDelivery
type DeleteRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteRealtimeLogDeliveryRequest creates a request to invoke DeleteRealtimeLogDelivery API
func CreateDeleteRealtimeLogDeliveryRequest() (request *DeleteRealtimeLogDeliveryRequest) {
	request = &DeleteRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DeleteRealtimeLogDelivery", "", "")
	request.Method = requests.GET
	return
}

// CreateDeleteRealtimeLogDeliveryResponse creates a response to parse from DeleteRealtimeLogDelivery response
func CreateDeleteRealtimeLogDeliveryResponse() (response *DeleteRealtimeLogDeliveryResponse) {
	response = &DeleteRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
