package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCases invokes the ccc.ListCases API synchronously
func (client *Client) ListCases(request *ListCasesRequest) (response *ListCasesResponse, err error) {
	response = CreateListCasesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCasesWithChan invokes the ccc.ListCases API asynchronously
func (client *Client) ListCasesWithChan(request *ListCasesRequest) (<-chan *ListCasesResponse, <-chan error) {
	responseChan := make(chan *ListCasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCasesWithCallback invokes the ccc.ListCases API asynchronously
func (client *Client) ListCasesWithCallback(request *ListCasesRequest, callback func(response *ListCasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCasesResponse
		var err error
		defer close(result)
		response, err = client.ListCases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCasesRequest is the request struct for api ListCases
type ListCasesRequest struct {
	*requests.RpcRequest
	InstanceId  string           `position:"Query" name:"InstanceId"`
	CampaignId  string           `position:"Query" name:"CampaignId"`
	PhoneNumber string           `position:"Query" name:"PhoneNumber"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
}

// ListCasesResponse is the response struct for api ListCases
type ListCasesResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	Message        string          `json:"Message" xml:"Message"`
	HttpStatusCode int64           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string          `json:"Code" xml:"Code"`
	Success        bool            `json:"Success" xml:"Success"`
	Data           DataInListCases `json:"Data" xml:"Data"`
}

// CreateListCasesRequest creates a request to invoke ListCases API
func CreateListCasesRequest() (request *ListCasesRequest) {
	request = &ListCasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListCases", "", "")
	request.Method = requests.POST
	return
}

// CreateListCasesResponse creates a response to parse from ListCases response
func CreateListCasesResponse() (response *ListCasesResponse) {
	response = &ListCasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
