package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRealtimeCampaignStats invokes the ccc.GetRealtimeCampaignStats API synchronously
func (client *Client) GetRealtimeCampaignStats(request *GetRealtimeCampaignStatsRequest) (response *GetRealtimeCampaignStatsResponse, err error) {
	response = CreateGetRealtimeCampaignStatsResponse()
	err = client.DoAction(request, response)
	return
}

// GetRealtimeCampaignStatsWithChan invokes the ccc.GetRealtimeCampaignStats API asynchronously
func (client *Client) GetRealtimeCampaignStatsWithChan(request *GetRealtimeCampaignStatsRequest) (<-chan *GetRealtimeCampaignStatsResponse, <-chan error) {
	responseChan := make(chan *GetRealtimeCampaignStatsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRealtimeCampaignStats(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRealtimeCampaignStatsWithCallback invokes the ccc.GetRealtimeCampaignStats API asynchronously
func (client *Client) GetRealtimeCampaignStatsWithCallback(request *GetRealtimeCampaignStatsRequest, callback func(response *GetRealtimeCampaignStatsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRealtimeCampaignStatsResponse
		var err error
		defer close(result)
		response, err = client.GetRealtimeCampaignStats(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRealtimeCampaignStatsRequest is the request struct for api GetRealtimeCampaignStats
type GetRealtimeCampaignStatsRequest struct {
	*requests.RpcRequest
	QueueId    string `position:"Query" name:"QueueId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetRealtimeCampaignStatsResponse is the response struct for api GetRealtimeCampaignStats
type GetRealtimeCampaignStatsResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetRealtimeCampaignStatsRequest creates a request to invoke GetRealtimeCampaignStats API
func CreateGetRealtimeCampaignStatsRequest() (request *GetRealtimeCampaignStatsRequest) {
	request = &GetRealtimeCampaignStatsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetRealtimeCampaignStats", "", "")
	request.Method = requests.GET
	return
}

// CreateGetRealtimeCampaignStatsResponse creates a response to parse from GetRealtimeCampaignStats response
func CreateGetRealtimeCampaignStatsResponse() (response *GetRealtimeCampaignStatsResponse) {
	response = &GetRealtimeCampaignStatsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
