package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWirelessCloudConnector invokes the cc5g.GetWirelessCloudConnector API synchronously
func (client *Client) GetWirelessCloudConnector(request *GetWirelessCloudConnectorRequest) (response *GetWirelessCloudConnectorResponse, err error) {
	response = CreateGetWirelessCloudConnectorResponse()
	err = client.DoAction(request, response)
	return
}

// GetWirelessCloudConnectorWithChan invokes the cc5g.GetWirelessCloudConnector API asynchronously
func (client *Client) GetWirelessCloudConnectorWithChan(request *GetWirelessCloudConnectorRequest) (<-chan *GetWirelessCloudConnectorResponse, <-chan error) {
	responseChan := make(chan *GetWirelessCloudConnectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWirelessCloudConnector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWirelessCloudConnectorWithCallback invokes the cc5g.GetWirelessCloudConnector API asynchronously
func (client *Client) GetWirelessCloudConnectorWithCallback(request *GetWirelessCloudConnectorRequest, callback func(response *GetWirelessCloudConnectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWirelessCloudConnectorResponse
		var err error
		defer close(result)
		response, err = client.GetWirelessCloudConnector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWirelessCloudConnectorRequest is the request struct for api GetWirelessCloudConnector
type GetWirelessCloudConnectorRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorId string `position:"Query" name:"WirelessCloudConnectorId"`
}

// GetWirelessCloudConnectorResponse is the response struct for api GetWirelessCloudConnector
type GetWirelessCloudConnectorResponse struct {
	*responses.BaseResponse
	RequestId                     string    `json:"RequestId" xml:"RequestId"`
	WirelessCloudConnectorId      string    `json:"WirelessCloudConnectorId" xml:"WirelessCloudConnectorId"`
	Status                        string    `json:"Status" xml:"Status"`
	Name                          string    `json:"Name" xml:"Name"`
	Description                   string    `json:"Description" xml:"Description"`
	RegionId                      string    `json:"RegionId" xml:"RegionId"`
	UseCase                       string    `json:"UseCase" xml:"UseCase"`
	DataPackageId                 string    `json:"DataPackageId" xml:"DataPackageId"`
	DataPackageType               string    `json:"DataPackageType" xml:"DataPackageType"`
	CardCount                     string    `json:"CardCount" xml:"CardCount"`
	CreateTime                    string    `json:"CreateTime" xml:"CreateTime"`
	BusinessType                  string    `json:"BusinessType" xml:"BusinessType"`
	WirelessCloudConnectorGroupId string    `json:"WirelessCloudConnectorGroupId" xml:"WirelessCloudConnectorGroupId"`
	ServiceType                   string    `json:"ServiceType" xml:"ServiceType"`
	Features                      []string  `json:"Features" xml:"Features"`
	NetLinks                      []NetLink `json:"NetLinks" xml:"NetLinks"`
}

// CreateGetWirelessCloudConnectorRequest creates a request to invoke GetWirelessCloudConnector API
func CreateGetWirelessCloudConnectorRequest() (request *GetWirelessCloudConnectorRequest) {
	request = &GetWirelessCloudConnectorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "GetWirelessCloudConnector", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetWirelessCloudConnectorResponse creates a response to parse from GetWirelessCloudConnector response
func CreateGetWirelessCloudConnectorResponse() (response *GetWirelessCloudConnectorResponse) {
	response = &GetWirelessCloudConnectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
