package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrUpdateAlertRule invokes the arms.CreateOrUpdateAlertRule API synchronously
func (client *Client) CreateOrUpdateAlertRule(request *CreateOrUpdateAlertRuleRequest) (response *CreateOrUpdateAlertRuleResponse, err error) {
	response = CreateCreateOrUpdateAlertRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrUpdateAlertRuleWithChan invokes the arms.CreateOrUpdateAlertRule API asynchronously
func (client *Client) CreateOrUpdateAlertRuleWithChan(request *CreateOrUpdateAlertRuleRequest) (<-chan *CreateOrUpdateAlertRuleResponse, <-chan error) {
	responseChan := make(chan *CreateOrUpdateAlertRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrUpdateAlertRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrUpdateAlertRuleWithCallback invokes the arms.CreateOrUpdateAlertRule API asynchronously
func (client *Client) CreateOrUpdateAlertRuleWithCallback(request *CreateOrUpdateAlertRuleRequest, callback func(response *CreateOrUpdateAlertRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrUpdateAlertRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateOrUpdateAlertRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrUpdateAlertRuleRequest is the request struct for api CreateOrUpdateAlertRule
type CreateOrUpdateAlertRuleRequest struct {
	*requests.RpcRequest
	AlertGroup            requests.Integer `position:"Body" name:"AlertGroup"`
	AlertName             string           `position:"Body" name:"AlertName"`
	AlertStatus           string           `position:"Body" name:"AlertStatus"`
	Annotations           string           `position:"Body" name:"Annotations"`
	Duration              requests.Integer `position:"Body" name:"Duration"`
	MetricsKey            string           `position:"Body" name:"MetricsKey"`
	AlertRuleContent      string           `position:"Body" name:"AlertRuleContent"`
	PromQL                string           `position:"Body" name:"PromQL"`
	Level                 string           `position:"Body" name:"Level"`
	AutoAddNewApplication requests.Boolean `position:"Body" name:"AutoAddNewApplication"`
	Filters               string           `position:"Body" name:"Filters"`
	ClusterId             string           `position:"Body" name:"ClusterId"`
	Message               string           `position:"Body" name:"Message"`
	NotifyStrategy        string           `position:"Body" name:"NotifyStrategy"`
	Labels                string           `position:"Body" name:"Labels"`
	AlertType             string           `position:"Body" name:"AlertType"`
	AlertCheckType        string           `position:"Body" name:"AlertCheckType"`
	MetricsType           string           `position:"Body" name:"MetricsType"`
	AlertId               requests.Integer `position:"Body" name:"AlertId"`
	Pids                  string           `position:"Body" name:"Pids"`
}

// CreateOrUpdateAlertRuleResponse is the response struct for api CreateOrUpdateAlertRule
type CreateOrUpdateAlertRuleResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	AlertRule AlertRule `json:"AlertRule" xml:"AlertRule"`
}

// CreateCreateOrUpdateAlertRuleRequest creates a request to invoke CreateOrUpdateAlertRule API
func CreateCreateOrUpdateAlertRuleRequest() (request *CreateOrUpdateAlertRuleRequest) {
	request = &CreateOrUpdateAlertRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreateOrUpdateAlertRule", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOrUpdateAlertRuleResponse creates a response to parse from CreateOrUpdateAlertRule response
func CreateCreateOrUpdateAlertRuleResponse() (response *CreateOrUpdateAlertRuleResponse) {
	response = &CreateOrUpdateAlertRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
