package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSurveyJob invokes the apds.DescribeSurveyJob API synchronously
func (client *Client) DescribeSurveyJob(request *DescribeSurveyJobRequest) (response *DescribeSurveyJobResponse, err error) {
	response = CreateDescribeSurveyJobResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSurveyJobWithChan invokes the apds.DescribeSurveyJob API asynchronously
func (client *Client) DescribeSurveyJobWithChan(request *DescribeSurveyJobRequest) (<-chan *DescribeSurveyJobResponse, <-chan error) {
	responseChan := make(chan *DescribeSurveyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSurveyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSurveyJobWithCallback invokes the apds.DescribeSurveyJob API asynchronously
func (client *Client) DescribeSurveyJobWithCallback(request *DescribeSurveyJobRequest, callback func(response *DescribeSurveyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSurveyJobResponse
		var err error
		defer close(result)
		response, err = client.DescribeSurveyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSurveyJobRequest is the request struct for api DescribeSurveyJob
type DescribeSurveyJobRequest struct {
	*requests.RoaRequest
	Id string `position:"Query" name:"id"`
}

// DescribeSurveyJobResponse is the response struct for api DescribeSurveyJob
type DescribeSurveyJobResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateDescribeSurveyJobRequest creates a request to invoke DescribeSurveyJob API
func CreateDescribeSurveyJobRequest() (request *DescribeSurveyJobRequest) {
	request = &DescribeSurveyJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "DescribeSurveyJob", "/okss-services/winback/query-survey-job", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSurveyJobResponse creates a response to parse from DescribeSurveyJob response
func CreateDescribeSurveyJobResponse() (response *DescribeSurveyJobResponse) {
	response = &DescribeSurveyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
