package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetActivityTask invokes the ahas_openapi.GetActivityTask API synchronously
func (client *Client) GetActivityTask(request *GetActivityTaskRequest) (response *GetActivityTaskResponse, err error) {
	response = CreateGetActivityTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetActivityTaskWithChan invokes the ahas_openapi.GetActivityTask API asynchronously
func (client *Client) GetActivityTaskWithChan(request *GetActivityTaskRequest) (<-chan *GetActivityTaskResponse, <-chan error) {
	responseChan := make(chan *GetActivityTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetActivityTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetActivityTaskWithCallback invokes the ahas_openapi.GetActivityTask API asynchronously
func (client *Client) GetActivityTaskWithCallback(request *GetActivityTaskRequest, callback func(response *GetActivityTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetActivityTaskResponse
		var err error
		defer close(result)
		response, err = client.GetActivityTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetActivityTaskRequest is the request struct for api GetActivityTask
type GetActivityTaskRequest struct {
	*requests.RpcRequest
	ActivityTaskId   string `position:"Query" name:"ActivityTaskId"`
	AhasRegionId     string `position:"Query" name:"AhasRegionId"`
	NameSpace        string `position:"Query" name:"NameSpace"`
	ExperimentTaskId string `position:"Query" name:"ExperimentTaskId"`
}

// GetActivityTaskResponse is the response struct for api GetActivityTask
type GetActivityTaskResponse struct {
	*responses.BaseResponse
	Phase            string      `json:"Phase" xml:"Phase"`
	EndTime          int64       `json:"EndTime" xml:"EndTime"`
	RequestId        string      `json:"RequestId" xml:"RequestId"`
	ActivityName     string      `json:"ActivityName" xml:"ActivityName"`
	State            string      `json:"State" xml:"State"`
	ActivityId       string      `json:"ActivityId" xml:"ActivityId"`
	ExperimentTaskId string      `json:"ExperimentTaskId" xml:"ExperimentTaskId"`
	HttpStatusCode   int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	StartTime        int64       `json:"StartTime" xml:"StartTime"`
	RunResult        string      `json:"RunResult" xml:"RunResult"`
	Success          bool        `json:"Success" xml:"Success"`
	Hosts            []HostsItem `json:"Hosts" xml:"Hosts"`
}

// CreateGetActivityTaskRequest creates a request to invoke GetActivityTask API
func CreateGetActivityTaskRequest() (request *GetActivityTaskRequest) {
	request = &GetActivityTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "GetActivityTask", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetActivityTaskResponse creates a response to parse from GetActivityTask response
func CreateGetActivityTaskResponse() (response *GetActivityTaskResponse) {
	response = &GetActivityTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
