package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteExperiment invokes the ahas_openapi.ExecuteExperiment API synchronously
func (client *Client) ExecuteExperiment(request *ExecuteExperimentRequest) (response *ExecuteExperimentResponse, err error) {
	response = CreateExecuteExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteExperimentWithChan invokes the ahas_openapi.ExecuteExperiment API asynchronously
func (client *Client) ExecuteExperimentWithChan(request *ExecuteExperimentRequest) (<-chan *ExecuteExperimentResponse, <-chan error) {
	responseChan := make(chan *ExecuteExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteExperimentWithCallback invokes the ahas_openapi.ExecuteExperiment API asynchronously
func (client *Client) ExecuteExperimentWithCallback(request *ExecuteExperimentRequest, callback func(response *ExecuteExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteExperimentResponse
		var err error
		defer close(result)
		response, err = client.ExecuteExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteExperimentRequest is the request struct for api ExecuteExperiment
type ExecuteExperimentRequest struct {
	*requests.RpcRequest
	AhasRegionId string `position:"Query" name:"AhasRegionId"`
	NameSpace    string `position:"Query" name:"NameSpace"`
	ExperimentId string `position:"Query" name:"ExperimentId"`
	Definition   string `position:"Query" name:"Definition"`
}

// ExecuteExperimentResponse is the response struct for api ExecuteExperiment
type ExecuteExperimentResponse struct {
	*responses.BaseResponse
	TaskId    string `json:"TaskId" xml:"TaskId"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateExecuteExperimentRequest creates a request to invoke ExecuteExperiment API
func CreateExecuteExperimentRequest() (request *ExecuteExperimentRequest) {
	request = &ExecuteExperimentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ExecuteExperiment", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExecuteExperimentResponse creates a response to parse from ExecuteExperiment response
func CreateExecuteExperimentResponse() (response *ExecuteExperimentResponse) {
	response = &ExecuteExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
