package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebLockStatus invokes the aegis.DescribeWebLockStatus API synchronously
// api document: https://help.aliyun.com/api/aegis/describeweblockstatus.html
func (client *Client) DescribeWebLockStatus(request *DescribeWebLockStatusRequest) (response *DescribeWebLockStatusResponse, err error) {
	response = CreateDescribeWebLockStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebLockStatusWithChan invokes the aegis.DescribeWebLockStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeweblockstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebLockStatusWithChan(request *DescribeWebLockStatusRequest) (<-chan *DescribeWebLockStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeWebLockStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebLockStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebLockStatusWithCallback invokes the aegis.DescribeWebLockStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeweblockstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebLockStatusWithCallback(request *DescribeWebLockStatusRequest, callback func(response *DescribeWebLockStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebLockStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebLockStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebLockStatusRequest is the request struct for api DescribeWebLockStatus
type DescribeWebLockStatusRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	From     string `position:"Query" name:"From"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeWebLockStatusResponse is the response struct for api DescribeWebLockStatus
type DescribeWebLockStatusResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	AuthCount  int    `json:"AuthCount" xml:"AuthCount"`
	BindCount  int    `json:"BindCount" xml:"BindCount"`
	ExpireTime int    `json:"ExpireTime" xml:"ExpireTime"`
}

// CreateDescribeWebLockStatusRequest creates a request to invoke DescribeWebLockStatus API
func CreateDescribeWebLockStatusRequest() (request *DescribeWebLockStatusRequest) {
	request = &DescribeWebLockStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeWebLockStatus", "vipaegis", "openAPI")
	return
}

// CreateDescribeWebLockStatusResponse creates a response to parse from DescribeWebLockStatus response
func CreateDescribeWebLockStatusResponse() (response *DescribeWebLockStatusResponse) {
	response = &DescribeWebLockStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
