package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBResourceGroup invokes the adb.DescribeDBResourceGroup API synchronously
func (client *Client) DescribeDBResourceGroup(request *DescribeDBResourceGroupRequest) (response *DescribeDBResourceGroupResponse, err error) {
	response = CreateDescribeDBResourceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBResourceGroupWithChan invokes the adb.DescribeDBResourceGroup API asynchronously
func (client *Client) DescribeDBResourceGroupWithChan(request *DescribeDBResourceGroupRequest) (<-chan *DescribeDBResourceGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeDBResourceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBResourceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBResourceGroupWithCallback invokes the adb.DescribeDBResourceGroup API asynchronously
func (client *Client) DescribeDBResourceGroupWithCallback(request *DescribeDBResourceGroupRequest, callback func(response *DescribeDBResourceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBResourceGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBResourceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBResourceGroupRequest is the request struct for api DescribeDBResourceGroup
type DescribeDBResourceGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	GroupName            string           `position:"Query" name:"GroupName"`
}

// DescribeDBResourceGroupResponse is the response struct for api DescribeDBResourceGroup
type DescribeDBResourceGroupResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	GroupsInfo []PoolInfo `json:"GroupsInfo" xml:"GroupsInfo"`
}

// CreateDescribeDBResourceGroupRequest creates a request to invoke DescribeDBResourceGroup API
func CreateDescribeDBResourceGroupRequest() (request *DescribeDBResourceGroupRequest) {
	request = &DescribeDBResourceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDBResourceGroup", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBResourceGroupResponse creates a response to parse from DescribeDBResourceGroup response
func CreateDescribeDBResourceGroupResponse() (response *DescribeDBResourceGroupResponse) {
	response = &DescribeDBResourceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
