//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresources

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// Client contains the methods for the Resources group.
// Don't use this type directly, use NewClient() instead.
type Client struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewClient creates a new instance of Client with the specified values.
// subscriptionID - The Microsoft Azure subscription ID.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) *Client {
	cp := arm.ClientOptions{}
	if options != nil {
		cp = *options
	}
	if len(cp.Endpoint) == 0 {
		cp.Endpoint = arm.AzurePublicCloud
	}
	client := &Client{
		subscriptionID: subscriptionID,
		host:           string(cp.Endpoint),
		pl:             armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, &cp),
	}
	return client
}

// CheckExistence - Checks whether a resource exists.
// resourceGroupName - The name of the resource group containing the resource to check. The name is case insensitive.
// resourceProviderNamespace - The resource provider of the resource to check.
// parentResourcePath - The parent resource identity.
// resourceType - The resource type.
// resourceName - The name of the resource to check whether it exists.
// apiVersion - The API version to use for the operation.
// options - ClientCheckExistenceOptions contains the optional parameters for the Client.CheckExistence method.
func (client *Client) CheckExistence(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, options *ClientCheckExistenceOptions) (ClientCheckExistenceResponse, error) {
	req, err := client.checkExistenceCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, options)
	if err != nil {
		return ClientCheckExistenceResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ClientCheckExistenceResponse{}, err
	}
	result := ClientCheckExistenceResponse{RawResponse: resp}
	if resp.StatusCode >= 200 && resp.StatusCode < 300 {
		result.Success = true
	}
	return result, nil
}

// checkExistenceCreateRequest creates the CheckExistence request.
func (client *Client) checkExistenceCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, options *ClientCheckExistenceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// CheckExistenceByID - Checks by ID whether a resource exists.
// resourceID - The fully qualified ID of the resource, including the resource name and resource type. Use the format,
// /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
// apiVersion - The API version to use for the operation.
// options - ClientCheckExistenceByIDOptions contains the optional parameters for the Client.CheckExistenceByID method.
func (client *Client) CheckExistenceByID(ctx context.Context, resourceID string, apiVersion string, options *ClientCheckExistenceByIDOptions) (ClientCheckExistenceByIDResponse, error) {
	req, err := client.checkExistenceByIDCreateRequest(ctx, resourceID, apiVersion, options)
	if err != nil {
		return ClientCheckExistenceByIDResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ClientCheckExistenceByIDResponse{}, err
	}
	result := ClientCheckExistenceByIDResponse{RawResponse: resp}
	if resp.StatusCode >= 200 && resp.StatusCode < 300 {
		result.Success = true
	}
	return result, nil
}

// checkExistenceByIDCreateRequest creates the CheckExistenceByID request.
func (client *Client) checkExistenceByIDCreateRequest(ctx context.Context, resourceID string, apiVersion string, options *ClientCheckExistenceByIDOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// BeginCreateOrUpdate - Creates a resource.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceGroupName - The name of the resource group for the resource. The name is case insensitive.
// resourceProviderNamespace - The namespace of the resource provider.
// parentResourcePath - The parent resource identity.
// resourceType - The resource type of the resource to create.
// resourceName - The name of the resource to create.
// apiVersion - The API version to use for the operation.
// parameters - Parameters for creating or updating the resource.
// options - ClientBeginCreateOrUpdateOptions contains the optional parameters for the Client.BeginCreateOrUpdate method.
func (client *Client) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, parameters GenericResource, options *ClientBeginCreateOrUpdateOptions) (ClientCreateOrUpdatePollerResponse, error) {
	resp, err := client.createOrUpdate(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, options)
	if err != nil {
		return ClientCreateOrUpdatePollerResponse{}, err
	}
	result := ClientCreateOrUpdatePollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("Client.CreateOrUpdate", "", resp, client.pl)
	if err != nil {
		return ClientCreateOrUpdatePollerResponse{}, err
	}
	result.Poller = &ClientCreateOrUpdatePoller{
		pt: pt,
	}
	return result, nil
}

// CreateOrUpdate - Creates a resource.
// If the operation fails it returns an *azcore.ResponseError type.
func (client *Client) createOrUpdate(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, parameters GenericResource, options *ClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *Client) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, parameters GenericResource, options *ClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginCreateOrUpdateByID - Create a resource by ID.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceID - The fully qualified ID of the resource, including the resource name and resource type. Use the format,
// /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
// apiVersion - The API version to use for the operation.
// parameters - Create or update resource parameters.
// options - ClientBeginCreateOrUpdateByIDOptions contains the optional parameters for the Client.BeginCreateOrUpdateByID
// method.
func (client *Client) BeginCreateOrUpdateByID(ctx context.Context, resourceID string, apiVersion string, parameters GenericResource, options *ClientBeginCreateOrUpdateByIDOptions) (ClientCreateOrUpdateByIDPollerResponse, error) {
	resp, err := client.createOrUpdateByID(ctx, resourceID, apiVersion, parameters, options)
	if err != nil {
		return ClientCreateOrUpdateByIDPollerResponse{}, err
	}
	result := ClientCreateOrUpdateByIDPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("Client.CreateOrUpdateByID", "", resp, client.pl)
	if err != nil {
		return ClientCreateOrUpdateByIDPollerResponse{}, err
	}
	result.Poller = &ClientCreateOrUpdateByIDPoller{
		pt: pt,
	}
	return result, nil
}

// CreateOrUpdateByID - Create a resource by ID.
// If the operation fails it returns an *azcore.ResponseError type.
func (client *Client) createOrUpdateByID(ctx context.Context, resourceID string, apiVersion string, parameters GenericResource, options *ClientBeginCreateOrUpdateByIDOptions) (*http.Response, error) {
	req, err := client.createOrUpdateByIDCreateRequest(ctx, resourceID, apiVersion, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateByIDCreateRequest creates the CreateOrUpdateByID request.
func (client *Client) createOrUpdateByIDCreateRequest(ctx context.Context, resourceID string, apiVersion string, parameters GenericResource, options *ClientBeginCreateOrUpdateByIDOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginDelete - Deletes a resource.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceGroupName - The name of the resource group that contains the resource to delete. The name is case insensitive.
// resourceProviderNamespace - The namespace of the resource provider.
// parentResourcePath - The parent resource identity.
// resourceType - The resource type.
// resourceName - The name of the resource to delete.
// apiVersion - The API version to use for the operation.
// options - ClientBeginDeleteOptions contains the optional parameters for the Client.BeginDelete method.
func (client *Client) BeginDelete(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, options *ClientBeginDeleteOptions) (ClientDeletePollerResponse, error) {
	resp, err := client.deleteOperation(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, options)
	if err != nil {
		return ClientDeletePollerResponse{}, err
	}
	result := ClientDeletePollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("Client.Delete", "", resp, client.pl)
	if err != nil {
		return ClientDeletePollerResponse{}, err
	}
	result.Poller = &ClientDeletePoller{
		pt: pt,
	}
	return result, nil
}

// Delete - Deletes a resource.
// If the operation fails it returns an *azcore.ResponseError type.
func (client *Client) deleteOperation(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, options *ClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *Client) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, options *ClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// BeginDeleteByID - Deletes a resource by ID.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceID - The fully qualified ID of the resource, including the resource name and resource type. Use the format,
// /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
// apiVersion - The API version to use for the operation.
// options - ClientBeginDeleteByIDOptions contains the optional parameters for the Client.BeginDeleteByID method.
func (client *Client) BeginDeleteByID(ctx context.Context, resourceID string, apiVersion string, options *ClientBeginDeleteByIDOptions) (ClientDeleteByIDPollerResponse, error) {
	resp, err := client.deleteByID(ctx, resourceID, apiVersion, options)
	if err != nil {
		return ClientDeleteByIDPollerResponse{}, err
	}
	result := ClientDeleteByIDPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("Client.DeleteByID", "", resp, client.pl)
	if err != nil {
		return ClientDeleteByIDPollerResponse{}, err
	}
	result.Poller = &ClientDeleteByIDPoller{
		pt: pt,
	}
	return result, nil
}

// DeleteByID - Deletes a resource by ID.
// If the operation fails it returns an *azcore.ResponseError type.
func (client *Client) deleteByID(ctx context.Context, resourceID string, apiVersion string, options *ClientBeginDeleteByIDOptions) (*http.Response, error) {
	req, err := client.deleteByIDCreateRequest(ctx, resourceID, apiVersion, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteByIDCreateRequest creates the DeleteByID request.
func (client *Client) deleteByIDCreateRequest(ctx context.Context, resourceID string, apiVersion string, options *ClientBeginDeleteByIDOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// Get - Gets a resource.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceGroupName - The name of the resource group containing the resource to get. The name is case insensitive.
// resourceProviderNamespace - The namespace of the resource provider.
// parentResourcePath - The parent resource identity.
// resourceType - The resource type of the resource.
// resourceName - The name of the resource to get.
// apiVersion - The API version to use for the operation.
// options - ClientGetOptions contains the optional parameters for the Client.Get method.
func (client *Client) Get(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, options *ClientGetOptions) (ClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, options)
	if err != nil {
		return ClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *Client) getCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, options *ClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *Client) getHandleResponse(resp *http.Response) (ClientGetResponse, error) {
	result := ClientGetResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.GenericResource); err != nil {
		return ClientGetResponse{}, err
	}
	return result, nil
}

// GetByID - Gets a resource by ID.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceID - The fully qualified ID of the resource, including the resource name and resource type. Use the format,
// /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
// apiVersion - The API version to use for the operation.
// options - ClientGetByIDOptions contains the optional parameters for the Client.GetByID method.
func (client *Client) GetByID(ctx context.Context, resourceID string, apiVersion string, options *ClientGetByIDOptions) (ClientGetByIDResponse, error) {
	req, err := client.getByIDCreateRequest(ctx, resourceID, apiVersion, options)
	if err != nil {
		return ClientGetByIDResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ClientGetByIDResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ClientGetByIDResponse{}, runtime.NewResponseError(resp)
	}
	return client.getByIDHandleResponse(resp)
}

// getByIDCreateRequest creates the GetByID request.
func (client *Client) getByIDCreateRequest(ctx context.Context, resourceID string, apiVersion string, options *ClientGetByIDOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getByIDHandleResponse handles the GetByID response.
func (client *Client) getByIDHandleResponse(resp *http.Response) (ClientGetByIDResponse, error) {
	result := ClientGetByIDResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.GenericResource); err != nil {
		return ClientGetByIDResponse{}, err
	}
	return result, nil
}

// List - Get all the resources in a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// options - ClientListOptions contains the optional parameters for the Client.List method.
func (client *Client) List(options *ClientListOptions) *ClientListPager {
	return &ClientListPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.listCreateRequest(ctx, options)
		},
		advancer: func(ctx context.Context, resp ClientListResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.ResourceListResult.NextLink)
		},
	}
}

// listCreateRequest creates the List request.
func (client *Client) listCreateRequest(ctx context.Context, options *ClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resources"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	reqQP.Set("api-version", "2021-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listHandleResponse handles the List response.
func (client *Client) listHandleResponse(resp *http.Response) (ClientListResponse, error) {
	result := ClientListResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceListResult); err != nil {
		return ClientListResponse{}, err
	}
	return result, nil
}

// ListByResourceGroup - Get all the resources for a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceGroupName - The resource group with the resources to get.
// options - ClientListByResourceGroupOptions contains the optional parameters for the Client.ListByResourceGroup method.
func (client *Client) ListByResourceGroup(resourceGroupName string, options *ClientListByResourceGroupOptions) *ClientListByResourceGroupPager {
	return &ClientListByResourceGroupPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
		},
		advancer: func(ctx context.Context, resp ClientListByResourceGroupResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.ResourceListResult.NextLink)
		},
	}
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *Client) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	reqQP.Set("api-version", "2021-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *Client) listByResourceGroupHandleResponse(resp *http.Response) (ClientListByResourceGroupResponse, error) {
	result := ClientListByResourceGroupResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceListResult); err != nil {
		return ClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// BeginMoveResources - The resources to be moved must be in the same source resource group in the source subscription being
// used. The target resource group may be in a different subscription. When moving resources, both the
// source group and the target group are locked for the duration of the operation. Write and delete operations are blocked
// on the groups until the move completes.
// If the operation fails it returns an *azcore.ResponseError type.
// sourceResourceGroupName - The name of the resource group from the source subscription containing the resources to be moved.
// parameters - Parameters for moving resources.
// options - ClientBeginMoveResourcesOptions contains the optional parameters for the Client.BeginMoveResources method.
func (client *Client) BeginMoveResources(ctx context.Context, sourceResourceGroupName string, parameters MoveInfo, options *ClientBeginMoveResourcesOptions) (ClientMoveResourcesPollerResponse, error) {
	resp, err := client.moveResources(ctx, sourceResourceGroupName, parameters, options)
	if err != nil {
		return ClientMoveResourcesPollerResponse{}, err
	}
	result := ClientMoveResourcesPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("Client.MoveResources", "", resp, client.pl)
	if err != nil {
		return ClientMoveResourcesPollerResponse{}, err
	}
	result.Poller = &ClientMoveResourcesPoller{
		pt: pt,
	}
	return result, nil
}

// MoveResources - The resources to be moved must be in the same source resource group in the source subscription being used.
// The target resource group may be in a different subscription. When moving resources, both the
// source group and the target group are locked for the duration of the operation. Write and delete operations are blocked
// on the groups until the move completes.
// If the operation fails it returns an *azcore.ResponseError type.
func (client *Client) moveResources(ctx context.Context, sourceResourceGroupName string, parameters MoveInfo, options *ClientBeginMoveResourcesOptions) (*http.Response, error) {
	req, err := client.moveResourcesCreateRequest(ctx, sourceResourceGroupName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// moveResourcesCreateRequest creates the MoveResources request.
func (client *Client) moveResourcesCreateRequest(ctx context.Context, sourceResourceGroupName string, parameters MoveInfo, options *ClientBeginMoveResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources"
	if sourceResourceGroupName == "" {
		return nil, errors.New("parameter sourceResourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sourceResourceGroupName}", url.PathEscape(sourceResourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginUpdate - Updates a resource.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceGroupName - The name of the resource group for the resource. The name is case insensitive.
// resourceProviderNamespace - The namespace of the resource provider.
// parentResourcePath - The parent resource identity.
// resourceType - The resource type of the resource to update.
// resourceName - The name of the resource to update.
// apiVersion - The API version to use for the operation.
// parameters - Parameters for updating the resource.
// options - ClientBeginUpdateOptions contains the optional parameters for the Client.BeginUpdate method.
func (client *Client) BeginUpdate(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, parameters GenericResource, options *ClientBeginUpdateOptions) (ClientUpdatePollerResponse, error) {
	resp, err := client.update(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, options)
	if err != nil {
		return ClientUpdatePollerResponse{}, err
	}
	result := ClientUpdatePollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("Client.Update", "", resp, client.pl)
	if err != nil {
		return ClientUpdatePollerResponse{}, err
	}
	result.Poller = &ClientUpdatePoller{
		pt: pt,
	}
	return result, nil
}

// Update - Updates a resource.
// If the operation fails it returns an *azcore.ResponseError type.
func (client *Client) update(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, parameters GenericResource, options *ClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *Client) updateCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, apiVersion string, parameters GenericResource, options *ClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginUpdateByID - Updates a resource by ID.
// If the operation fails it returns an *azcore.ResponseError type.
// resourceID - The fully qualified ID of the resource, including the resource name and resource type. Use the format,
// /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}
// apiVersion - The API version to use for the operation.
// parameters - Update resource parameters.
// options - ClientBeginUpdateByIDOptions contains the optional parameters for the Client.BeginUpdateByID method.
func (client *Client) BeginUpdateByID(ctx context.Context, resourceID string, apiVersion string, parameters GenericResource, options *ClientBeginUpdateByIDOptions) (ClientUpdateByIDPollerResponse, error) {
	resp, err := client.updateByID(ctx, resourceID, apiVersion, parameters, options)
	if err != nil {
		return ClientUpdateByIDPollerResponse{}, err
	}
	result := ClientUpdateByIDPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("Client.UpdateByID", "", resp, client.pl)
	if err != nil {
		return ClientUpdateByIDPollerResponse{}, err
	}
	result.Poller = &ClientUpdateByIDPoller{
		pt: pt,
	}
	return result, nil
}

// UpdateByID - Updates a resource by ID.
// If the operation fails it returns an *azcore.ResponseError type.
func (client *Client) updateByID(ctx context.Context, resourceID string, apiVersion string, parameters GenericResource, options *ClientBeginUpdateByIDOptions) (*http.Response, error) {
	req, err := client.updateByIDCreateRequest(ctx, resourceID, apiVersion, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateByIDCreateRequest creates the UpdateByID request.
func (client *Client) updateByIDCreateRequest(ctx context.Context, resourceID string, apiVersion string, parameters GenericResource, options *ClientBeginUpdateByIDOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", apiVersion)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginValidateMoveResources - This operation checks whether the specified resources can be moved to the target. The resources
// to be moved must be in the same source resource group in the source subscription being used. The target
// resource group may be in a different subscription. If validation succeeds, it returns HTTP response code 204 (no content).
// If validation fails, it returns HTTP response code 409 (Conflict) with an
// error message. Retrieve the URL in the Location header value to check the result of the long-running operation.
// If the operation fails it returns an *azcore.ResponseError type.
// sourceResourceGroupName - The name of the resource group from the source subscription containing the resources to be validated
// for move.
// parameters - Parameters for moving resources.
// options - ClientBeginValidateMoveResourcesOptions contains the optional parameters for the Client.BeginValidateMoveResources
// method.
func (client *Client) BeginValidateMoveResources(ctx context.Context, sourceResourceGroupName string, parameters MoveInfo, options *ClientBeginValidateMoveResourcesOptions) (ClientValidateMoveResourcesPollerResponse, error) {
	resp, err := client.validateMoveResources(ctx, sourceResourceGroupName, parameters, options)
	if err != nil {
		return ClientValidateMoveResourcesPollerResponse{}, err
	}
	result := ClientValidateMoveResourcesPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("Client.ValidateMoveResources", "", resp, client.pl)
	if err != nil {
		return ClientValidateMoveResourcesPollerResponse{}, err
	}
	result.Poller = &ClientValidateMoveResourcesPoller{
		pt: pt,
	}
	return result, nil
}

// ValidateMoveResources - This operation checks whether the specified resources can be moved to the target. The resources
// to be moved must be in the same source resource group in the source subscription being used. The target
// resource group may be in a different subscription. If validation succeeds, it returns HTTP response code 204 (no content).
// If validation fails, it returns HTTP response code 409 (Conflict) with an
// error message. Retrieve the URL in the Location header value to check the result of the long-running operation.
// If the operation fails it returns an *azcore.ResponseError type.
func (client *Client) validateMoveResources(ctx context.Context, sourceResourceGroupName string, parameters MoveInfo, options *ClientBeginValidateMoveResourcesOptions) (*http.Response, error) {
	req, err := client.validateMoveResourcesCreateRequest(ctx, sourceResourceGroupName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// validateMoveResourcesCreateRequest creates the ValidateMoveResources request.
func (client *Client) validateMoveResourcesCreateRequest(ctx context.Context, sourceResourceGroupName string, parameters MoveInfo, options *ClientBeginValidateMoveResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources"
	if sourceResourceGroupName == "" {
		return nil, errors.New("parameter sourceResourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sourceResourceGroupName}", url.PathEscape(sourceResourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}
