// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package rpc

import(
	"bytes"
	"context"
	"database/sql/driver"
	"errors"
	"fmt"
	"time"
	"github.com/apache/thrift/lib/go/thrift"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = time.Now
var _ = bytes.Equal

type TSProtocolVersion int64
const (
	TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1 TSProtocolVersion = 0
	TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2 TSProtocolVersion = 1
	TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3 TSProtocolVersion = 2
)

func (p TSProtocolVersion) String() string {
	switch p {
	case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1: return "IOTDB_SERVICE_PROTOCOL_V1"
	case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2: return "IOTDB_SERVICE_PROTOCOL_V2"
	case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3: return "IOTDB_SERVICE_PROTOCOL_V3"
	}
	return "<UNSET>"
}

func TSProtocolVersionFromString(s string) (TSProtocolVersion, error) {
	switch s {
	case "IOTDB_SERVICE_PROTOCOL_V1": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1, nil
	case "IOTDB_SERVICE_PROTOCOL_V2": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2, nil
	case "IOTDB_SERVICE_PROTOCOL_V3": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3, nil
	}
	return TSProtocolVersion(0), fmt.Errorf("not a valid TSProtocolVersion string")
}


func TSProtocolVersionPtr(v TSProtocolVersion) *TSProtocolVersion { return &v }

func (p TSProtocolVersion) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *TSProtocolVersion) UnmarshalText(text []byte) error {
	q, err := TSProtocolVersionFromString(string(text))
	if (err != nil) {
		return err
	}
	*p = q
	return nil
}

func (p *TSProtocolVersion) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = TSProtocolVersion(v)
	return nil
}

func (p * TSProtocolVersion) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}
// Attributes:
//  - IP
//  - Port
type EndPoint struct {
	IP string `thrift:"ip,1,required" db:"ip" json:"ip"`
	Port int32 `thrift:"port,2,required" db:"port" json:"port"`
}

func NewEndPoint() *EndPoint {
	return &EndPoint{}
}


func (p *EndPoint) GetIP() string {
	return p.IP
}

func (p *EndPoint) GetPort() int32 {
	return p.Port
}
func (p *EndPoint) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetIP bool = false;
	var issetPort bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetIP = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetPort = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetIP{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IP is not set"));
	}
	if !issetPort{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Port is not set"));
	}
	return nil
}

func (p *EndPoint)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.IP = v
	}
	return nil
}

func (p *EndPoint)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Port = v
	}
	return nil
}

func (p *EndPoint) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "EndPoint"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *EndPoint) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "ip", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:ip: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.IP)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.ip (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:ip: ", p), err) }
	return err
}

func (p *EndPoint) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "port", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:port: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.Port)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.port (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:port: ", p), err) }
	return err
}

func (p *EndPoint) Equals(other *EndPoint) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.IP != other.IP { return false }
	if p.Port != other.Port { return false }
	return true
}

func (p *EndPoint) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("EndPoint(%+v)", *p)
}

// Attributes:
//  - Code
//  - Message
//  - SubStatus
//  - RedirectNode
type TSStatus struct {
	Code int32 `thrift:"code,1,required" db:"code" json:"code"`
	Message *string `thrift:"message,2" db:"message" json:"message,omitempty"`
	SubStatus []*TSStatus `thrift:"subStatus,3" db:"subStatus" json:"subStatus,omitempty"`
	RedirectNode *EndPoint `thrift:"redirectNode,4" db:"redirectNode" json:"redirectNode,omitempty"`
}

func NewTSStatus() *TSStatus {
	return &TSStatus{}
}


func (p *TSStatus) GetCode() int32 {
	return p.Code
}
var TSStatus_Message_DEFAULT string
func (p *TSStatus) GetMessage() string {
	if !p.IsSetMessage() {
		return TSStatus_Message_DEFAULT
	}
	return *p.Message
}
var TSStatus_SubStatus_DEFAULT []*TSStatus

func (p *TSStatus) GetSubStatus() []*TSStatus {
	return p.SubStatus
}
var TSStatus_RedirectNode_DEFAULT *EndPoint
func (p *TSStatus) GetRedirectNode() *EndPoint {
	if !p.IsSetRedirectNode() {
		return TSStatus_RedirectNode_DEFAULT
	}
	return p.RedirectNode
}
func (p *TSStatus) IsSetMessage() bool {
	return p.Message != nil
}

func (p *TSStatus) IsSetSubStatus() bool {
	return p.SubStatus != nil
}

func (p *TSStatus) IsSetRedirectNode() bool {
	return p.RedirectNode != nil
}

func (p *TSStatus) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetCode bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetCode = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetCode{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Code is not set"));
	}
	return nil
}

func (p *TSStatus)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Code = v
	}
	return nil
}

func (p *TSStatus)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Message = &v
	}
	return nil
}

func (p *TSStatus)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*TSStatus, 0, size)
	p.SubStatus =  tSlice
	for i := 0; i < size; i ++ {
		_elem0 := &TSStatus{}
		if err := _elem0.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem0), err)
		}
		p.SubStatus = append(p.SubStatus, _elem0)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSStatus)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	p.RedirectNode = &EndPoint{}
	if err := p.RedirectNode.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.RedirectNode), err)
	}
	return nil
}

func (p *TSStatus) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSStatus"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSStatus) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "code", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:code: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.Code)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.code (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:code: ", p), err) }
	return err
}

func (p *TSStatus) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMessage() {
		if err := oprot.WriteFieldBegin(ctx, "message", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:message: ", p), err) }
		if err := oprot.WriteString(ctx, string(*p.Message)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.message (2) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:message: ", p), err) }
	}
	return err
}

func (p *TSStatus) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSubStatus() {
		if err := oprot.WriteFieldBegin(ctx, "subStatus", thrift.LIST, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:subStatus: ", p), err) }
		if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.SubStatus)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.SubStatus {
			if err := v.Write(ctx, oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:subStatus: ", p), err) }
	}
	return err
}

func (p *TSStatus) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetRedirectNode() {
		if err := oprot.WriteFieldBegin(ctx, "redirectNode", thrift.STRUCT, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:redirectNode: ", p), err) }
		if err := p.RedirectNode.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.RedirectNode), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:redirectNode: ", p), err) }
	}
	return err
}

func (p *TSStatus) Equals(other *TSStatus) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Code != other.Code { return false }
	if p.Message != other.Message {
		if p.Message == nil || other.Message == nil {
			return false
		}
		if (*p.Message) != (*other.Message) { return false }
	}
	if len(p.SubStatus) != len(other.SubStatus) { return false }
	for i, _tgt := range p.SubStatus {
		_src1 := other.SubStatus[i]
		if !_tgt.Equals(_src1) { return false }
	}
	if !p.RedirectNode.Equals(other.RedirectNode) { return false }
	return true
}

func (p *TSStatus) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSStatus(%+v)", *p)
}

// Attributes:
//  - Time
//  - ValueList
//  - BitmapList
type TSQueryDataSet struct {
	Time []byte `thrift:"time,1,required" db:"time" json:"time"`
	ValueList [][]byte `thrift:"valueList,2,required" db:"valueList" json:"valueList"`
	BitmapList [][]byte `thrift:"bitmapList,3,required" db:"bitmapList" json:"bitmapList"`
}

func NewTSQueryDataSet() *TSQueryDataSet {
	return &TSQueryDataSet{}
}


func (p *TSQueryDataSet) GetTime() []byte {
	return p.Time
}

func (p *TSQueryDataSet) GetValueList() [][]byte {
	return p.ValueList
}

func (p *TSQueryDataSet) GetBitmapList() [][]byte {
	return p.BitmapList
}
func (p *TSQueryDataSet) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetTime bool = false;
	var issetValueList bool = false;
	var issetBitmapList bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetTime = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetValueList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetBitmapList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetTime{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Time is not set"));
	}
	if !issetValueList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValueList is not set"));
	}
	if !issetBitmapList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field BitmapList is not set"));
	}
	return nil
}

func (p *TSQueryDataSet)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Time = v
	}
	return nil
}

func (p *TSQueryDataSet)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.ValueList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem2 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem2 = v
		}
		p.ValueList = append(p.ValueList, _elem2)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSQueryDataSet)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.BitmapList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem3 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem3 = v
		}
		p.BitmapList = append(p.BitmapList, _elem3)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSQueryDataSet) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSQueryDataSet"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSQueryDataSet) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "time", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:time: ", p), err) }
	if err := oprot.WriteBinary(ctx, p.Time); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.time (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:time: ", p), err) }
	return err
}

func (p *TSQueryDataSet) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "valueList", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:valueList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValueList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.ValueList {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:valueList: ", p), err) }
	return err
}

func (p *TSQueryDataSet) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "bitmapList", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:bitmapList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.BitmapList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.BitmapList {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:bitmapList: ", p), err) }
	return err
}

func (p *TSQueryDataSet) Equals(other *TSQueryDataSet) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if bytes.Compare(p.Time, other.Time) != 0 { return false }
	if len(p.ValueList) != len(other.ValueList) { return false }
	for i, _tgt := range p.ValueList {
		_src4 := other.ValueList[i]
		if bytes.Compare(_tgt, _src4) != 0 { return false }
	}
	if len(p.BitmapList) != len(other.BitmapList) { return false }
	for i, _tgt := range p.BitmapList {
		_src5 := other.BitmapList[i]
		if bytes.Compare(_tgt, _src5) != 0 { return false }
	}
	return true
}

func (p *TSQueryDataSet) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSQueryDataSet(%+v)", *p)
}

// Attributes:
//  - TimeList
//  - ValueList
type TSQueryNonAlignDataSet struct {
	TimeList [][]byte `thrift:"timeList,1,required" db:"timeList" json:"timeList"`
	ValueList [][]byte `thrift:"valueList,2,required" db:"valueList" json:"valueList"`
}

func NewTSQueryNonAlignDataSet() *TSQueryNonAlignDataSet {
	return &TSQueryNonAlignDataSet{}
}


func (p *TSQueryNonAlignDataSet) GetTimeList() [][]byte {
	return p.TimeList
}

func (p *TSQueryNonAlignDataSet) GetValueList() [][]byte {
	return p.ValueList
}
func (p *TSQueryNonAlignDataSet) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetTimeList bool = false;
	var issetValueList bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetTimeList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetValueList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetTimeList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeList is not set"));
	}
	if !issetValueList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValueList is not set"));
	}
	return nil
}

func (p *TSQueryNonAlignDataSet)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.TimeList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem6 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem6 = v
		}
		p.TimeList = append(p.TimeList, _elem6)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSQueryNonAlignDataSet)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.ValueList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem7 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem7 = v
		}
		p.ValueList = append(p.ValueList, _elem7)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSQueryNonAlignDataSet) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSQueryNonAlignDataSet"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSQueryNonAlignDataSet) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timeList", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:timeList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.TimeList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.TimeList {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:timeList: ", p), err) }
	return err
}

func (p *TSQueryNonAlignDataSet) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "valueList", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:valueList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValueList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.ValueList {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:valueList: ", p), err) }
	return err
}

func (p *TSQueryNonAlignDataSet) Equals(other *TSQueryNonAlignDataSet) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if len(p.TimeList) != len(other.TimeList) { return false }
	for i, _tgt := range p.TimeList {
		_src8 := other.TimeList[i]
		if bytes.Compare(_tgt, _src8) != 0 { return false }
	}
	if len(p.ValueList) != len(other.ValueList) { return false }
	for i, _tgt := range p.ValueList {
		_src9 := other.ValueList[i]
		if bytes.Compare(_tgt, _src9) != 0 { return false }
	}
	return true
}

func (p *TSQueryNonAlignDataSet) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSQueryNonAlignDataSet(%+v)", *p)
}

// Attributes:
//  - Status
//  - QueryId
//  - Columns
//  - OperationType
//  - IgnoreTimeStamp
//  - DataTypeList
//  - QueryDataSet
//  - NonAlignQueryDataSet
//  - ColumnNameIndexMap
type TSExecuteStatementResp struct {
	Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
	QueryId *int64 `thrift:"queryId,2" db:"queryId" json:"queryId,omitempty"`
	Columns []string `thrift:"columns,3" db:"columns" json:"columns,omitempty"`
	OperationType *string `thrift:"operationType,4" db:"operationType" json:"operationType,omitempty"`
	IgnoreTimeStamp *bool `thrift:"ignoreTimeStamp,5" db:"ignoreTimeStamp" json:"ignoreTimeStamp,omitempty"`
	DataTypeList []string `thrift:"dataTypeList,6" db:"dataTypeList" json:"dataTypeList,omitempty"`
	QueryDataSet *TSQueryDataSet `thrift:"queryDataSet,7" db:"queryDataSet" json:"queryDataSet,omitempty"`
	NonAlignQueryDataSet *TSQueryNonAlignDataSet `thrift:"nonAlignQueryDataSet,8" db:"nonAlignQueryDataSet" json:"nonAlignQueryDataSet,omitempty"`
	ColumnNameIndexMap map[string]int32 `thrift:"columnNameIndexMap,9" db:"columnNameIndexMap" json:"columnNameIndexMap,omitempty"`
}

func NewTSExecuteStatementResp() *TSExecuteStatementResp {
	return &TSExecuteStatementResp{}
}

var TSExecuteStatementResp_Status_DEFAULT *TSStatus
func (p *TSExecuteStatementResp) GetStatus() *TSStatus {
	if !p.IsSetStatus() {
		return TSExecuteStatementResp_Status_DEFAULT
	}
	return p.Status
}
var TSExecuteStatementResp_QueryId_DEFAULT int64
func (p *TSExecuteStatementResp) GetQueryId() int64 {
	if !p.IsSetQueryId() {
		return TSExecuteStatementResp_QueryId_DEFAULT
	}
	return *p.QueryId
}
var TSExecuteStatementResp_Columns_DEFAULT []string

func (p *TSExecuteStatementResp) GetColumns() []string {
	return p.Columns
}
var TSExecuteStatementResp_OperationType_DEFAULT string
func (p *TSExecuteStatementResp) GetOperationType() string {
	if !p.IsSetOperationType() {
		return TSExecuteStatementResp_OperationType_DEFAULT
	}
	return *p.OperationType
}
var TSExecuteStatementResp_IgnoreTimeStamp_DEFAULT bool
func (p *TSExecuteStatementResp) GetIgnoreTimeStamp() bool {
	if !p.IsSetIgnoreTimeStamp() {
		return TSExecuteStatementResp_IgnoreTimeStamp_DEFAULT
	}
	return *p.IgnoreTimeStamp
}
var TSExecuteStatementResp_DataTypeList_DEFAULT []string

func (p *TSExecuteStatementResp) GetDataTypeList() []string {
	return p.DataTypeList
}
var TSExecuteStatementResp_QueryDataSet_DEFAULT *TSQueryDataSet
func (p *TSExecuteStatementResp) GetQueryDataSet() *TSQueryDataSet {
	if !p.IsSetQueryDataSet() {
		return TSExecuteStatementResp_QueryDataSet_DEFAULT
	}
	return p.QueryDataSet
}
var TSExecuteStatementResp_NonAlignQueryDataSet_DEFAULT *TSQueryNonAlignDataSet
func (p *TSExecuteStatementResp) GetNonAlignQueryDataSet() *TSQueryNonAlignDataSet {
	if !p.IsSetNonAlignQueryDataSet() {
		return TSExecuteStatementResp_NonAlignQueryDataSet_DEFAULT
	}
	return p.NonAlignQueryDataSet
}
var TSExecuteStatementResp_ColumnNameIndexMap_DEFAULT map[string]int32

func (p *TSExecuteStatementResp) GetColumnNameIndexMap() map[string]int32 {
	return p.ColumnNameIndexMap
}
func (p *TSExecuteStatementResp) IsSetStatus() bool {
	return p.Status != nil
}

func (p *TSExecuteStatementResp) IsSetQueryId() bool {
	return p.QueryId != nil
}

func (p *TSExecuteStatementResp) IsSetColumns() bool {
	return p.Columns != nil
}

func (p *TSExecuteStatementResp) IsSetOperationType() bool {
	return p.OperationType != nil
}

func (p *TSExecuteStatementResp) IsSetIgnoreTimeStamp() bool {
	return p.IgnoreTimeStamp != nil
}

func (p *TSExecuteStatementResp) IsSetDataTypeList() bool {
	return p.DataTypeList != nil
}

func (p *TSExecuteStatementResp) IsSetQueryDataSet() bool {
	return p.QueryDataSet != nil
}

func (p *TSExecuteStatementResp) IsSetNonAlignQueryDataSet() bool {
	return p.NonAlignQueryDataSet != nil
}

func (p *TSExecuteStatementResp) IsSetColumnNameIndexMap() bool {
	return p.ColumnNameIndexMap != nil
}

func (p *TSExecuteStatementResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetStatus bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetStatus = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 9:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField9(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetStatus{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Status = &TSStatus{}
	if err := p.Status.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.QueryId = &v
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Columns =  tSlice
	for i := 0; i < size; i ++ {
		var _elem10 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem10 = v
		}
		p.Columns = append(p.Columns, _elem10)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.OperationType = &v
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.IgnoreTimeStamp = &v
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.DataTypeList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem11 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem11 = v
		}
		p.DataTypeList = append(p.DataTypeList, _elem11)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	p.QueryDataSet = &TSQueryDataSet{}
	if err := p.QueryDataSet.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.QueryDataSet), err)
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	p.NonAlignQueryDataSet = &TSQueryNonAlignDataSet{}
	if err := p.NonAlignQueryDataSet.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.NonAlignQueryDataSet), err)
	}
	return nil
}

func (p *TSExecuteStatementResp)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(map[string]int32, size)
	p.ColumnNameIndexMap =  tMap
	for i := 0; i < size; i ++ {
		var _key12 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key12 = v
		}
		var _val13 int32
		if v, err := iprot.ReadI32(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_val13 = v
		}
		p.ColumnNameIndexMap[_key12] = _val13
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *TSExecuteStatementResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSExecuteStatementResp"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
		if err := p.writeField6(ctx, oprot); err != nil { return err }
		if err := p.writeField7(ctx, oprot); err != nil { return err }
		if err := p.writeField8(ctx, oprot); err != nil { return err }
		if err := p.writeField9(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSExecuteStatementResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
	if err := p.Status.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
	return err
}

func (p *TSExecuteStatementResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetQueryId() {
		if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
		if err := oprot.WriteI64(ctx, int64(*p.QueryId)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetColumns() {
		if err := oprot.WriteFieldBegin(ctx, "columns", thrift.LIST, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columns: ", p), err) }
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Columns)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.Columns {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columns: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetOperationType() {
		if err := oprot.WriteFieldBegin(ctx, "operationType", thrift.STRING, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:operationType: ", p), err) }
		if err := oprot.WriteString(ctx, string(*p.OperationType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.operationType (4) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:operationType: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementResp) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetIgnoreTimeStamp() {
		if err := oprot.WriteFieldBegin(ctx, "ignoreTimeStamp", thrift.BOOL, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:ignoreTimeStamp: ", p), err) }
		if err := oprot.WriteBool(ctx, bool(*p.IgnoreTimeStamp)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.ignoreTimeStamp (5) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:ignoreTimeStamp: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementResp) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDataTypeList() {
		if err := oprot.WriteFieldBegin(ctx, "dataTypeList", thrift.LIST, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:dataTypeList: ", p), err) }
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.DataTypeList)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.DataTypeList {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:dataTypeList: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementResp) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetQueryDataSet() {
		if err := oprot.WriteFieldBegin(ctx, "queryDataSet", thrift.STRUCT, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:queryDataSet: ", p), err) }
		if err := p.QueryDataSet.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.QueryDataSet), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:queryDataSet: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementResp) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetNonAlignQueryDataSet() {
		if err := oprot.WriteFieldBegin(ctx, "nonAlignQueryDataSet", thrift.STRUCT, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:nonAlignQueryDataSet: ", p), err) }
		if err := p.NonAlignQueryDataSet.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.NonAlignQueryDataSet), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:nonAlignQueryDataSet: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementResp) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetColumnNameIndexMap() {
		if err := oprot.WriteFieldBegin(ctx, "columnNameIndexMap", thrift.MAP, 9); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:columnNameIndexMap: ", p), err) }
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.I32, len(p.ColumnNameIndexMap)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range p.ColumnNameIndexMap {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			if err := oprot.WriteI32(ctx, int32(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 9:columnNameIndexMap: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementResp) Equals(other *TSExecuteStatementResp) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.Status.Equals(other.Status) { return false }
	if p.QueryId != other.QueryId {
		if p.QueryId == nil || other.QueryId == nil {
			return false
		}
		if (*p.QueryId) != (*other.QueryId) { return false }
	}
	if len(p.Columns) != len(other.Columns) { return false }
	for i, _tgt := range p.Columns {
		_src14 := other.Columns[i]
		if _tgt != _src14 { return false }
	}
	if p.OperationType != other.OperationType {
		if p.OperationType == nil || other.OperationType == nil {
			return false
		}
		if (*p.OperationType) != (*other.OperationType) { return false }
	}
	if p.IgnoreTimeStamp != other.IgnoreTimeStamp {
		if p.IgnoreTimeStamp == nil || other.IgnoreTimeStamp == nil {
			return false
		}
		if (*p.IgnoreTimeStamp) != (*other.IgnoreTimeStamp) { return false }
	}
	if len(p.DataTypeList) != len(other.DataTypeList) { return false }
	for i, _tgt := range p.DataTypeList {
		_src15 := other.DataTypeList[i]
		if _tgt != _src15 { return false }
	}
	if !p.QueryDataSet.Equals(other.QueryDataSet) { return false }
	if !p.NonAlignQueryDataSet.Equals(other.NonAlignQueryDataSet) { return false }
	if len(p.ColumnNameIndexMap) != len(other.ColumnNameIndexMap) { return false }
	for k, _tgt := range p.ColumnNameIndexMap {
		_src16 := other.ColumnNameIndexMap[k]
		if _tgt != _src16 { return false }
	}
	return true
}

func (p *TSExecuteStatementResp) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSExecuteStatementResp(%+v)", *p)
}

// Attributes:
//  - Status
//  - ServerProtocolVersion
//  - SessionId
//  - Configuration
type TSOpenSessionResp struct {
	Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
	ServerProtocolVersion TSProtocolVersion `thrift:"serverProtocolVersion,2,required" db:"serverProtocolVersion" json:"serverProtocolVersion"`
	SessionId *int64 `thrift:"sessionId,3" db:"sessionId" json:"sessionId,omitempty"`
	Configuration map[string]string `thrift:"configuration,4" db:"configuration" json:"configuration,omitempty"`
}

func NewTSOpenSessionResp() *TSOpenSessionResp {
	return &TSOpenSessionResp{
		ServerProtocolVersion: 0,
	}
}

var TSOpenSessionResp_Status_DEFAULT *TSStatus
func (p *TSOpenSessionResp) GetStatus() *TSStatus {
	if !p.IsSetStatus() {
		return TSOpenSessionResp_Status_DEFAULT
	}
	return p.Status
}

func (p *TSOpenSessionResp) GetServerProtocolVersion() TSProtocolVersion {
	return p.ServerProtocolVersion
}
var TSOpenSessionResp_SessionId_DEFAULT int64
func (p *TSOpenSessionResp) GetSessionId() int64 {
	if !p.IsSetSessionId() {
		return TSOpenSessionResp_SessionId_DEFAULT
	}
	return *p.SessionId
}
var TSOpenSessionResp_Configuration_DEFAULT map[string]string

func (p *TSOpenSessionResp) GetConfiguration() map[string]string {
	return p.Configuration
}
func (p *TSOpenSessionResp) IsSetStatus() bool {
	return p.Status != nil
}

func (p *TSOpenSessionResp) IsSetSessionId() bool {
	return p.SessionId != nil
}

func (p *TSOpenSessionResp) IsSetConfiguration() bool {
	return p.Configuration != nil
}

func (p *TSOpenSessionResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetStatus bool = false;
	var issetServerProtocolVersion bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetStatus = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetServerProtocolVersion = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetStatus{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
	}
	if !issetServerProtocolVersion{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ServerProtocolVersion is not set"));
	}
	return nil
}

func (p *TSOpenSessionResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Status = &TSStatus{}
	if err := p.Status.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
	}
	return nil
}

func (p *TSOpenSessionResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		temp := TSProtocolVersion(v)
		p.ServerProtocolVersion = temp
	}
	return nil
}

func (p *TSOpenSessionResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.SessionId = &v
	}
	return nil
}

func (p *TSOpenSessionResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(map[string]string, size)
	p.Configuration =  tMap
	for i := 0; i < size; i ++ {
		var _key17 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key17 = v
		}
		var _val18 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_val18 = v
		}
		p.Configuration[_key17] = _val18
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *TSOpenSessionResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSOpenSessionResp"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSOpenSessionResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
	if err := p.Status.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
	return err
}

func (p *TSOpenSessionResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "serverProtocolVersion", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:serverProtocolVersion: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.ServerProtocolVersion)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.serverProtocolVersion (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:serverProtocolVersion: ", p), err) }
	return err
}

func (p *TSOpenSessionResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSessionId() {
		if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:sessionId: ", p), err) }
		if err := oprot.WriteI64(ctx, int64(*p.SessionId)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.sessionId (3) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:sessionId: ", p), err) }
	}
	return err
}

func (p *TSOpenSessionResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetConfiguration() {
		if err := oprot.WriteFieldBegin(ctx, "configuration", thrift.MAP, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:configuration: ", p), err) }
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Configuration)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range p.Configuration {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:configuration: ", p), err) }
	}
	return err
}

func (p *TSOpenSessionResp) Equals(other *TSOpenSessionResp) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.Status.Equals(other.Status) { return false }
	if p.ServerProtocolVersion != other.ServerProtocolVersion { return false }
	if p.SessionId != other.SessionId {
		if p.SessionId == nil || other.SessionId == nil {
			return false
		}
		if (*p.SessionId) != (*other.SessionId) { return false }
	}
	if len(p.Configuration) != len(other.Configuration) { return false }
	for k, _tgt := range p.Configuration {
		_src19 := other.Configuration[k]
		if _tgt != _src19 { return false }
	}
	return true
}

func (p *TSOpenSessionResp) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSOpenSessionResp(%+v)", *p)
}

// Attributes:
//  - ClientProtocol
//  - ZoneId
//  - Username
//  - Password
//  - Configuration
type TSOpenSessionReq struct {
	ClientProtocol TSProtocolVersion `thrift:"client_protocol,1,required" db:"client_protocol" json:"client_protocol"`
	ZoneId string `thrift:"zoneId,2,required" db:"zoneId" json:"zoneId"`
	Username *string `thrift:"username,3" db:"username" json:"username,omitempty"`
	Password *string `thrift:"password,4" db:"password" json:"password,omitempty"`
	Configuration map[string]string `thrift:"configuration,5" db:"configuration" json:"configuration,omitempty"`
}

func NewTSOpenSessionReq() *TSOpenSessionReq {
	return &TSOpenSessionReq{
		ClientProtocol: 2,
	}
}


func (p *TSOpenSessionReq) GetClientProtocol() TSProtocolVersion {
	return p.ClientProtocol
}

func (p *TSOpenSessionReq) GetZoneId() string {
	return p.ZoneId
}
var TSOpenSessionReq_Username_DEFAULT string
func (p *TSOpenSessionReq) GetUsername() string {
	if !p.IsSetUsername() {
		return TSOpenSessionReq_Username_DEFAULT
	}
	return *p.Username
}
var TSOpenSessionReq_Password_DEFAULT string
func (p *TSOpenSessionReq) GetPassword() string {
	if !p.IsSetPassword() {
		return TSOpenSessionReq_Password_DEFAULT
	}
	return *p.Password
}
var TSOpenSessionReq_Configuration_DEFAULT map[string]string

func (p *TSOpenSessionReq) GetConfiguration() map[string]string {
	return p.Configuration
}
func (p *TSOpenSessionReq) IsSetUsername() bool {
	return p.Username != nil
}

func (p *TSOpenSessionReq) IsSetPassword() bool {
	return p.Password != nil
}

func (p *TSOpenSessionReq) IsSetConfiguration() bool {
	return p.Configuration != nil
}

func (p *TSOpenSessionReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetClientProtocol bool = false;
	var issetZoneId bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetClientProtocol = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetZoneId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetClientProtocol{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ClientProtocol is not set"));
	}
	if !issetZoneId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ZoneId is not set"));
	}
	return nil
}

func (p *TSOpenSessionReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		temp := TSProtocolVersion(v)
		p.ClientProtocol = temp
	}
	return nil
}

func (p *TSOpenSessionReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.ZoneId = v
	}
	return nil
}

func (p *TSOpenSessionReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.Username = &v
	}
	return nil
}

func (p *TSOpenSessionReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.Password = &v
	}
	return nil
}

func (p *TSOpenSessionReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(map[string]string, size)
	p.Configuration =  tMap
	for i := 0; i < size; i ++ {
		var _key20 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key20 = v
		}
		var _val21 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_val21 = v
		}
		p.Configuration[_key20] = _val21
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *TSOpenSessionReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSOpenSessionReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSOpenSessionReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "client_protocol", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:client_protocol: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.ClientProtocol)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.client_protocol (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:client_protocol: ", p), err) }
	return err
}

func (p *TSOpenSessionReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "zoneId", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:zoneId: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.ZoneId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.zoneId (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:zoneId: ", p), err) }
	return err
}

func (p *TSOpenSessionReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetUsername() {
		if err := oprot.WriteFieldBegin(ctx, "username", thrift.STRING, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:username: ", p), err) }
		if err := oprot.WriteString(ctx, string(*p.Username)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.username (3) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:username: ", p), err) }
	}
	return err
}

func (p *TSOpenSessionReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetPassword() {
		if err := oprot.WriteFieldBegin(ctx, "password", thrift.STRING, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:password: ", p), err) }
		if err := oprot.WriteString(ctx, string(*p.Password)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.password (4) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:password: ", p), err) }
	}
	return err
}

func (p *TSOpenSessionReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetConfiguration() {
		if err := oprot.WriteFieldBegin(ctx, "configuration", thrift.MAP, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:configuration: ", p), err) }
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Configuration)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range p.Configuration {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:configuration: ", p), err) }
	}
	return err
}

func (p *TSOpenSessionReq) Equals(other *TSOpenSessionReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.ClientProtocol != other.ClientProtocol { return false }
	if p.ZoneId != other.ZoneId { return false }
	if p.Username != other.Username {
		if p.Username == nil || other.Username == nil {
			return false
		}
		if (*p.Username) != (*other.Username) { return false }
	}
	if p.Password != other.Password {
		if p.Password == nil || other.Password == nil {
			return false
		}
		if (*p.Password) != (*other.Password) { return false }
	}
	if len(p.Configuration) != len(other.Configuration) { return false }
	for k, _tgt := range p.Configuration {
		_src22 := other.Configuration[k]
		if _tgt != _src22 { return false }
	}
	return true
}

func (p *TSOpenSessionReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSOpenSessionReq(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSCloseSessionReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
}

func NewTSCloseSessionReq() *TSCloseSessionReq {
	return &TSCloseSessionReq{}
}


func (p *TSCloseSessionReq) GetSessionId() int64 {
	return p.SessionId
}
func (p *TSCloseSessionReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	return nil
}

func (p *TSCloseSessionReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSCloseSessionReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSCloseSessionReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSCloseSessionReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSCloseSessionReq) Equals(other *TSCloseSessionReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	return true
}

func (p *TSCloseSessionReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSCloseSessionReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statement
//  - StatementId
//  - FetchSize
//  - Timeout
//  - EnableRedirectQuery
type TSExecuteStatementReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	Statement string `thrift:"statement,2,required" db:"statement" json:"statement"`
	StatementId int64 `thrift:"statementId,3,required" db:"statementId" json:"statementId"`
	FetchSize *int32 `thrift:"fetchSize,4" db:"fetchSize" json:"fetchSize,omitempty"`
	Timeout *int64 `thrift:"timeout,5" db:"timeout" json:"timeout,omitempty"`
	EnableRedirectQuery *bool `thrift:"enableRedirectQuery,6" db:"enableRedirectQuery" json:"enableRedirectQuery,omitempty"`
}

func NewTSExecuteStatementReq() *TSExecuteStatementReq {
	return &TSExecuteStatementReq{}
}


func (p *TSExecuteStatementReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSExecuteStatementReq) GetStatement() string {
	return p.Statement
}

func (p *TSExecuteStatementReq) GetStatementId() int64 {
	return p.StatementId
}
var TSExecuteStatementReq_FetchSize_DEFAULT int32
func (p *TSExecuteStatementReq) GetFetchSize() int32 {
	if !p.IsSetFetchSize() {
		return TSExecuteStatementReq_FetchSize_DEFAULT
	}
	return *p.FetchSize
}
var TSExecuteStatementReq_Timeout_DEFAULT int64
func (p *TSExecuteStatementReq) GetTimeout() int64 {
	if !p.IsSetTimeout() {
		return TSExecuteStatementReq_Timeout_DEFAULT
	}
	return *p.Timeout
}
var TSExecuteStatementReq_EnableRedirectQuery_DEFAULT bool
func (p *TSExecuteStatementReq) GetEnableRedirectQuery() bool {
	if !p.IsSetEnableRedirectQuery() {
		return TSExecuteStatementReq_EnableRedirectQuery_DEFAULT
	}
	return *p.EnableRedirectQuery
}
func (p *TSExecuteStatementReq) IsSetFetchSize() bool {
	return p.FetchSize != nil
}

func (p *TSExecuteStatementReq) IsSetTimeout() bool {
	return p.Timeout != nil
}

func (p *TSExecuteStatementReq) IsSetEnableRedirectQuery() bool {
	return p.EnableRedirectQuery != nil
}

func (p *TSExecuteStatementReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetStatement bool = false;
	var issetStatementId bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetStatement = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetStatementId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetStatement{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statement is not set"));
	}
	if !issetStatementId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
	}
	return nil
}

func (p *TSExecuteStatementReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSExecuteStatementReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Statement = v
	}
	return nil
}

func (p *TSExecuteStatementReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.StatementId = v
	}
	return nil
}

func (p *TSExecuteStatementReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.FetchSize = &v
	}
	return nil
}

func (p *TSExecuteStatementReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Timeout = &v
	}
	return nil
}

func (p *TSExecuteStatementReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.EnableRedirectQuery = &v
	}
	return nil
}

func (p *TSExecuteStatementReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSExecuteStatementReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
		if err := p.writeField6(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSExecuteStatementReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSExecuteStatementReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "statement", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statement: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.Statement)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.statement (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statement: ", p), err) }
	return err
}

func (p *TSExecuteStatementReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:statementId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.statementId (3) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:statementId: ", p), err) }
	return err
}

func (p *TSExecuteStatementReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetFetchSize() {
		if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:fetchSize: ", p), err) }
		if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.fetchSize (4) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:fetchSize: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTimeout() {
		if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timeout: ", p), err) }
		if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.timeout (5) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timeout: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetEnableRedirectQuery() {
		if err := oprot.WriteFieldBegin(ctx, "enableRedirectQuery", thrift.BOOL, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:enableRedirectQuery: ", p), err) }
		if err := oprot.WriteBool(ctx, bool(*p.EnableRedirectQuery)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.enableRedirectQuery (6) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:enableRedirectQuery: ", p), err) }
	}
	return err
}

func (p *TSExecuteStatementReq) Equals(other *TSExecuteStatementReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.Statement != other.Statement { return false }
	if p.StatementId != other.StatementId { return false }
	if p.FetchSize != other.FetchSize {
		if p.FetchSize == nil || other.FetchSize == nil {
			return false
		}
		if (*p.FetchSize) != (*other.FetchSize) { return false }
	}
	if p.Timeout != other.Timeout {
		if p.Timeout == nil || other.Timeout == nil {
			return false
		}
		if (*p.Timeout) != (*other.Timeout) { return false }
	}
	if p.EnableRedirectQuery != other.EnableRedirectQuery {
		if p.EnableRedirectQuery == nil || other.EnableRedirectQuery == nil {
			return false
		}
		if (*p.EnableRedirectQuery) != (*other.EnableRedirectQuery) { return false }
	}
	return true
}

func (p *TSExecuteStatementReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSExecuteStatementReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statements
type TSExecuteBatchStatementReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	Statements []string `thrift:"statements,2,required" db:"statements" json:"statements"`
}

func NewTSExecuteBatchStatementReq() *TSExecuteBatchStatementReq {
	return &TSExecuteBatchStatementReq{}
}


func (p *TSExecuteBatchStatementReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSExecuteBatchStatementReq) GetStatements() []string {
	return p.Statements
}
func (p *TSExecuteBatchStatementReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetStatements bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetStatements = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetStatements{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statements is not set"));
	}
	return nil
}

func (p *TSExecuteBatchStatementReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSExecuteBatchStatementReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Statements =  tSlice
	for i := 0; i < size; i ++ {
		var _elem23 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem23 = v
		}
		p.Statements = append(p.Statements, _elem23)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSExecuteBatchStatementReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSExecuteBatchStatementReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSExecuteBatchStatementReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSExecuteBatchStatementReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "statements", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statements: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Statements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Statements {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statements: ", p), err) }
	return err
}

func (p *TSExecuteBatchStatementReq) Equals(other *TSExecuteBatchStatementReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if len(p.Statements) != len(other.Statements) { return false }
	for i, _tgt := range p.Statements {
		_src24 := other.Statements[i]
		if _tgt != _src24 { return false }
	}
	return true
}

func (p *TSExecuteBatchStatementReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSExecuteBatchStatementReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
type TSGetOperationStatusReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	QueryId int64 `thrift:"queryId,2,required" db:"queryId" json:"queryId"`
}

func NewTSGetOperationStatusReq() *TSGetOperationStatusReq {
	return &TSGetOperationStatusReq{}
}


func (p *TSGetOperationStatusReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSGetOperationStatusReq) GetQueryId() int64 {
	return p.QueryId
}
func (p *TSGetOperationStatusReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetQueryId bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetQueryId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetQueryId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
	}
	return nil
}

func (p *TSGetOperationStatusReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSGetOperationStatusReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.QueryId = v
	}
	return nil
}

func (p *TSGetOperationStatusReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSGetOperationStatusReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSGetOperationStatusReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSGetOperationStatusReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
	return err
}

func (p *TSGetOperationStatusReq) Equals(other *TSGetOperationStatusReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.QueryId != other.QueryId { return false }
	return true
}

func (p *TSGetOperationStatusReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSGetOperationStatusReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
type TSCancelOperationReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	QueryId int64 `thrift:"queryId,2,required" db:"queryId" json:"queryId"`
}

func NewTSCancelOperationReq() *TSCancelOperationReq {
	return &TSCancelOperationReq{}
}


func (p *TSCancelOperationReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSCancelOperationReq) GetQueryId() int64 {
	return p.QueryId
}
func (p *TSCancelOperationReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetQueryId bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetQueryId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetQueryId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
	}
	return nil
}

func (p *TSCancelOperationReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSCancelOperationReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.QueryId = v
	}
	return nil
}

func (p *TSCancelOperationReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSCancelOperationReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSCancelOperationReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSCancelOperationReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
	return err
}

func (p *TSCancelOperationReq) Equals(other *TSCancelOperationReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.QueryId != other.QueryId { return false }
	return true
}

func (p *TSCancelOperationReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSCancelOperationReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
//  - StatementId
type TSCloseOperationReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	QueryId *int64 `thrift:"queryId,2" db:"queryId" json:"queryId,omitempty"`
	StatementId *int64 `thrift:"statementId,3" db:"statementId" json:"statementId,omitempty"`
}

func NewTSCloseOperationReq() *TSCloseOperationReq {
	return &TSCloseOperationReq{}
}


func (p *TSCloseOperationReq) GetSessionId() int64 {
	return p.SessionId
}
var TSCloseOperationReq_QueryId_DEFAULT int64
func (p *TSCloseOperationReq) GetQueryId() int64 {
	if !p.IsSetQueryId() {
		return TSCloseOperationReq_QueryId_DEFAULT
	}
	return *p.QueryId
}
var TSCloseOperationReq_StatementId_DEFAULT int64
func (p *TSCloseOperationReq) GetStatementId() int64 {
	if !p.IsSetStatementId() {
		return TSCloseOperationReq_StatementId_DEFAULT
	}
	return *p.StatementId
}
func (p *TSCloseOperationReq) IsSetQueryId() bool {
	return p.QueryId != nil
}

func (p *TSCloseOperationReq) IsSetStatementId() bool {
	return p.StatementId != nil
}

func (p *TSCloseOperationReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	return nil
}

func (p *TSCloseOperationReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSCloseOperationReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.QueryId = &v
	}
	return nil
}

func (p *TSCloseOperationReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.StatementId = &v
	}
	return nil
}

func (p *TSCloseOperationReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSCloseOperationReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSCloseOperationReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSCloseOperationReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetQueryId() {
		if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
		if err := oprot.WriteI64(ctx, int64(*p.QueryId)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
	}
	return err
}

func (p *TSCloseOperationReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetStatementId() {
		if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:statementId: ", p), err) }
		if err := oprot.WriteI64(ctx, int64(*p.StatementId)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.statementId (3) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:statementId: ", p), err) }
	}
	return err
}

func (p *TSCloseOperationReq) Equals(other *TSCloseOperationReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.QueryId != other.QueryId {
		if p.QueryId == nil || other.QueryId == nil {
			return false
		}
		if (*p.QueryId) != (*other.QueryId) { return false }
	}
	if p.StatementId != other.StatementId {
		if p.StatementId == nil || other.StatementId == nil {
			return false
		}
		if (*p.StatementId) != (*other.StatementId) { return false }
	}
	return true
}

func (p *TSCloseOperationReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSCloseOperationReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statement
//  - FetchSize
//  - QueryId
//  - IsAlign
//  - Timeout
type TSFetchResultsReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	Statement string `thrift:"statement,2,required" db:"statement" json:"statement"`
	FetchSize int32 `thrift:"fetchSize,3,required" db:"fetchSize" json:"fetchSize"`
	QueryId int64 `thrift:"queryId,4,required" db:"queryId" json:"queryId"`
	IsAlign bool `thrift:"isAlign,5,required" db:"isAlign" json:"isAlign"`
	Timeout *int64 `thrift:"timeout,6" db:"timeout" json:"timeout,omitempty"`
}

func NewTSFetchResultsReq() *TSFetchResultsReq {
	return &TSFetchResultsReq{}
}


func (p *TSFetchResultsReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSFetchResultsReq) GetStatement() string {
	return p.Statement
}

func (p *TSFetchResultsReq) GetFetchSize() int32 {
	return p.FetchSize
}

func (p *TSFetchResultsReq) GetQueryId() int64 {
	return p.QueryId
}

func (p *TSFetchResultsReq) GetIsAlign() bool {
	return p.IsAlign
}
var TSFetchResultsReq_Timeout_DEFAULT int64
func (p *TSFetchResultsReq) GetTimeout() int64 {
	if !p.IsSetTimeout() {
		return TSFetchResultsReq_Timeout_DEFAULT
	}
	return *p.Timeout
}
func (p *TSFetchResultsReq) IsSetTimeout() bool {
	return p.Timeout != nil
}

func (p *TSFetchResultsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetStatement bool = false;
	var issetFetchSize bool = false;
	var issetQueryId bool = false;
	var issetIsAlign bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetStatement = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetFetchSize = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetQueryId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetIsAlign = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetStatement{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statement is not set"));
	}
	if !issetFetchSize{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FetchSize is not set"));
	}
	if !issetQueryId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
	}
	if !issetIsAlign{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAlign is not set"));
	}
	return nil
}

func (p *TSFetchResultsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSFetchResultsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Statement = v
	}
	return nil
}

func (p *TSFetchResultsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.FetchSize = v
	}
	return nil
}

func (p *TSFetchResultsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.QueryId = v
	}
	return nil
}

func (p *TSFetchResultsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.IsAlign = v
	}
	return nil
}

func (p *TSFetchResultsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.Timeout = &v
	}
	return nil
}

func (p *TSFetchResultsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSFetchResultsReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
		if err := p.writeField6(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSFetchResultsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSFetchResultsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "statement", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statement: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.Statement)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.statement (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statement: ", p), err) }
	return err
}

func (p *TSFetchResultsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:fetchSize: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.FetchSize)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.fetchSize (3) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:fetchSize: ", p), err) }
	return err
}

func (p *TSFetchResultsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.queryId (4) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryId: ", p), err) }
	return err
}

func (p *TSFetchResultsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "isAlign", thrift.BOOL, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:isAlign: ", p), err) }
	if err := oprot.WriteBool(ctx, bool(p.IsAlign)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.isAlign (5) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:isAlign: ", p), err) }
	return err
}

func (p *TSFetchResultsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTimeout() {
		if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:timeout: ", p), err) }
		if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.timeout (6) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:timeout: ", p), err) }
	}
	return err
}

func (p *TSFetchResultsReq) Equals(other *TSFetchResultsReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.Statement != other.Statement { return false }
	if p.FetchSize != other.FetchSize { return false }
	if p.QueryId != other.QueryId { return false }
	if p.IsAlign != other.IsAlign { return false }
	if p.Timeout != other.Timeout {
		if p.Timeout == nil || other.Timeout == nil {
			return false
		}
		if (*p.Timeout) != (*other.Timeout) { return false }
	}
	return true
}

func (p *TSFetchResultsReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSFetchResultsReq(%+v)", *p)
}

// Attributes:
//  - Status
//  - HasResultSet
//  - IsAlign
//  - QueryDataSet
//  - NonAlignQueryDataSet
type TSFetchResultsResp struct {
	Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
	HasResultSet bool `thrift:"hasResultSet,2,required" db:"hasResultSet" json:"hasResultSet"`
	IsAlign bool `thrift:"isAlign,3,required" db:"isAlign" json:"isAlign"`
	QueryDataSet *TSQueryDataSet `thrift:"queryDataSet,4" db:"queryDataSet" json:"queryDataSet,omitempty"`
	NonAlignQueryDataSet *TSQueryNonAlignDataSet `thrift:"nonAlignQueryDataSet,5" db:"nonAlignQueryDataSet" json:"nonAlignQueryDataSet,omitempty"`
}

func NewTSFetchResultsResp() *TSFetchResultsResp {
	return &TSFetchResultsResp{}
}

var TSFetchResultsResp_Status_DEFAULT *TSStatus
func (p *TSFetchResultsResp) GetStatus() *TSStatus {
	if !p.IsSetStatus() {
		return TSFetchResultsResp_Status_DEFAULT
	}
	return p.Status
}

func (p *TSFetchResultsResp) GetHasResultSet() bool {
	return p.HasResultSet
}

func (p *TSFetchResultsResp) GetIsAlign() bool {
	return p.IsAlign
}
var TSFetchResultsResp_QueryDataSet_DEFAULT *TSQueryDataSet
func (p *TSFetchResultsResp) GetQueryDataSet() *TSQueryDataSet {
	if !p.IsSetQueryDataSet() {
		return TSFetchResultsResp_QueryDataSet_DEFAULT
	}
	return p.QueryDataSet
}
var TSFetchResultsResp_NonAlignQueryDataSet_DEFAULT *TSQueryNonAlignDataSet
func (p *TSFetchResultsResp) GetNonAlignQueryDataSet() *TSQueryNonAlignDataSet {
	if !p.IsSetNonAlignQueryDataSet() {
		return TSFetchResultsResp_NonAlignQueryDataSet_DEFAULT
	}
	return p.NonAlignQueryDataSet
}
func (p *TSFetchResultsResp) IsSetStatus() bool {
	return p.Status != nil
}

func (p *TSFetchResultsResp) IsSetQueryDataSet() bool {
	return p.QueryDataSet != nil
}

func (p *TSFetchResultsResp) IsSetNonAlignQueryDataSet() bool {
	return p.NonAlignQueryDataSet != nil
}

func (p *TSFetchResultsResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetStatus bool = false;
	var issetHasResultSet bool = false;
	var issetIsAlign bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetStatus = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetHasResultSet = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetIsAlign = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetStatus{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
	}
	if !issetHasResultSet{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field HasResultSet is not set"));
	}
	if !issetIsAlign{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAlign is not set"));
	}
	return nil
}

func (p *TSFetchResultsResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Status = &TSStatus{}
	if err := p.Status.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
	}
	return nil
}

func (p *TSFetchResultsResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.HasResultSet = v
	}
	return nil
}

func (p *TSFetchResultsResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.IsAlign = v
	}
	return nil
}

func (p *TSFetchResultsResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	p.QueryDataSet = &TSQueryDataSet{}
	if err := p.QueryDataSet.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.QueryDataSet), err)
	}
	return nil
}

func (p *TSFetchResultsResp)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	p.NonAlignQueryDataSet = &TSQueryNonAlignDataSet{}
	if err := p.NonAlignQueryDataSet.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.NonAlignQueryDataSet), err)
	}
	return nil
}

func (p *TSFetchResultsResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSFetchResultsResp"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSFetchResultsResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
	if err := p.Status.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
	return err
}

func (p *TSFetchResultsResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "hasResultSet", thrift.BOOL, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:hasResultSet: ", p), err) }
	if err := oprot.WriteBool(ctx, bool(p.HasResultSet)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.hasResultSet (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:hasResultSet: ", p), err) }
	return err
}

func (p *TSFetchResultsResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "isAlign", thrift.BOOL, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:isAlign: ", p), err) }
	if err := oprot.WriteBool(ctx, bool(p.IsAlign)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.isAlign (3) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:isAlign: ", p), err) }
	return err
}

func (p *TSFetchResultsResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetQueryDataSet() {
		if err := oprot.WriteFieldBegin(ctx, "queryDataSet", thrift.STRUCT, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryDataSet: ", p), err) }
		if err := p.QueryDataSet.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.QueryDataSet), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryDataSet: ", p), err) }
	}
	return err
}

func (p *TSFetchResultsResp) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetNonAlignQueryDataSet() {
		if err := oprot.WriteFieldBegin(ctx, "nonAlignQueryDataSet", thrift.STRUCT, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:nonAlignQueryDataSet: ", p), err) }
		if err := p.NonAlignQueryDataSet.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.NonAlignQueryDataSet), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:nonAlignQueryDataSet: ", p), err) }
	}
	return err
}

func (p *TSFetchResultsResp) Equals(other *TSFetchResultsResp) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.Status.Equals(other.Status) { return false }
	if p.HasResultSet != other.HasResultSet { return false }
	if p.IsAlign != other.IsAlign { return false }
	if !p.QueryDataSet.Equals(other.QueryDataSet) { return false }
	if !p.NonAlignQueryDataSet.Equals(other.NonAlignQueryDataSet) { return false }
	return true
}

func (p *TSFetchResultsResp) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSFetchResultsResp(%+v)", *p)
}

// Attributes:
//  - Status
//  - MetadataInJson
//  - ColumnsList
//  - DataType
type TSFetchMetadataResp struct {
	Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
	MetadataInJson *string `thrift:"metadataInJson,2" db:"metadataInJson" json:"metadataInJson,omitempty"`
	ColumnsList []string `thrift:"columnsList,3" db:"columnsList" json:"columnsList,omitempty"`
	DataType *string `thrift:"dataType,4" db:"dataType" json:"dataType,omitempty"`
}

func NewTSFetchMetadataResp() *TSFetchMetadataResp {
	return &TSFetchMetadataResp{}
}

var TSFetchMetadataResp_Status_DEFAULT *TSStatus
func (p *TSFetchMetadataResp) GetStatus() *TSStatus {
	if !p.IsSetStatus() {
		return TSFetchMetadataResp_Status_DEFAULT
	}
	return p.Status
}
var TSFetchMetadataResp_MetadataInJson_DEFAULT string
func (p *TSFetchMetadataResp) GetMetadataInJson() string {
	if !p.IsSetMetadataInJson() {
		return TSFetchMetadataResp_MetadataInJson_DEFAULT
	}
	return *p.MetadataInJson
}
var TSFetchMetadataResp_ColumnsList_DEFAULT []string

func (p *TSFetchMetadataResp) GetColumnsList() []string {
	return p.ColumnsList
}
var TSFetchMetadataResp_DataType_DEFAULT string
func (p *TSFetchMetadataResp) GetDataType() string {
	if !p.IsSetDataType() {
		return TSFetchMetadataResp_DataType_DEFAULT
	}
	return *p.DataType
}
func (p *TSFetchMetadataResp) IsSetStatus() bool {
	return p.Status != nil
}

func (p *TSFetchMetadataResp) IsSetMetadataInJson() bool {
	return p.MetadataInJson != nil
}

func (p *TSFetchMetadataResp) IsSetColumnsList() bool {
	return p.ColumnsList != nil
}

func (p *TSFetchMetadataResp) IsSetDataType() bool {
	return p.DataType != nil
}

func (p *TSFetchMetadataResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetStatus bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetStatus = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetStatus{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
	}
	return nil
}

func (p *TSFetchMetadataResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Status = &TSStatus{}
	if err := p.Status.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
	}
	return nil
}

func (p *TSFetchMetadataResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.MetadataInJson = &v
	}
	return nil
}

func (p *TSFetchMetadataResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.ColumnsList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem25 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem25 = v
		}
		p.ColumnsList = append(p.ColumnsList, _elem25)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSFetchMetadataResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.DataType = &v
	}
	return nil
}

func (p *TSFetchMetadataResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSFetchMetadataResp"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSFetchMetadataResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
	if err := p.Status.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
	return err
}

func (p *TSFetchMetadataResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMetadataInJson() {
		if err := oprot.WriteFieldBegin(ctx, "metadataInJson", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:metadataInJson: ", p), err) }
		if err := oprot.WriteString(ctx, string(*p.MetadataInJson)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.metadataInJson (2) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:metadataInJson: ", p), err) }
	}
	return err
}

func (p *TSFetchMetadataResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetColumnsList() {
		if err := oprot.WriteFieldBegin(ctx, "columnsList", thrift.LIST, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columnsList: ", p), err) }
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ColumnsList)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.ColumnsList {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columnsList: ", p), err) }
	}
	return err
}

func (p *TSFetchMetadataResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetDataType() {
		if err := oprot.WriteFieldBegin(ctx, "dataType", thrift.STRING, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:dataType: ", p), err) }
		if err := oprot.WriteString(ctx, string(*p.DataType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.dataType (4) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:dataType: ", p), err) }
	}
	return err
}

func (p *TSFetchMetadataResp) Equals(other *TSFetchMetadataResp) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.Status.Equals(other.Status) { return false }
	if p.MetadataInJson != other.MetadataInJson {
		if p.MetadataInJson == nil || other.MetadataInJson == nil {
			return false
		}
		if (*p.MetadataInJson) != (*other.MetadataInJson) { return false }
	}
	if len(p.ColumnsList) != len(other.ColumnsList) { return false }
	for i, _tgt := range p.ColumnsList {
		_src26 := other.ColumnsList[i]
		if _tgt != _src26 { return false }
	}
	if p.DataType != other.DataType {
		if p.DataType == nil || other.DataType == nil {
			return false
		}
		if (*p.DataType) != (*other.DataType) { return false }
	}
	return true
}

func (p *TSFetchMetadataResp) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSFetchMetadataResp(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Type
//  - ColumnPath
type TSFetchMetadataReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	Type string `thrift:"type,2,required" db:"type" json:"type"`
	ColumnPath *string `thrift:"columnPath,3" db:"columnPath" json:"columnPath,omitempty"`
}

func NewTSFetchMetadataReq() *TSFetchMetadataReq {
	return &TSFetchMetadataReq{}
}


func (p *TSFetchMetadataReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSFetchMetadataReq) GetType() string {
	return p.Type
}
var TSFetchMetadataReq_ColumnPath_DEFAULT string
func (p *TSFetchMetadataReq) GetColumnPath() string {
	if !p.IsSetColumnPath() {
		return TSFetchMetadataReq_ColumnPath_DEFAULT
	}
	return *p.ColumnPath
}
func (p *TSFetchMetadataReq) IsSetColumnPath() bool {
	return p.ColumnPath != nil
}

func (p *TSFetchMetadataReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetType bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetType = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetType{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Type is not set"));
	}
	return nil
}

func (p *TSFetchMetadataReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSFetchMetadataReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Type = v
	}
	return nil
}

func (p *TSFetchMetadataReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.ColumnPath = &v
	}
	return nil
}

func (p *TSFetchMetadataReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSFetchMetadataReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSFetchMetadataReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSFetchMetadataReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "type", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:type: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.Type)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.type (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:type: ", p), err) }
	return err
}

func (p *TSFetchMetadataReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetColumnPath() {
		if err := oprot.WriteFieldBegin(ctx, "columnPath", thrift.STRING, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columnPath: ", p), err) }
		if err := oprot.WriteString(ctx, string(*p.ColumnPath)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.columnPath (3) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columnPath: ", p), err) }
	}
	return err
}

func (p *TSFetchMetadataReq) Equals(other *TSFetchMetadataReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.Type != other.Type { return false }
	if p.ColumnPath != other.ColumnPath {
		if p.ColumnPath == nil || other.ColumnPath == nil {
			return false
		}
		if (*p.ColumnPath) != (*other.ColumnPath) { return false }
	}
	return true
}

func (p *TSFetchMetadataReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSFetchMetadataReq(%+v)", *p)
}

// Attributes:
//  - Status
//  - TimeZone
type TSGetTimeZoneResp struct {
	Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
	TimeZone string `thrift:"timeZone,2,required" db:"timeZone" json:"timeZone"`
}

func NewTSGetTimeZoneResp() *TSGetTimeZoneResp {
	return &TSGetTimeZoneResp{}
}

var TSGetTimeZoneResp_Status_DEFAULT *TSStatus
func (p *TSGetTimeZoneResp) GetStatus() *TSStatus {
	if !p.IsSetStatus() {
		return TSGetTimeZoneResp_Status_DEFAULT
	}
	return p.Status
}

func (p *TSGetTimeZoneResp) GetTimeZone() string {
	return p.TimeZone
}
func (p *TSGetTimeZoneResp) IsSetStatus() bool {
	return p.Status != nil
}

func (p *TSGetTimeZoneResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetStatus bool = false;
	var issetTimeZone bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetStatus = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetTimeZone = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetStatus{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
	}
	if !issetTimeZone{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeZone is not set"));
	}
	return nil
}

func (p *TSGetTimeZoneResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Status = &TSStatus{}
	if err := p.Status.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
	}
	return nil
}

func (p *TSGetTimeZoneResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.TimeZone = v
	}
	return nil
}

func (p *TSGetTimeZoneResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSGetTimeZoneResp"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSGetTimeZoneResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
	if err := p.Status.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
	return err
}

func (p *TSGetTimeZoneResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timeZone", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeZone: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.TimeZone)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.timeZone (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeZone: ", p), err) }
	return err
}

func (p *TSGetTimeZoneResp) Equals(other *TSGetTimeZoneResp) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.Status.Equals(other.Status) { return false }
	if p.TimeZone != other.TimeZone { return false }
	return true
}

func (p *TSGetTimeZoneResp) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSGetTimeZoneResp(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - TimeZone
type TSSetTimeZoneReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	TimeZone string `thrift:"timeZone,2,required" db:"timeZone" json:"timeZone"`
}

func NewTSSetTimeZoneReq() *TSSetTimeZoneReq {
	return &TSSetTimeZoneReq{}
}


func (p *TSSetTimeZoneReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSSetTimeZoneReq) GetTimeZone() string {
	return p.TimeZone
}
func (p *TSSetTimeZoneReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetTimeZone bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetTimeZone = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetTimeZone{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeZone is not set"));
	}
	return nil
}

func (p *TSSetTimeZoneReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSSetTimeZoneReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.TimeZone = v
	}
	return nil
}

func (p *TSSetTimeZoneReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSSetTimeZoneReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSSetTimeZoneReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSSetTimeZoneReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timeZone", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeZone: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.TimeZone)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.timeZone (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeZone: ", p), err) }
	return err
}

func (p *TSSetTimeZoneReq) Equals(other *TSSetTimeZoneReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.TimeZone != other.TimeZone { return false }
	return true
}

func (p *TSSetTimeZoneReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSSetTimeZoneReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DeviceId
//  - Measurements
//  - Values
//  - Timestamp
type TSInsertRecordReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	DeviceId string `thrift:"deviceId,2,required" db:"deviceId" json:"deviceId"`
	Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
	Values []byte `thrift:"values,4,required" db:"values" json:"values"`
	Timestamp int64 `thrift:"timestamp,5,required" db:"timestamp" json:"timestamp"`
}

func NewTSInsertRecordReq() *TSInsertRecordReq {
	return &TSInsertRecordReq{}
}


func (p *TSInsertRecordReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSInsertRecordReq) GetDeviceId() string {
	return p.DeviceId
}

func (p *TSInsertRecordReq) GetMeasurements() []string {
	return p.Measurements
}

func (p *TSInsertRecordReq) GetValues() []byte {
	return p.Values
}

func (p *TSInsertRecordReq) GetTimestamp() int64 {
	return p.Timestamp
}
func (p *TSInsertRecordReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetDeviceId bool = false;
	var issetMeasurements bool = false;
	var issetValues bool = false;
	var issetTimestamp bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetDeviceId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetMeasurements = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetTimestamp = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetDeviceId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceId is not set"));
	}
	if !issetMeasurements{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
	}
	if !issetValues{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
	}
	if !issetTimestamp{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamp is not set"));
	}
	return nil
}

func (p *TSInsertRecordReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSInsertRecordReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.DeviceId = v
	}
	return nil
}

func (p *TSInsertRecordReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Measurements =  tSlice
	for i := 0; i < size; i ++ {
		var _elem27 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem27 = v
		}
		p.Measurements = append(p.Measurements, _elem27)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertRecordReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.Values = v
	}
	return nil
}

func (p *TSInsertRecordReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Timestamp = v
	}
	return nil
}

func (p *TSInsertRecordReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSInsertRecordReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSInsertRecordReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSInsertRecordReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "deviceId", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:deviceId: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.DeviceId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.deviceId (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:deviceId: ", p), err) }
	return err
}

func (p *TSInsertRecordReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Measurements {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
	return err
}

func (p *TSInsertRecordReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "values", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
	if err := oprot.WriteBinary(ctx, p.Values); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.values (4) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
	return err
}

func (p *TSInsertRecordReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timestamp", thrift.I64, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamp: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.Timestamp)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.timestamp (5) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamp: ", p), err) }
	return err
}

func (p *TSInsertRecordReq) Equals(other *TSInsertRecordReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.DeviceId != other.DeviceId { return false }
	if len(p.Measurements) != len(other.Measurements) { return false }
	for i, _tgt := range p.Measurements {
		_src28 := other.Measurements[i]
		if _tgt != _src28 { return false }
	}
	if bytes.Compare(p.Values, other.Values) != 0 { return false }
	if p.Timestamp != other.Timestamp { return false }
	return true
}

func (p *TSInsertRecordReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSInsertRecordReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DeviceId
//  - Measurements
//  - Values
//  - Timestamp
type TSInsertStringRecordReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	DeviceId string `thrift:"deviceId,2,required" db:"deviceId" json:"deviceId"`
	Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
	Values []string `thrift:"values,4,required" db:"values" json:"values"`
	Timestamp int64 `thrift:"timestamp,5,required" db:"timestamp" json:"timestamp"`
}

func NewTSInsertStringRecordReq() *TSInsertStringRecordReq {
	return &TSInsertStringRecordReq{}
}


func (p *TSInsertStringRecordReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSInsertStringRecordReq) GetDeviceId() string {
	return p.DeviceId
}

func (p *TSInsertStringRecordReq) GetMeasurements() []string {
	return p.Measurements
}

func (p *TSInsertStringRecordReq) GetValues() []string {
	return p.Values
}

func (p *TSInsertStringRecordReq) GetTimestamp() int64 {
	return p.Timestamp
}
func (p *TSInsertStringRecordReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetDeviceId bool = false;
	var issetMeasurements bool = false;
	var issetValues bool = false;
	var issetTimestamp bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetDeviceId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetMeasurements = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetTimestamp = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetDeviceId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceId is not set"));
	}
	if !issetMeasurements{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
	}
	if !issetValues{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
	}
	if !issetTimestamp{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamp is not set"));
	}
	return nil
}

func (p *TSInsertStringRecordReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSInsertStringRecordReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.DeviceId = v
	}
	return nil
}

func (p *TSInsertStringRecordReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Measurements =  tSlice
	for i := 0; i < size; i ++ {
		var _elem29 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem29 = v
		}
		p.Measurements = append(p.Measurements, _elem29)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertStringRecordReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Values =  tSlice
	for i := 0; i < size; i ++ {
		var _elem30 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem30 = v
		}
		p.Values = append(p.Values, _elem30)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertStringRecordReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Timestamp = v
	}
	return nil
}

func (p *TSInsertStringRecordReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSInsertStringRecordReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSInsertStringRecordReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSInsertStringRecordReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "deviceId", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:deviceId: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.DeviceId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.deviceId (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:deviceId: ", p), err) }
	return err
}

func (p *TSInsertStringRecordReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Measurements {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
	return err
}

func (p *TSInsertStringRecordReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "values", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Values)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Values {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
	return err
}

func (p *TSInsertStringRecordReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timestamp", thrift.I64, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamp: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.Timestamp)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.timestamp (5) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamp: ", p), err) }
	return err
}

func (p *TSInsertStringRecordReq) Equals(other *TSInsertStringRecordReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.DeviceId != other.DeviceId { return false }
	if len(p.Measurements) != len(other.Measurements) { return false }
	for i, _tgt := range p.Measurements {
		_src31 := other.Measurements[i]
		if _tgt != _src31 { return false }
	}
	if len(p.Values) != len(other.Values) { return false }
	for i, _tgt := range p.Values {
		_src32 := other.Values[i]
		if _tgt != _src32 { return false }
	}
	if p.Timestamp != other.Timestamp { return false }
	return true
}

func (p *TSInsertStringRecordReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSInsertStringRecordReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DeviceId
//  - Measurements
//  - Values
//  - Timestamps
//  - Types
//  - Size
type TSInsertTabletReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	DeviceId string `thrift:"deviceId,2,required" db:"deviceId" json:"deviceId"`
	Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
	Values []byte `thrift:"values,4,required" db:"values" json:"values"`
	Timestamps []byte `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
	Types []int32 `thrift:"types,6,required" db:"types" json:"types"`
	Size int32 `thrift:"size,7,required" db:"size" json:"size"`
}

func NewTSInsertTabletReq() *TSInsertTabletReq {
	return &TSInsertTabletReq{}
}


func (p *TSInsertTabletReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSInsertTabletReq) GetDeviceId() string {
	return p.DeviceId
}

func (p *TSInsertTabletReq) GetMeasurements() []string {
	return p.Measurements
}

func (p *TSInsertTabletReq) GetValues() []byte {
	return p.Values
}

func (p *TSInsertTabletReq) GetTimestamps() []byte {
	return p.Timestamps
}

func (p *TSInsertTabletReq) GetTypes() []int32 {
	return p.Types
}

func (p *TSInsertTabletReq) GetSize() int32 {
	return p.Size
}
func (p *TSInsertTabletReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetDeviceId bool = false;
	var issetMeasurements bool = false;
	var issetValues bool = false;
	var issetTimestamps bool = false;
	var issetTypes bool = false;
	var issetSize bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetDeviceId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetMeasurements = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetValues = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetTimestamps = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
				issetTypes = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
				issetSize = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetDeviceId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceId is not set"));
	}
	if !issetMeasurements{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
	}
	if !issetValues{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
	}
	if !issetTimestamps{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
	}
	if !issetTypes{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Types is not set"));
	}
	if !issetSize{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Size is not set"));
	}
	return nil
}

func (p *TSInsertTabletReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSInsertTabletReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.DeviceId = v
	}
	return nil
}

func (p *TSInsertTabletReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Measurements =  tSlice
	for i := 0; i < size; i ++ {
		var _elem33 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem33 = v
		}
		p.Measurements = append(p.Measurements, _elem33)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertTabletReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.Values = v
	}
	return nil
}

func (p *TSInsertTabletReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Timestamps = v
	}
	return nil
}

func (p *TSInsertTabletReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int32, 0, size)
	p.Types =  tSlice
	for i := 0; i < size; i ++ {
		var _elem34 int32
		if v, err := iprot.ReadI32(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem34 = v
		}
		p.Types = append(p.Types, _elem34)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertTabletReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		p.Size = v
	}
	return nil
}

func (p *TSInsertTabletReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSInsertTabletReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
		if err := p.writeField6(ctx, oprot); err != nil { return err }
		if err := p.writeField7(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSInsertTabletReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSInsertTabletReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "deviceId", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:deviceId: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.DeviceId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.deviceId (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:deviceId: ", p), err) }
	return err
}

func (p *TSInsertTabletReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Measurements {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
	return err
}

func (p *TSInsertTabletReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "values", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
	if err := oprot.WriteBinary(ctx, p.Values); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.values (4) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
	return err
}

func (p *TSInsertTabletReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.STRING, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
	if err := oprot.WriteBinary(ctx, p.Timestamps); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.timestamps (5) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
	return err
}

func (p *TSInsertTabletReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "types", thrift.LIST, 6); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:types: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Types)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Types {
		if err := oprot.WriteI32(ctx, int32(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 6:types: ", p), err) }
	return err
}

func (p *TSInsertTabletReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "size", thrift.I32, 7); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:size: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.Size)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.size (7) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 7:size: ", p), err) }
	return err
}

func (p *TSInsertTabletReq) Equals(other *TSInsertTabletReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.DeviceId != other.DeviceId { return false }
	if len(p.Measurements) != len(other.Measurements) { return false }
	for i, _tgt := range p.Measurements {
		_src35 := other.Measurements[i]
		if _tgt != _src35 { return false }
	}
	if bytes.Compare(p.Values, other.Values) != 0 { return false }
	if bytes.Compare(p.Timestamps, other.Timestamps) != 0 { return false }
	if len(p.Types) != len(other.Types) { return false }
	for i, _tgt := range p.Types {
		_src36 := other.Types[i]
		if _tgt != _src36 { return false }
	}
	if p.Size != other.Size { return false }
	return true
}

func (p *TSInsertTabletReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSInsertTabletReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DeviceIds
//  - MeasurementsList
//  - ValuesList
//  - TimestampsList
//  - TypesList
//  - SizeList
type TSInsertTabletsReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	DeviceIds []string `thrift:"deviceIds,2,required" db:"deviceIds" json:"deviceIds"`
	MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
	ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
	TimestampsList [][]byte `thrift:"timestampsList,5,required" db:"timestampsList" json:"timestampsList"`
	TypesList [][]int32 `thrift:"typesList,6,required" db:"typesList" json:"typesList"`
	SizeList []int32 `thrift:"sizeList,7,required" db:"sizeList" json:"sizeList"`
}

func NewTSInsertTabletsReq() *TSInsertTabletsReq {
	return &TSInsertTabletsReq{}
}


func (p *TSInsertTabletsReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSInsertTabletsReq) GetDeviceIds() []string {
	return p.DeviceIds
}

func (p *TSInsertTabletsReq) GetMeasurementsList() [][]string {
	return p.MeasurementsList
}

func (p *TSInsertTabletsReq) GetValuesList() [][]byte {
	return p.ValuesList
}

func (p *TSInsertTabletsReq) GetTimestampsList() [][]byte {
	return p.TimestampsList
}

func (p *TSInsertTabletsReq) GetTypesList() [][]int32 {
	return p.TypesList
}

func (p *TSInsertTabletsReq) GetSizeList() []int32 {
	return p.SizeList
}
func (p *TSInsertTabletsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetDeviceIds bool = false;
	var issetMeasurementsList bool = false;
	var issetValuesList bool = false;
	var issetTimestampsList bool = false;
	var issetTypesList bool = false;
	var issetSizeList bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetDeviceIds = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetMeasurementsList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetValuesList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetTimestampsList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
				issetTypesList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
				issetSizeList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetDeviceIds{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceIds is not set"));
	}
	if !issetMeasurementsList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
	}
	if !issetValuesList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
	}
	if !issetTimestampsList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimestampsList is not set"));
	}
	if !issetTypesList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TypesList is not set"));
	}
	if !issetSizeList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SizeList is not set"));
	}
	return nil
}

func (p *TSInsertTabletsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSInsertTabletsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.DeviceIds =  tSlice
	for i := 0; i < size; i ++ {
		var _elem37 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem37 = v
		}
		p.DeviceIds = append(p.DeviceIds, _elem37)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertTabletsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]string, 0, size)
	p.MeasurementsList =  tSlice
	for i := 0; i < size; i ++ {
		_, size, err := iprot.ReadListBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading list begin: ", err)
		}
		tSlice := make([]string, 0, size)
		_elem38 :=  tSlice
		for i := 0; i < size; i ++ {
			var _elem39 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_elem39 = v
			}
			_elem38 = append(_elem38, _elem39)
		}
		if err := iprot.ReadListEnd(ctx); err != nil {
			return thrift.PrependError("error reading list end: ", err)
		}
		p.MeasurementsList = append(p.MeasurementsList, _elem38)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertTabletsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.ValuesList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem40 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem40 = v
		}
		p.ValuesList = append(p.ValuesList, _elem40)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertTabletsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.TimestampsList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem41 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem41 = v
		}
		p.TimestampsList = append(p.TimestampsList, _elem41)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertTabletsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]int32, 0, size)
	p.TypesList =  tSlice
	for i := 0; i < size; i ++ {
		_, size, err := iprot.ReadListBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading list begin: ", err)
		}
		tSlice := make([]int32, 0, size)
		_elem42 :=  tSlice
		for i := 0; i < size; i ++ {
			var _elem43 int32
			if v, err := iprot.ReadI32(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_elem43 = v
			}
			_elem42 = append(_elem42, _elem43)
		}
		if err := iprot.ReadListEnd(ctx); err != nil {
			return thrift.PrependError("error reading list end: ", err)
		}
		p.TypesList = append(p.TypesList, _elem42)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertTabletsReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int32, 0, size)
	p.SizeList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem44 int32
		if v, err := iprot.ReadI32(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem44 = v
		}
		p.SizeList = append(p.SizeList, _elem44)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertTabletsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSInsertTabletsReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
		if err := p.writeField6(ctx, oprot); err != nil { return err }
		if err := p.writeField7(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSInsertTabletsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSInsertTabletsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "deviceIds", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:deviceIds: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.DeviceIds)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.DeviceIds {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:deviceIds: ", p), err) }
	return err
}

func (p *TSInsertTabletsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.MeasurementsList {
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range v {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
	return err
}

func (p *TSInsertTabletsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.ValuesList {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
	return err
}

func (p *TSInsertTabletsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timestampsList", thrift.LIST, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestampsList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.TimestampsList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.TimestampsList {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestampsList: ", p), err) }
	return err
}

func (p *TSInsertTabletsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "typesList", thrift.LIST, 6); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:typesList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.TypesList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.TypesList {
		if err := oprot.WriteListBegin(ctx, thrift.I32, len(v)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range v {
			if err := oprot.WriteI32(ctx, int32(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 6:typesList: ", p), err) }
	return err
}

func (p *TSInsertTabletsReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sizeList", thrift.LIST, 7); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:sizeList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.SizeList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.SizeList {
		if err := oprot.WriteI32(ctx, int32(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 7:sizeList: ", p), err) }
	return err
}

func (p *TSInsertTabletsReq) Equals(other *TSInsertTabletsReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if len(p.DeviceIds) != len(other.DeviceIds) { return false }
	for i, _tgt := range p.DeviceIds {
		_src45 := other.DeviceIds[i]
		if _tgt != _src45 { return false }
	}
	if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
	for i, _tgt := range p.MeasurementsList {
		_src46 := other.MeasurementsList[i]
		if len(_tgt) != len(_src46) { return false }
		for i, _tgt := range _tgt {
			_src47 := _src46[i]
			if _tgt != _src47 { return false }
		}
	}
	if len(p.ValuesList) != len(other.ValuesList) { return false }
	for i, _tgt := range p.ValuesList {
		_src48 := other.ValuesList[i]
		if bytes.Compare(_tgt, _src48) != 0 { return false }
	}
	if len(p.TimestampsList) != len(other.TimestampsList) { return false }
	for i, _tgt := range p.TimestampsList {
		_src49 := other.TimestampsList[i]
		if bytes.Compare(_tgt, _src49) != 0 { return false }
	}
	if len(p.TypesList) != len(other.TypesList) { return false }
	for i, _tgt := range p.TypesList {
		_src50 := other.TypesList[i]
		if len(_tgt) != len(_src50) { return false }
		for i, _tgt := range _tgt {
			_src51 := _src50[i]
			if _tgt != _src51 { return false }
		}
	}
	if len(p.SizeList) != len(other.SizeList) { return false }
	for i, _tgt := range p.SizeList {
		_src52 := other.SizeList[i]
		if _tgt != _src52 { return false }
	}
	return true
}

func (p *TSInsertTabletsReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSInsertTabletsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DeviceIds
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
type TSInsertRecordsReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	DeviceIds []string `thrift:"deviceIds,2,required" db:"deviceIds" json:"deviceIds"`
	MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
	ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
	Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
}

func NewTSInsertRecordsReq() *TSInsertRecordsReq {
	return &TSInsertRecordsReq{}
}


func (p *TSInsertRecordsReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSInsertRecordsReq) GetDeviceIds() []string {
	return p.DeviceIds
}

func (p *TSInsertRecordsReq) GetMeasurementsList() [][]string {
	return p.MeasurementsList
}

func (p *TSInsertRecordsReq) GetValuesList() [][]byte {
	return p.ValuesList
}

func (p *TSInsertRecordsReq) GetTimestamps() []int64 {
	return p.Timestamps
}
func (p *TSInsertRecordsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetDeviceIds bool = false;
	var issetMeasurementsList bool = false;
	var issetValuesList bool = false;
	var issetTimestamps bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetDeviceIds = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetMeasurementsList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetValuesList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetTimestamps = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetDeviceIds{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceIds is not set"));
	}
	if !issetMeasurementsList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
	}
	if !issetValuesList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
	}
	if !issetTimestamps{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
	}
	return nil
}

func (p *TSInsertRecordsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSInsertRecordsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.DeviceIds =  tSlice
	for i := 0; i < size; i ++ {
		var _elem53 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem53 = v
		}
		p.DeviceIds = append(p.DeviceIds, _elem53)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertRecordsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]string, 0, size)
	p.MeasurementsList =  tSlice
	for i := 0; i < size; i ++ {
		_, size, err := iprot.ReadListBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading list begin: ", err)
		}
		tSlice := make([]string, 0, size)
		_elem54 :=  tSlice
		for i := 0; i < size; i ++ {
			var _elem55 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_elem55 = v
			}
			_elem54 = append(_elem54, _elem55)
		}
		if err := iprot.ReadListEnd(ctx); err != nil {
			return thrift.PrependError("error reading list end: ", err)
		}
		p.MeasurementsList = append(p.MeasurementsList, _elem54)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertRecordsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.ValuesList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem56 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem56 = v
		}
		p.ValuesList = append(p.ValuesList, _elem56)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertRecordsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int64, 0, size)
	p.Timestamps =  tSlice
	for i := 0; i < size; i ++ {
		var _elem57 int64
		if v, err := iprot.ReadI64(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem57 = v
		}
		p.Timestamps = append(p.Timestamps, _elem57)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertRecordsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSInsertRecordsReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSInsertRecordsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSInsertRecordsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "deviceIds", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:deviceIds: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.DeviceIds)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.DeviceIds {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:deviceIds: ", p), err) }
	return err
}

func (p *TSInsertRecordsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.MeasurementsList {
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range v {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
	return err
}

func (p *TSInsertRecordsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.ValuesList {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
	return err
}

func (p *TSInsertRecordsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Timestamps {
		if err := oprot.WriteI64(ctx, int64(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
	return err
}

func (p *TSInsertRecordsReq) Equals(other *TSInsertRecordsReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if len(p.DeviceIds) != len(other.DeviceIds) { return false }
	for i, _tgt := range p.DeviceIds {
		_src58 := other.DeviceIds[i]
		if _tgt != _src58 { return false }
	}
	if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
	for i, _tgt := range p.MeasurementsList {
		_src59 := other.MeasurementsList[i]
		if len(_tgt) != len(_src59) { return false }
		for i, _tgt := range _tgt {
			_src60 := _src59[i]
			if _tgt != _src60 { return false }
		}
	}
	if len(p.ValuesList) != len(other.ValuesList) { return false }
	for i, _tgt := range p.ValuesList {
		_src61 := other.ValuesList[i]
		if bytes.Compare(_tgt, _src61) != 0 { return false }
	}
	if len(p.Timestamps) != len(other.Timestamps) { return false }
	for i, _tgt := range p.Timestamps {
		_src62 := other.Timestamps[i]
		if _tgt != _src62 { return false }
	}
	return true
}

func (p *TSInsertRecordsReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSInsertRecordsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DeviceId
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
type TSInsertRecordsOfOneDeviceReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	DeviceId string `thrift:"deviceId,2,required" db:"deviceId" json:"deviceId"`
	MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
	ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
	Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
}

func NewTSInsertRecordsOfOneDeviceReq() *TSInsertRecordsOfOneDeviceReq {
	return &TSInsertRecordsOfOneDeviceReq{}
}


func (p *TSInsertRecordsOfOneDeviceReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSInsertRecordsOfOneDeviceReq) GetDeviceId() string {
	return p.DeviceId
}

func (p *TSInsertRecordsOfOneDeviceReq) GetMeasurementsList() [][]string {
	return p.MeasurementsList
}

func (p *TSInsertRecordsOfOneDeviceReq) GetValuesList() [][]byte {
	return p.ValuesList
}

func (p *TSInsertRecordsOfOneDeviceReq) GetTimestamps() []int64 {
	return p.Timestamps
}
func (p *TSInsertRecordsOfOneDeviceReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetDeviceId bool = false;
	var issetMeasurementsList bool = false;
	var issetValuesList bool = false;
	var issetTimestamps bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetDeviceId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetMeasurementsList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetValuesList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetTimestamps = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetDeviceId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceId is not set"));
	}
	if !issetMeasurementsList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
	}
	if !issetValuesList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
	}
	if !issetTimestamps{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
	}
	return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.DeviceId = v
	}
	return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]string, 0, size)
	p.MeasurementsList =  tSlice
	for i := 0; i < size; i ++ {
		_, size, err := iprot.ReadListBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading list begin: ", err)
		}
		tSlice := make([]string, 0, size)
		_elem63 :=  tSlice
		for i := 0; i < size; i ++ {
			var _elem64 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_elem64 = v
			}
			_elem63 = append(_elem63, _elem64)
		}
		if err := iprot.ReadListEnd(ctx); err != nil {
			return thrift.PrependError("error reading list end: ", err)
		}
		p.MeasurementsList = append(p.MeasurementsList, _elem63)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.ValuesList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem65 []byte
		if v, err := iprot.ReadBinary(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem65 = v
		}
		p.ValuesList = append(p.ValuesList, _elem65)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int64, 0, size)
	p.Timestamps =  tSlice
	for i := 0; i < size; i ++ {
		var _elem66 int64
		if v, err := iprot.ReadI64(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem66 = v
		}
		p.Timestamps = append(p.Timestamps, _elem66)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertRecordsOfOneDeviceReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSInsertRecordsOfOneDeviceReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "deviceId", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:deviceId: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.DeviceId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.deviceId (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:deviceId: ", p), err) }
	return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.MeasurementsList {
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range v {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
	return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.ValuesList {
		if err := oprot.WriteBinary(ctx, v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
	return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Timestamps {
		if err := oprot.WriteI64(ctx, int64(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
	return err
}

func (p *TSInsertRecordsOfOneDeviceReq) Equals(other *TSInsertRecordsOfOneDeviceReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.DeviceId != other.DeviceId { return false }
	if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
	for i, _tgt := range p.MeasurementsList {
		_src67 := other.MeasurementsList[i]
		if len(_tgt) != len(_src67) { return false }
		for i, _tgt := range _tgt {
			_src68 := _src67[i]
			if _tgt != _src68 { return false }
		}
	}
	if len(p.ValuesList) != len(other.ValuesList) { return false }
	for i, _tgt := range p.ValuesList {
		_src69 := other.ValuesList[i]
		if bytes.Compare(_tgt, _src69) != 0 { return false }
	}
	if len(p.Timestamps) != len(other.Timestamps) { return false }
	for i, _tgt := range p.Timestamps {
		_src70 := other.Timestamps[i]
		if _tgt != _src70 { return false }
	}
	return true
}

func (p *TSInsertRecordsOfOneDeviceReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSInsertRecordsOfOneDeviceReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DeviceIds
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
type TSInsertStringRecordsReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	DeviceIds []string `thrift:"deviceIds,2,required" db:"deviceIds" json:"deviceIds"`
	MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
	ValuesList [][]string `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
	Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
}

func NewTSInsertStringRecordsReq() *TSInsertStringRecordsReq {
	return &TSInsertStringRecordsReq{}
}


func (p *TSInsertStringRecordsReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSInsertStringRecordsReq) GetDeviceIds() []string {
	return p.DeviceIds
}

func (p *TSInsertStringRecordsReq) GetMeasurementsList() [][]string {
	return p.MeasurementsList
}

func (p *TSInsertStringRecordsReq) GetValuesList() [][]string {
	return p.ValuesList
}

func (p *TSInsertStringRecordsReq) GetTimestamps() []int64 {
	return p.Timestamps
}
func (p *TSInsertStringRecordsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetDeviceIds bool = false;
	var issetMeasurementsList bool = false;
	var issetValuesList bool = false;
	var issetTimestamps bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetDeviceIds = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetMeasurementsList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetValuesList = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetTimestamps = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetDeviceIds{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DeviceIds is not set"));
	}
	if !issetMeasurementsList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
	}
	if !issetValuesList{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
	}
	if !issetTimestamps{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
	}
	return nil
}

func (p *TSInsertStringRecordsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSInsertStringRecordsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.DeviceIds =  tSlice
	for i := 0; i < size; i ++ {
		var _elem71 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem71 = v
		}
		p.DeviceIds = append(p.DeviceIds, _elem71)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertStringRecordsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]string, 0, size)
	p.MeasurementsList =  tSlice
	for i := 0; i < size; i ++ {
		_, size, err := iprot.ReadListBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading list begin: ", err)
		}
		tSlice := make([]string, 0, size)
		_elem72 :=  tSlice
		for i := 0; i < size; i ++ {
			var _elem73 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_elem73 = v
			}
			_elem72 = append(_elem72, _elem73)
		}
		if err := iprot.ReadListEnd(ctx); err != nil {
			return thrift.PrependError("error reading list end: ", err)
		}
		p.MeasurementsList = append(p.MeasurementsList, _elem72)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertStringRecordsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]string, 0, size)
	p.ValuesList =  tSlice
	for i := 0; i < size; i ++ {
		_, size, err := iprot.ReadListBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading list begin: ", err)
		}
		tSlice := make([]string, 0, size)
		_elem74 :=  tSlice
		for i := 0; i < size; i ++ {
			var _elem75 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_elem75 = v
			}
			_elem74 = append(_elem74, _elem75)
		}
		if err := iprot.ReadListEnd(ctx); err != nil {
			return thrift.PrependError("error reading list end: ", err)
		}
		p.ValuesList = append(p.ValuesList, _elem74)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertStringRecordsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int64, 0, size)
	p.Timestamps =  tSlice
	for i := 0; i < size; i ++ {
		var _elem76 int64
		if v, err := iprot.ReadI64(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem76 = v
		}
		p.Timestamps = append(p.Timestamps, _elem76)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSInsertStringRecordsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSInsertStringRecordsReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSInsertStringRecordsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSInsertStringRecordsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "deviceIds", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:deviceIds: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.DeviceIds)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.DeviceIds {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:deviceIds: ", p), err) }
	return err
}

func (p *TSInsertStringRecordsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.MeasurementsList {
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range v {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
	return err
}

func (p *TSInsertStringRecordsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.ValuesList)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.ValuesList {
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range v {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
	return err
}

func (p *TSInsertStringRecordsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Timestamps {
		if err := oprot.WriteI64(ctx, int64(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
	return err
}

func (p *TSInsertStringRecordsReq) Equals(other *TSInsertStringRecordsReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if len(p.DeviceIds) != len(other.DeviceIds) { return false }
	for i, _tgt := range p.DeviceIds {
		_src77 := other.DeviceIds[i]
		if _tgt != _src77 { return false }
	}
	if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
	for i, _tgt := range p.MeasurementsList {
		_src78 := other.MeasurementsList[i]
		if len(_tgt) != len(_src78) { return false }
		for i, _tgt := range _tgt {
			_src79 := _src78[i]
			if _tgt != _src79 { return false }
		}
	}
	if len(p.ValuesList) != len(other.ValuesList) { return false }
	for i, _tgt := range p.ValuesList {
		_src80 := other.ValuesList[i]
		if len(_tgt) != len(_src80) { return false }
		for i, _tgt := range _tgt {
			_src81 := _src80[i]
			if _tgt != _src81 { return false }
		}
	}
	if len(p.Timestamps) != len(other.Timestamps) { return false }
	for i, _tgt := range p.Timestamps {
		_src82 := other.Timestamps[i]
		if _tgt != _src82 { return false }
	}
	return true
}

func (p *TSInsertStringRecordsReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSInsertStringRecordsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - StartTime
//  - EndTime
type TSDeleteDataReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
	StartTime int64 `thrift:"startTime,3,required" db:"startTime" json:"startTime"`
	EndTime int64 `thrift:"endTime,4,required" db:"endTime" json:"endTime"`
}

func NewTSDeleteDataReq() *TSDeleteDataReq {
	return &TSDeleteDataReq{}
}


func (p *TSDeleteDataReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSDeleteDataReq) GetPaths() []string {
	return p.Paths
}

func (p *TSDeleteDataReq) GetStartTime() int64 {
	return p.StartTime
}

func (p *TSDeleteDataReq) GetEndTime() int64 {
	return p.EndTime
}
func (p *TSDeleteDataReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetPaths bool = false;
	var issetStartTime bool = false;
	var issetEndTime bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetPaths = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetStartTime = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetEndTime = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetPaths{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
	}
	if !issetStartTime{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StartTime is not set"));
	}
	if !issetEndTime{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EndTime is not set"));
	}
	return nil
}

func (p *TSDeleteDataReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSDeleteDataReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Paths =  tSlice
	for i := 0; i < size; i ++ {
		var _elem83 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem83 = v
		}
		p.Paths = append(p.Paths, _elem83)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSDeleteDataReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.StartTime = v
	}
	return nil
}

func (p *TSDeleteDataReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.EndTime = v
	}
	return nil
}

func (p *TSDeleteDataReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSDeleteDataReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSDeleteDataReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSDeleteDataReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Paths {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
	return err
}

func (p *TSDeleteDataReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:startTime: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.startTime (3) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:startTime: ", p), err) }
	return err
}

func (p *TSDeleteDataReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:endTime: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.endTime (4) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:endTime: ", p), err) }
	return err
}

func (p *TSDeleteDataReq) Equals(other *TSDeleteDataReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if len(p.Paths) != len(other.Paths) { return false }
	for i, _tgt := range p.Paths {
		_src84 := other.Paths[i]
		if _tgt != _src84 { return false }
	}
	if p.StartTime != other.StartTime { return false }
	if p.EndTime != other.EndTime { return false }
	return true
}

func (p *TSDeleteDataReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSDeleteDataReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Path
//  - DataType
//  - Encoding
//  - Compressor
//  - Props
//  - Tags
//  - Attributes
//  - MeasurementAlias
type TSCreateTimeseriesReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	Path string `thrift:"path,2,required" db:"path" json:"path"`
	DataType int32 `thrift:"dataType,3,required" db:"dataType" json:"dataType"`
	Encoding int32 `thrift:"encoding,4,required" db:"encoding" json:"encoding"`
	Compressor int32 `thrift:"compressor,5,required" db:"compressor" json:"compressor"`
	Props map[string]string `thrift:"props,6" db:"props" json:"props,omitempty"`
	Tags map[string]string `thrift:"tags,7" db:"tags" json:"tags,omitempty"`
	Attributes map[string]string `thrift:"attributes,8" db:"attributes" json:"attributes,omitempty"`
	MeasurementAlias *string `thrift:"measurementAlias,9" db:"measurementAlias" json:"measurementAlias,omitempty"`
}

func NewTSCreateTimeseriesReq() *TSCreateTimeseriesReq {
	return &TSCreateTimeseriesReq{}
}


func (p *TSCreateTimeseriesReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSCreateTimeseriesReq) GetPath() string {
	return p.Path
}

func (p *TSCreateTimeseriesReq) GetDataType() int32 {
	return p.DataType
}

func (p *TSCreateTimeseriesReq) GetEncoding() int32 {
	return p.Encoding
}

func (p *TSCreateTimeseriesReq) GetCompressor() int32 {
	return p.Compressor
}
var TSCreateTimeseriesReq_Props_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetProps() map[string]string {
	return p.Props
}
var TSCreateTimeseriesReq_Tags_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetTags() map[string]string {
	return p.Tags
}
var TSCreateTimeseriesReq_Attributes_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetAttributes() map[string]string {
	return p.Attributes
}
var TSCreateTimeseriesReq_MeasurementAlias_DEFAULT string
func (p *TSCreateTimeseriesReq) GetMeasurementAlias() string {
	if !p.IsSetMeasurementAlias() {
		return TSCreateTimeseriesReq_MeasurementAlias_DEFAULT
	}
	return *p.MeasurementAlias
}
func (p *TSCreateTimeseriesReq) IsSetProps() bool {
	return p.Props != nil
}

func (p *TSCreateTimeseriesReq) IsSetTags() bool {
	return p.Tags != nil
}

func (p *TSCreateTimeseriesReq) IsSetAttributes() bool {
	return p.Attributes != nil
}

func (p *TSCreateTimeseriesReq) IsSetMeasurementAlias() bool {
	return p.MeasurementAlias != nil
}

func (p *TSCreateTimeseriesReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetPath bool = false;
	var issetDataType bool = false;
	var issetEncoding bool = false;
	var issetCompressor bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetPath = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetDataType = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetEncoding = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetCompressor = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField9(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetPath{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
	}
	if !issetDataType{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataType is not set"));
	}
	if !issetEncoding{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encoding is not set"));
	}
	if !issetCompressor{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressor is not set"));
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Path = v
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.DataType = v
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.Encoding = v
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Compressor = v
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(map[string]string, size)
	p.Props =  tMap
	for i := 0; i < size; i ++ {
		var _key85 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key85 = v
		}
		var _val86 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_val86 = v
		}
		p.Props[_key85] = _val86
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(map[string]string, size)
	p.Tags =  tMap
	for i := 0; i < size; i ++ {
		var _key87 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key87 = v
		}
		var _val88 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_val88 = v
		}
		p.Tags[_key87] = _val88
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(map[string]string, size)
	p.Attributes =  tMap
	for i := 0; i < size; i ++ {
		var _key89 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key89 = v
		}
		var _val90 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_val90 = v
		}
		p.Attributes[_key89] = _val90
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *TSCreateTimeseriesReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 9: ", err)
	} else {
		p.MeasurementAlias = &v
	}
	return nil
}

func (p *TSCreateTimeseriesReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSCreateTimeseriesReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
		if err := p.writeField6(ctx, oprot); err != nil { return err }
		if err := p.writeField7(ctx, oprot); err != nil { return err }
		if err := p.writeField8(ctx, oprot); err != nil { return err }
		if err := p.writeField9(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSCreateTimeseriesReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSCreateTimeseriesReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.path (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
	return err
}

func (p *TSCreateTimeseriesReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "dataType", thrift.I32, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:dataType: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.DataType)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.dataType (3) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:dataType: ", p), err) }
	return err
}

func (p *TSCreateTimeseriesReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "encoding", thrift.I32, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:encoding: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.Encoding)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.encoding (4) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:encoding: ", p), err) }
	return err
}

func (p *TSCreateTimeseriesReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "compressor", thrift.I32, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:compressor: ", p), err) }
	if err := oprot.WriteI32(ctx, int32(p.Compressor)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.compressor (5) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:compressor: ", p), err) }
	return err
}

func (p *TSCreateTimeseriesReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetProps() {
		if err := oprot.WriteFieldBegin(ctx, "props", thrift.MAP, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:props: ", p), err) }
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Props)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range p.Props {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:props: ", p), err) }
	}
	return err
}

func (p *TSCreateTimeseriesReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTags() {
		if err := oprot.WriteFieldBegin(ctx, "tags", thrift.MAP, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:tags: ", p), err) }
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Tags)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range p.Tags {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:tags: ", p), err) }
	}
	return err
}

func (p *TSCreateTimeseriesReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetAttributes() {
		if err := oprot.WriteFieldBegin(ctx, "attributes", thrift.MAP, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:attributes: ", p), err) }
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Attributes)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range p.Attributes {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:attributes: ", p), err) }
	}
	return err
}

func (p *TSCreateTimeseriesReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMeasurementAlias() {
		if err := oprot.WriteFieldBegin(ctx, "measurementAlias", thrift.STRING, 9); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:measurementAlias: ", p), err) }
		if err := oprot.WriteString(ctx, string(*p.MeasurementAlias)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.measurementAlias (9) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 9:measurementAlias: ", p), err) }
	}
	return err
}

func (p *TSCreateTimeseriesReq) Equals(other *TSCreateTimeseriesReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if p.Path != other.Path { return false }
	if p.DataType != other.DataType { return false }
	if p.Encoding != other.Encoding { return false }
	if p.Compressor != other.Compressor { return false }
	if len(p.Props) != len(other.Props) { return false }
	for k, _tgt := range p.Props {
		_src91 := other.Props[k]
		if _tgt != _src91 { return false }
	}
	if len(p.Tags) != len(other.Tags) { return false }
	for k, _tgt := range p.Tags {
		_src92 := other.Tags[k]
		if _tgt != _src92 { return false }
	}
	if len(p.Attributes) != len(other.Attributes) { return false }
	for k, _tgt := range p.Attributes {
		_src93 := other.Attributes[k]
		if _tgt != _src93 { return false }
	}
	if p.MeasurementAlias != other.MeasurementAlias {
		if p.MeasurementAlias == nil || other.MeasurementAlias == nil {
			return false
		}
		if (*p.MeasurementAlias) != (*other.MeasurementAlias) { return false }
	}
	return true
}

func (p *TSCreateTimeseriesReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSCreateTimeseriesReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - FetchSize
//  - StartTime
//  - EndTime
//  - StatementId
//  - EnableRedirectQuery
type TSRawDataQueryReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
	FetchSize *int32 `thrift:"fetchSize,3" db:"fetchSize" json:"fetchSize,omitempty"`
	StartTime int64 `thrift:"startTime,4,required" db:"startTime" json:"startTime"`
	EndTime int64 `thrift:"endTime,5,required" db:"endTime" json:"endTime"`
	StatementId int64 `thrift:"statementId,6,required" db:"statementId" json:"statementId"`
	EnableRedirectQuery *bool `thrift:"enableRedirectQuery,7" db:"enableRedirectQuery" json:"enableRedirectQuery,omitempty"`
}

func NewTSRawDataQueryReq() *TSRawDataQueryReq {
	return &TSRawDataQueryReq{}
}


func (p *TSRawDataQueryReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSRawDataQueryReq) GetPaths() []string {
	return p.Paths
}
var TSRawDataQueryReq_FetchSize_DEFAULT int32
func (p *TSRawDataQueryReq) GetFetchSize() int32 {
	if !p.IsSetFetchSize() {
		return TSRawDataQueryReq_FetchSize_DEFAULT
	}
	return *p.FetchSize
}

func (p *TSRawDataQueryReq) GetStartTime() int64 {
	return p.StartTime
}

func (p *TSRawDataQueryReq) GetEndTime() int64 {
	return p.EndTime
}

func (p *TSRawDataQueryReq) GetStatementId() int64 {
	return p.StatementId
}
var TSRawDataQueryReq_EnableRedirectQuery_DEFAULT bool
func (p *TSRawDataQueryReq) GetEnableRedirectQuery() bool {
	if !p.IsSetEnableRedirectQuery() {
		return TSRawDataQueryReq_EnableRedirectQuery_DEFAULT
	}
	return *p.EnableRedirectQuery
}
func (p *TSRawDataQueryReq) IsSetFetchSize() bool {
	return p.FetchSize != nil
}

func (p *TSRawDataQueryReq) IsSetEnableRedirectQuery() bool {
	return p.EnableRedirectQuery != nil
}

func (p *TSRawDataQueryReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetPaths bool = false;
	var issetStartTime bool = false;
	var issetEndTime bool = false;
	var issetStatementId bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetPaths = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetStartTime = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetEndTime = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
				issetStatementId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetPaths{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
	}
	if !issetStartTime{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StartTime is not set"));
	}
	if !issetEndTime{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EndTime is not set"));
	}
	if !issetStatementId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
	}
	return nil
}

func (p *TSRawDataQueryReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSRawDataQueryReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Paths =  tSlice
	for i := 0; i < size; i ++ {
		var _elem94 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem94 = v
		}
		p.Paths = append(p.Paths, _elem94)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSRawDataQueryReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.FetchSize = &v
	}
	return nil
}

func (p *TSRawDataQueryReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.StartTime = v
	}
	return nil
}

func (p *TSRawDataQueryReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.EndTime = v
	}
	return nil
}

func (p *TSRawDataQueryReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.StatementId = v
	}
	return nil
}

func (p *TSRawDataQueryReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(ctx); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		p.EnableRedirectQuery = &v
	}
	return nil
}

func (p *TSRawDataQueryReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSRawDataQueryReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
		if err := p.writeField6(ctx, oprot); err != nil { return err }
		if err := p.writeField7(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSRawDataQueryReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSRawDataQueryReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Paths {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
	return err
}

func (p *TSRawDataQueryReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetFetchSize() {
		if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:fetchSize: ", p), err) }
		if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.fetchSize (3) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:fetchSize: ", p), err) }
	}
	return err
}

func (p *TSRawDataQueryReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:startTime: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.startTime (4) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:startTime: ", p), err) }
	return err
}

func (p *TSRawDataQueryReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:endTime: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.endTime (5) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:endTime: ", p), err) }
	return err
}

func (p *TSRawDataQueryReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 6); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:statementId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.statementId (6) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 6:statementId: ", p), err) }
	return err
}

func (p *TSRawDataQueryReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetEnableRedirectQuery() {
		if err := oprot.WriteFieldBegin(ctx, "enableRedirectQuery", thrift.BOOL, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:enableRedirectQuery: ", p), err) }
		if err := oprot.WriteBool(ctx, bool(*p.EnableRedirectQuery)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.enableRedirectQuery (7) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:enableRedirectQuery: ", p), err) }
	}
	return err
}

func (p *TSRawDataQueryReq) Equals(other *TSRawDataQueryReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if len(p.Paths) != len(other.Paths) { return false }
	for i, _tgt := range p.Paths {
		_src95 := other.Paths[i]
		if _tgt != _src95 { return false }
	}
	if p.FetchSize != other.FetchSize {
		if p.FetchSize == nil || other.FetchSize == nil {
			return false
		}
		if (*p.FetchSize) != (*other.FetchSize) { return false }
	}
	if p.StartTime != other.StartTime { return false }
	if p.EndTime != other.EndTime { return false }
	if p.StatementId != other.StatementId { return false }
	if p.EnableRedirectQuery != other.EnableRedirectQuery {
		if p.EnableRedirectQuery == nil || other.EnableRedirectQuery == nil {
			return false
		}
		if (*p.EnableRedirectQuery) != (*other.EnableRedirectQuery) { return false }
	}
	return true
}

func (p *TSRawDataQueryReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSRawDataQueryReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - DataTypes
//  - Encodings
//  - Compressors
//  - PropsList
//  - TagsList
//  - AttributesList
//  - MeasurementAliasList
type TSCreateMultiTimeseriesReq struct {
	SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
	Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
	DataTypes []int32 `thrift:"dataTypes,3,required" db:"dataTypes" json:"dataTypes"`
	Encodings []int32 `thrift:"encodings,4,required" db:"encodings" json:"encodings"`
	Compressors []int32 `thrift:"compressors,5,required" db:"compressors" json:"compressors"`
	PropsList []map[string]string `thrift:"propsList,6" db:"propsList" json:"propsList,omitempty"`
	TagsList []map[string]string `thrift:"tagsList,7" db:"tagsList" json:"tagsList,omitempty"`
	AttributesList []map[string]string `thrift:"attributesList,8" db:"attributesList" json:"attributesList,omitempty"`
	MeasurementAliasList []string `thrift:"measurementAliasList,9" db:"measurementAliasList" json:"measurementAliasList,omitempty"`
}

func NewTSCreateMultiTimeseriesReq() *TSCreateMultiTimeseriesReq {
	return &TSCreateMultiTimeseriesReq{}
}


func (p *TSCreateMultiTimeseriesReq) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSCreateMultiTimeseriesReq) GetPaths() []string {
	return p.Paths
}

func (p *TSCreateMultiTimeseriesReq) GetDataTypes() []int32 {
	return p.DataTypes
}

func (p *TSCreateMultiTimeseriesReq) GetEncodings() []int32 {
	return p.Encodings
}

func (p *TSCreateMultiTimeseriesReq) GetCompressors() []int32 {
	return p.Compressors
}
var TSCreateMultiTimeseriesReq_PropsList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetPropsList() []map[string]string {
	return p.PropsList
}
var TSCreateMultiTimeseriesReq_TagsList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetTagsList() []map[string]string {
	return p.TagsList
}
var TSCreateMultiTimeseriesReq_AttributesList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetAttributesList() []map[string]string {
	return p.AttributesList
}
var TSCreateMultiTimeseriesReq_MeasurementAliasList_DEFAULT []string

func (p *TSCreateMultiTimeseriesReq) GetMeasurementAliasList() []string {
	return p.MeasurementAliasList
}
func (p *TSCreateMultiTimeseriesReq) IsSetPropsList() bool {
	return p.PropsList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetTagsList() bool {
	return p.TagsList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetAttributesList() bool {
	return p.AttributesList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetMeasurementAliasList() bool {
	return p.MeasurementAliasList != nil
}

func (p *TSCreateMultiTimeseriesReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSessionId bool = false;
	var issetPaths bool = false;
	var issetDataTypes bool = false;
	var issetEncodings bool = false;
	var issetCompressors bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetSessionId = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetPaths = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetDataTypes = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
				issetEncodings = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField5(ctx, iprot); err != nil {
					return err
				}
				issetCompressors = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField6(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 7:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField7(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 8:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField8(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 9:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField9(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSessionId{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
	}
	if !issetPaths{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
	}
	if !issetDataTypes{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypes is not set"));
	}
	if !issetEncodings{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encodings is not set"));
	}
	if !issetCompressors{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressors is not set"));
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Paths =  tSlice
	for i := 0; i < size; i ++ {
		var _elem96 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem96 = v
		}
		p.Paths = append(p.Paths, _elem96)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int32, 0, size)
	p.DataTypes =  tSlice
	for i := 0; i < size; i ++ {
		var _elem97 int32
		if v, err := iprot.ReadI32(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem97 = v
		}
		p.DataTypes = append(p.DataTypes, _elem97)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int32, 0, size)
	p.Encodings =  tSlice
	for i := 0; i < size; i ++ {
		var _elem98 int32
		if v, err := iprot.ReadI32(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem98 = v
		}
		p.Encodings = append(p.Encodings, _elem98)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int32, 0, size)
	p.Compressors =  tSlice
	for i := 0; i < size; i ++ {
		var _elem99 int32
		if v, err := iprot.ReadI32(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem99 = v
		}
		p.Compressors = append(p.Compressors, _elem99)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]map[string]string, 0, size)
	p.PropsList =  tSlice
	for i := 0; i < size; i ++ {
		_, _, size, err := iprot.ReadMapBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading map begin: ", err)
		}
		tMap := make(map[string]string, size)
		_elem100 :=  tMap
		for i := 0; i < size; i ++ {
			var _key101 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_key101 = v
			}
			var _val102 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_val102 = v
			}
			_elem100[_key101] = _val102
		}
		if err := iprot.ReadMapEnd(ctx); err != nil {
			return thrift.PrependError("error reading map end: ", err)
		}
		p.PropsList = append(p.PropsList, _elem100)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]map[string]string, 0, size)
	p.TagsList =  tSlice
	for i := 0; i < size; i ++ {
		_, _, size, err := iprot.ReadMapBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading map begin: ", err)
		}
		tMap := make(map[string]string, size)
		_elem103 :=  tMap
		for i := 0; i < size; i ++ {
			var _key104 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_key104 = v
			}
			var _val105 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_val105 = v
			}
			_elem103[_key104] = _val105
		}
		if err := iprot.ReadMapEnd(ctx); err != nil {
			return thrift.PrependError("error reading map end: ", err)
		}
		p.TagsList = append(p.TagsList, _elem103)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]map[string]string, 0, size)
	p.AttributesList =  tSlice
	for i := 0; i < size; i ++ {
		_, _, size, err := iprot.ReadMapBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading map begin: ", err)
		}
		tMap := make(map[string]string, size)
		_elem106 :=  tMap
		for i := 0; i < size; i ++ {
			var _key107 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_key107 = v
			}
			var _val108 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_val108 = v
			}
			_elem106[_key107] = _val108
		}
		if err := iprot.ReadMapEnd(ctx); err != nil {
			return thrift.PrependError("error reading map end: ", err)
		}
		p.AttributesList = append(p.AttributesList, _elem106)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.MeasurementAliasList =  tSlice
	for i := 0; i < size; i ++ {
		var _elem109 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem109 = v
		}
		p.MeasurementAliasList = append(p.MeasurementAliasList, _elem109)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSCreateMultiTimeseriesReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "TSCreateMultiTimeseriesReq"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
		if err := p.writeField4(ctx, oprot); err != nil { return err }
		if err := p.writeField5(ctx, oprot); err != nil { return err }
		if err := p.writeField6(ctx, oprot); err != nil { return err }
		if err := p.writeField7(ctx, oprot); err != nil { return err }
		if err := p.writeField8(ctx, oprot); err != nil { return err }
		if err := p.writeField9(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSCreateMultiTimeseriesReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSCreateMultiTimeseriesReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Paths {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
	return err
}

func (p *TSCreateMultiTimeseriesReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "dataTypes", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:dataTypes: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypes)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.DataTypes {
		if err := oprot.WriteI32(ctx, int32(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:dataTypes: ", p), err) }
	return err
}

func (p *TSCreateMultiTimeseriesReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "encodings", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:encodings: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Encodings)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Encodings {
		if err := oprot.WriteI32(ctx, int32(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:encodings: ", p), err) }
	return err
}

func (p *TSCreateMultiTimeseriesReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "compressors", thrift.LIST, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:compressors: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Compressors)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Compressors {
		if err := oprot.WriteI32(ctx, int32(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:compressors: ", p), err) }
	return err
}

func (p *TSCreateMultiTimeseriesReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetPropsList() {
		if err := oprot.WriteFieldBegin(ctx, "propsList", thrift.LIST, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:propsList: ", p), err) }
		if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.PropsList)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.PropsList {
			if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
				return thrift.PrependError("error writing map begin: ", err)
			}
			for k, v := range v {
				if err := oprot.WriteString(ctx, string(k)); err != nil {
					return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
				if err := oprot.WriteString(ctx, string(v)); err != nil {
					return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			}
			if err := oprot.WriteMapEnd(ctx); err != nil {
				return thrift.PrependError("error writing map end: ", err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:propsList: ", p), err) }
	}
	return err
}

func (p *TSCreateMultiTimeseriesReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetTagsList() {
		if err := oprot.WriteFieldBegin(ctx, "tagsList", thrift.LIST, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:tagsList: ", p), err) }
		if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.TagsList)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.TagsList {
			if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
				return thrift.PrependError("error writing map begin: ", err)
			}
			for k, v := range v {
				if err := oprot.WriteString(ctx, string(k)); err != nil {
					return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
				if err := oprot.WriteString(ctx, string(v)); err != nil {
					return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			}
			if err := oprot.WriteMapEnd(ctx); err != nil {
				return thrift.PrependError("error writing map end: ", err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:tagsList: ", p), err) }
	}
	return err
}

func (p *TSCreateMultiTimeseriesReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetAttributesList() {
		if err := oprot.WriteFieldBegin(ctx, "attributesList", thrift.LIST, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:attributesList: ", p), err) }
		if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.AttributesList)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.AttributesList {
			if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
				return thrift.PrependError("error writing map begin: ", err)
			}
			for k, v := range v {
				if err := oprot.WriteString(ctx, string(k)); err != nil {
					return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
				if err := oprot.WriteString(ctx, string(v)); err != nil {
					return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
			}
			if err := oprot.WriteMapEnd(ctx); err != nil {
				return thrift.PrependError("error writing map end: ", err)
			}
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:attributesList: ", p), err) }
	}
	return err
}

func (p *TSCreateMultiTimeseriesReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetMeasurementAliasList() {
		if err := oprot.WriteFieldBegin(ctx, "measurementAliasList", thrift.LIST, 9); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:measurementAliasList: ", p), err) }
		if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.MeasurementAliasList)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.MeasurementAliasList {
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
		}
		if err := oprot.WriteListEnd(ctx); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 9:measurementAliasList: ", p), err) }
	}
	return err
}

func (p *TSCreateMultiTimeseriesReq) Equals(other *TSCreateMultiTimeseriesReq) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.SessionId != other.SessionId { return false }
	if len(p.Paths) != len(other.Paths) { return false }
	for i, _tgt := range p.Paths {
		_src110 := other.Paths[i]
		if _tgt != _src110 { return false }
	}
	if len(p.DataTypes) != len(other.DataTypes) { return false }
	for i, _tgt := range p.DataTypes {
		_src111 := other.DataTypes[i]
		if _tgt != _src111 { return false }
	}
	if len(p.Encodings) != len(other.Encodings) { return false }
	for i, _tgt := range p.Encodings {
		_src112 := other.Encodings[i]
		if _tgt != _src112 { return false }
	}
	if len(p.Compressors) != len(other.Compressors) { return false }
	for i, _tgt := range p.Compressors {
		_src113 := other.Compressors[i]
		if _tgt != _src113 { return false }
	}
	if len(p.PropsList) != len(other.PropsList) { return false }
	for i, _tgt := range p.PropsList {
		_src114 := other.PropsList[i]
		if len(_tgt) != len(_src114) { return false }
		for k, _tgt := range _tgt {
			_src115 := _src114[k]
			if _tgt != _src115 { return false }
		}
	}
	if len(p.TagsList) != len(other.TagsList) { return false }
	for i, _tgt := range p.TagsList {
		_src116 := other.TagsList[i]
		if len(_tgt) != len(_src116) { return false }
		for k, _tgt := range _tgt {
			_src117 := _src116[k]
			if _tgt != _src117 { return false }
		}
	}
	if len(p.AttributesList) != len(other.AttributesList) { return false }
	for i, _tgt := range p.AttributesList {
		_src118 := other.AttributesList[i]
		if len(_tgt) != len(_src118) { return false }
		for k, _tgt := range _tgt {
			_src119 := _src118[k]
			if _tgt != _src119 { return false }
		}
	}
	if len(p.MeasurementAliasList) != len(other.MeasurementAliasList) { return false }
	for i, _tgt := range p.MeasurementAliasList {
		_src120 := other.MeasurementAliasList[i]
		if _tgt != _src120 { return false }
	}
	return true
}

func (p *TSCreateMultiTimeseriesReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSCreateMultiTimeseriesReq(%+v)", *p)
}

// Attributes:
//  - Version
//  - SupportedTimeAggregationOperations
//  - TimestampPrecision
type ServerProperties struct {
	Version string `thrift:"version,1,required" db:"version" json:"version"`
	SupportedTimeAggregationOperations []string `thrift:"supportedTimeAggregationOperations,2,required" db:"supportedTimeAggregationOperations" json:"supportedTimeAggregationOperations"`
	TimestampPrecision string `thrift:"timestampPrecision,3,required" db:"timestampPrecision" json:"timestampPrecision"`
}

func NewServerProperties() *ServerProperties {
	return &ServerProperties{}
}


func (p *ServerProperties) GetVersion() string {
	return p.Version
}

func (p *ServerProperties) GetSupportedTimeAggregationOperations() []string {
	return p.SupportedTimeAggregationOperations
}

func (p *ServerProperties) GetTimestampPrecision() string {
	return p.TimestampPrecision
}
func (p *ServerProperties) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetVersion bool = false;
	var issetSupportedTimeAggregationOperations bool = false;
	var issetTimestampPrecision bool = false;

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
				issetVersion = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
				issetSupportedTimeAggregationOperations = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
				issetTimestampPrecision = true
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetVersion{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Version is not set"));
	}
	if !issetSupportedTimeAggregationOperations{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SupportedTimeAggregationOperations is not set"));
	}
	if !issetTimestampPrecision{
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimestampPrecision is not set"));
	}
	return nil
}

func (p *ServerProperties)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Version = v
	}
	return nil
}

func (p *ServerProperties)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.SupportedTimeAggregationOperations =  tSlice
	for i := 0; i < size; i ++ {
		var _elem121 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem121 = v
		}
		p.SupportedTimeAggregationOperations = append(p.SupportedTimeAggregationOperations, _elem121)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ServerProperties)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.TimestampPrecision = v
	}
	return nil
}

func (p *ServerProperties) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ServerProperties"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
		if err := p.writeField3(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *ServerProperties) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "version", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:version: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.Version)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.version (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:version: ", p), err) }
	return err
}

func (p *ServerProperties) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "supportedTimeAggregationOperations", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:supportedTimeAggregationOperations: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.SupportedTimeAggregationOperations)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.SupportedTimeAggregationOperations {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:supportedTimeAggregationOperations: ", p), err) }
	return err
}

func (p *ServerProperties) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "timestampPrecision", thrift.STRING, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:timestampPrecision: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.TimestampPrecision)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.timestampPrecision (3) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:timestampPrecision: ", p), err) }
	return err
}

func (p *ServerProperties) Equals(other *ServerProperties) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Version != other.Version { return false }
	if len(p.SupportedTimeAggregationOperations) != len(other.SupportedTimeAggregationOperations) { return false }
	for i, _tgt := range p.SupportedTimeAggregationOperations {
		_src122 := other.SupportedTimeAggregationOperations[i]
		if _tgt != _src122 { return false }
	}
	if p.TimestampPrecision != other.TimestampPrecision { return false }
	return true
}

func (p *ServerProperties) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ServerProperties(%+v)", *p)
}

type TSIService interface {
	// Parameters:
	//  - Req
	OpenSession(ctx context.Context, req *TSOpenSessionReq) (_r *TSOpenSessionResp, _err error)
	// Parameters:
	//  - Req
	CloseSession(ctx context.Context, req *TSCloseSessionReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	ExecuteStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
	// Parameters:
	//  - Req
	ExecuteBatchStatement(ctx context.Context, req *TSExecuteBatchStatementReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	ExecuteQueryStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
	// Parameters:
	//  - Req
	ExecuteUpdateStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
	// Parameters:
	//  - Req
	FetchResults(ctx context.Context, req *TSFetchResultsReq) (_r *TSFetchResultsResp, _err error)
	// Parameters:
	//  - Req
	FetchMetadata(ctx context.Context, req *TSFetchMetadataReq) (_r *TSFetchMetadataResp, _err error)
	// Parameters:
	//  - Req
	CancelOperation(ctx context.Context, req *TSCancelOperationReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	CloseOperation(ctx context.Context, req *TSCloseOperationReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - SessionId
	GetTimeZone(ctx context.Context, sessionId int64) (_r *TSGetTimeZoneResp, _err error)
	// Parameters:
	//  - Req
	SetTimeZone(ctx context.Context, req *TSSetTimeZoneReq) (_r *TSStatus, _err error)
	GetProperties(ctx context.Context) (_r *ServerProperties, _err error)
	// Parameters:
	//  - SessionId
	//  - StorageGroup
	SetStorageGroup(ctx context.Context, sessionId int64, storageGroup string) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	CreateTimeseries(ctx context.Context, req *TSCreateTimeseriesReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	CreateMultiTimeseries(ctx context.Context, req *TSCreateMultiTimeseriesReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - SessionId
	//  - Path
	DeleteTimeseries(ctx context.Context, sessionId int64, path []string) (_r *TSStatus, _err error)
	// Parameters:
	//  - SessionId
	//  - StorageGroup
	DeleteStorageGroups(ctx context.Context, sessionId int64, storageGroup []string) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	InsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	InsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	InsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	InsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	InsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	InsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	InsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	TestInsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	TestInsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	TestInsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	TestInsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	TestInsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	TestInsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	TestInsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	DeleteData(ctx context.Context, req *TSDeleteDataReq) (_r *TSStatus, _err error)
	// Parameters:
	//  - Req
	ExecuteRawDataQuery(ctx context.Context, req *TSRawDataQueryReq) (_r *TSExecuteStatementResp, _err error)
	// Parameters:
	//  - SessionId
	RequestStatementId(ctx context.Context, sessionId int64) (_r int64, _err error)
}

type TSIServiceClient struct {
	c thrift.TClient
	meta thrift.ResponseMeta
}

func NewTSIServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *TSIServiceClient {
	return &TSIServiceClient{
		c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
	}
}

func NewTSIServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *TSIServiceClient {
	return &TSIServiceClient{
		c: thrift.NewTStandardClient(iprot, oprot),
	}
}

func NewTSIServiceClient(c thrift.TClient) *TSIServiceClient {
	return &TSIServiceClient{
		c: c,
	}
}

func (p *TSIServiceClient) Client_() thrift.TClient {
	return p.c
}

func (p *TSIServiceClient) LastResponseMeta_() thrift.ResponseMeta {
	return p.meta
}

func (p *TSIServiceClient) SetLastResponseMeta_(meta thrift.ResponseMeta) {
	p.meta = meta
}

// Parameters:
//  - Req
func (p *TSIServiceClient) OpenSession(ctx context.Context, req *TSOpenSessionReq) (_r *TSOpenSessionResp, _err error) {
	var _args123 TSIServiceOpenSessionArgs
	_args123.Req = req
	var _result125 TSIServiceOpenSessionResult
	var _meta124 thrift.ResponseMeta
	_meta124, _err = p.Client_().Call(ctx, "openSession", &_args123, &_result125)
	p.SetLastResponseMeta_(_meta124)
	if _err != nil {
		return
	}
	return _result125.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CloseSession(ctx context.Context, req *TSCloseSessionReq) (_r *TSStatus, _err error) {
	var _args126 TSIServiceCloseSessionArgs
	_args126.Req = req
	var _result128 TSIServiceCloseSessionResult
	var _meta127 thrift.ResponseMeta
	_meta127, _err = p.Client_().Call(ctx, "closeSession", &_args126, &_result128)
	p.SetLastResponseMeta_(_meta127)
	if _err != nil {
		return
	}
	return _result128.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
	var _args129 TSIServiceExecuteStatementArgs
	_args129.Req = req
	var _result131 TSIServiceExecuteStatementResult
	var _meta130 thrift.ResponseMeta
	_meta130, _err = p.Client_().Call(ctx, "executeStatement", &_args129, &_result131)
	p.SetLastResponseMeta_(_meta130)
	if _err != nil {
		return
	}
	return _result131.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteBatchStatement(ctx context.Context, req *TSExecuteBatchStatementReq) (_r *TSStatus, _err error) {
	var _args132 TSIServiceExecuteBatchStatementArgs
	_args132.Req = req
	var _result134 TSIServiceExecuteBatchStatementResult
	var _meta133 thrift.ResponseMeta
	_meta133, _err = p.Client_().Call(ctx, "executeBatchStatement", &_args132, &_result134)
	p.SetLastResponseMeta_(_meta133)
	if _err != nil {
		return
	}
	return _result134.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteQueryStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
	var _args135 TSIServiceExecuteQueryStatementArgs
	_args135.Req = req
	var _result137 TSIServiceExecuteQueryStatementResult
	var _meta136 thrift.ResponseMeta
	_meta136, _err = p.Client_().Call(ctx, "executeQueryStatement", &_args135, &_result137)
	p.SetLastResponseMeta_(_meta136)
	if _err != nil {
		return
	}
	return _result137.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteUpdateStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
	var _args138 TSIServiceExecuteUpdateStatementArgs
	_args138.Req = req
	var _result140 TSIServiceExecuteUpdateStatementResult
	var _meta139 thrift.ResponseMeta
	_meta139, _err = p.Client_().Call(ctx, "executeUpdateStatement", &_args138, &_result140)
	p.SetLastResponseMeta_(_meta139)
	if _err != nil {
		return
	}
	return _result140.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) FetchResults(ctx context.Context, req *TSFetchResultsReq) (_r *TSFetchResultsResp, _err error) {
	var _args141 TSIServiceFetchResultsArgs
	_args141.Req = req
	var _result143 TSIServiceFetchResultsResult
	var _meta142 thrift.ResponseMeta
	_meta142, _err = p.Client_().Call(ctx, "fetchResults", &_args141, &_result143)
	p.SetLastResponseMeta_(_meta142)
	if _err != nil {
		return
	}
	return _result143.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) FetchMetadata(ctx context.Context, req *TSFetchMetadataReq) (_r *TSFetchMetadataResp, _err error) {
	var _args144 TSIServiceFetchMetadataArgs
	_args144.Req = req
	var _result146 TSIServiceFetchMetadataResult
	var _meta145 thrift.ResponseMeta
	_meta145, _err = p.Client_().Call(ctx, "fetchMetadata", &_args144, &_result146)
	p.SetLastResponseMeta_(_meta145)
	if _err != nil {
		return
	}
	return _result146.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CancelOperation(ctx context.Context, req *TSCancelOperationReq) (_r *TSStatus, _err error) {
	var _args147 TSIServiceCancelOperationArgs
	_args147.Req = req
	var _result149 TSIServiceCancelOperationResult
	var _meta148 thrift.ResponseMeta
	_meta148, _err = p.Client_().Call(ctx, "cancelOperation", &_args147, &_result149)
	p.SetLastResponseMeta_(_meta148)
	if _err != nil {
		return
	}
	return _result149.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CloseOperation(ctx context.Context, req *TSCloseOperationReq) (_r *TSStatus, _err error) {
	var _args150 TSIServiceCloseOperationArgs
	_args150.Req = req
	var _result152 TSIServiceCloseOperationResult
	var _meta151 thrift.ResponseMeta
	_meta151, _err = p.Client_().Call(ctx, "closeOperation", &_args150, &_result152)
	p.SetLastResponseMeta_(_meta151)
	if _err != nil {
		return
	}
	return _result152.GetSuccess(), nil
}

// Parameters:
//  - SessionId
func (p *TSIServiceClient) GetTimeZone(ctx context.Context, sessionId int64) (_r *TSGetTimeZoneResp, _err error) {
	var _args153 TSIServiceGetTimeZoneArgs
	_args153.SessionId = sessionId
	var _result155 TSIServiceGetTimeZoneResult
	var _meta154 thrift.ResponseMeta
	_meta154, _err = p.Client_().Call(ctx, "getTimeZone", &_args153, &_result155)
	p.SetLastResponseMeta_(_meta154)
	if _err != nil {
		return
	}
	return _result155.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) SetTimeZone(ctx context.Context, req *TSSetTimeZoneReq) (_r *TSStatus, _err error) {
	var _args156 TSIServiceSetTimeZoneArgs
	_args156.Req = req
	var _result158 TSIServiceSetTimeZoneResult
	var _meta157 thrift.ResponseMeta
	_meta157, _err = p.Client_().Call(ctx, "setTimeZone", &_args156, &_result158)
	p.SetLastResponseMeta_(_meta157)
	if _err != nil {
		return
	}
	return _result158.GetSuccess(), nil
}

func (p *TSIServiceClient) GetProperties(ctx context.Context) (_r *ServerProperties, _err error) {
	var _args159 TSIServiceGetPropertiesArgs
	var _result161 TSIServiceGetPropertiesResult
	var _meta160 thrift.ResponseMeta
	_meta160, _err = p.Client_().Call(ctx, "getProperties", &_args159, &_result161)
	p.SetLastResponseMeta_(_meta160)
	if _err != nil {
		return
	}
	return _result161.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - StorageGroup
func (p *TSIServiceClient) SetStorageGroup(ctx context.Context, sessionId int64, storageGroup string) (_r *TSStatus, _err error) {
	var _args162 TSIServiceSetStorageGroupArgs
	_args162.SessionId = sessionId
	_args162.StorageGroup = storageGroup
	var _result164 TSIServiceSetStorageGroupResult
	var _meta163 thrift.ResponseMeta
	_meta163, _err = p.Client_().Call(ctx, "setStorageGroup", &_args162, &_result164)
	p.SetLastResponseMeta_(_meta163)
	if _err != nil {
		return
	}
	return _result164.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CreateTimeseries(ctx context.Context, req *TSCreateTimeseriesReq) (_r *TSStatus, _err error) {
	var _args165 TSIServiceCreateTimeseriesArgs
	_args165.Req = req
	var _result167 TSIServiceCreateTimeseriesResult
	var _meta166 thrift.ResponseMeta
	_meta166, _err = p.Client_().Call(ctx, "createTimeseries", &_args165, &_result167)
	p.SetLastResponseMeta_(_meta166)
	if _err != nil {
		return
	}
	return _result167.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CreateMultiTimeseries(ctx context.Context, req *TSCreateMultiTimeseriesReq) (_r *TSStatus, _err error) {
	var _args168 TSIServiceCreateMultiTimeseriesArgs
	_args168.Req = req
	var _result170 TSIServiceCreateMultiTimeseriesResult
	var _meta169 thrift.ResponseMeta
	_meta169, _err = p.Client_().Call(ctx, "createMultiTimeseries", &_args168, &_result170)
	p.SetLastResponseMeta_(_meta169)
	if _err != nil {
		return
	}
	return _result170.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - Path
func (p *TSIServiceClient) DeleteTimeseries(ctx context.Context, sessionId int64, path []string) (_r *TSStatus, _err error) {
	var _args171 TSIServiceDeleteTimeseriesArgs
	_args171.SessionId = sessionId
	_args171.Path = path
	var _result173 TSIServiceDeleteTimeseriesResult
	var _meta172 thrift.ResponseMeta
	_meta172, _err = p.Client_().Call(ctx, "deleteTimeseries", &_args171, &_result173)
	p.SetLastResponseMeta_(_meta172)
	if _err != nil {
		return
	}
	return _result173.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - StorageGroup
func (p *TSIServiceClient) DeleteStorageGroups(ctx context.Context, sessionId int64, storageGroup []string) (_r *TSStatus, _err error) {
	var _args174 TSIServiceDeleteStorageGroupsArgs
	_args174.SessionId = sessionId
	_args174.StorageGroup = storageGroup
	var _result176 TSIServiceDeleteStorageGroupsResult
	var _meta175 thrift.ResponseMeta
	_meta175, _err = p.Client_().Call(ctx, "deleteStorageGroups", &_args174, &_result176)
	p.SetLastResponseMeta_(_meta175)
	if _err != nil {
		return
	}
	return _result176.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *TSStatus, _err error) {
	var _args177 TSIServiceInsertRecordArgs
	_args177.Req = req
	var _result179 TSIServiceInsertRecordResult
	var _meta178 thrift.ResponseMeta
	_meta178, _err = p.Client_().Call(ctx, "insertRecord", &_args177, &_result179)
	p.SetLastResponseMeta_(_meta178)
	if _err != nil {
		return
	}
	return _result179.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *TSStatus, _err error) {
	var _args180 TSIServiceInsertStringRecordArgs
	_args180.Req = req
	var _result182 TSIServiceInsertStringRecordResult
	var _meta181 thrift.ResponseMeta
	_meta181, _err = p.Client_().Call(ctx, "insertStringRecord", &_args180, &_result182)
	p.SetLastResponseMeta_(_meta181)
	if _err != nil {
		return
	}
	return _result182.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *TSStatus, _err error) {
	var _args183 TSIServiceInsertTabletArgs
	_args183.Req = req
	var _result185 TSIServiceInsertTabletResult
	var _meta184 thrift.ResponseMeta
	_meta184, _err = p.Client_().Call(ctx, "insertTablet", &_args183, &_result185)
	p.SetLastResponseMeta_(_meta184)
	if _err != nil {
		return
	}
	return _result185.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *TSStatus, _err error) {
	var _args186 TSIServiceInsertTabletsArgs
	_args186.Req = req
	var _result188 TSIServiceInsertTabletsResult
	var _meta187 thrift.ResponseMeta
	_meta187, _err = p.Client_().Call(ctx, "insertTablets", &_args186, &_result188)
	p.SetLastResponseMeta_(_meta187)
	if _err != nil {
		return
	}
	return _result188.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *TSStatus, _err error) {
	var _args189 TSIServiceInsertRecordsArgs
	_args189.Req = req
	var _result191 TSIServiceInsertRecordsResult
	var _meta190 thrift.ResponseMeta
	_meta190, _err = p.Client_().Call(ctx, "insertRecords", &_args189, &_result191)
	p.SetLastResponseMeta_(_meta190)
	if _err != nil {
		return
	}
	return _result191.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *TSStatus, _err error) {
	var _args192 TSIServiceInsertRecordsOfOneDeviceArgs
	_args192.Req = req
	var _result194 TSIServiceInsertRecordsOfOneDeviceResult
	var _meta193 thrift.ResponseMeta
	_meta193, _err = p.Client_().Call(ctx, "insertRecordsOfOneDevice", &_args192, &_result194)
	p.SetLastResponseMeta_(_meta193)
	if _err != nil {
		return
	}
	return _result194.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *TSStatus, _err error) {
	var _args195 TSIServiceInsertStringRecordsArgs
	_args195.Req = req
	var _result197 TSIServiceInsertStringRecordsResult
	var _meta196 thrift.ResponseMeta
	_meta196, _err = p.Client_().Call(ctx, "insertStringRecords", &_args195, &_result197)
	p.SetLastResponseMeta_(_meta196)
	if _err != nil {
		return
	}
	return _result197.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *TSStatus, _err error) {
	var _args198 TSIServiceTestInsertTabletArgs
	_args198.Req = req
	var _result200 TSIServiceTestInsertTabletResult
	var _meta199 thrift.ResponseMeta
	_meta199, _err = p.Client_().Call(ctx, "testInsertTablet", &_args198, &_result200)
	p.SetLastResponseMeta_(_meta199)
	if _err != nil {
		return
	}
	return _result200.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *TSStatus, _err error) {
	var _args201 TSIServiceTestInsertTabletsArgs
	_args201.Req = req
	var _result203 TSIServiceTestInsertTabletsResult
	var _meta202 thrift.ResponseMeta
	_meta202, _err = p.Client_().Call(ctx, "testInsertTablets", &_args201, &_result203)
	p.SetLastResponseMeta_(_meta202)
	if _err != nil {
		return
	}
	return _result203.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *TSStatus, _err error) {
	var _args204 TSIServiceTestInsertRecordArgs
	_args204.Req = req
	var _result206 TSIServiceTestInsertRecordResult
	var _meta205 thrift.ResponseMeta
	_meta205, _err = p.Client_().Call(ctx, "testInsertRecord", &_args204, &_result206)
	p.SetLastResponseMeta_(_meta205)
	if _err != nil {
		return
	}
	return _result206.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *TSStatus, _err error) {
	var _args207 TSIServiceTestInsertStringRecordArgs
	_args207.Req = req
	var _result209 TSIServiceTestInsertStringRecordResult
	var _meta208 thrift.ResponseMeta
	_meta208, _err = p.Client_().Call(ctx, "testInsertStringRecord", &_args207, &_result209)
	p.SetLastResponseMeta_(_meta208)
	if _err != nil {
		return
	}
	return _result209.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *TSStatus, _err error) {
	var _args210 TSIServiceTestInsertRecordsArgs
	_args210.Req = req
	var _result212 TSIServiceTestInsertRecordsResult
	var _meta211 thrift.ResponseMeta
	_meta211, _err = p.Client_().Call(ctx, "testInsertRecords", &_args210, &_result212)
	p.SetLastResponseMeta_(_meta211)
	if _err != nil {
		return
	}
	return _result212.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *TSStatus, _err error) {
	var _args213 TSIServiceTestInsertRecordsOfOneDeviceArgs
	_args213.Req = req
	var _result215 TSIServiceTestInsertRecordsOfOneDeviceResult
	var _meta214 thrift.ResponseMeta
	_meta214, _err = p.Client_().Call(ctx, "testInsertRecordsOfOneDevice", &_args213, &_result215)
	p.SetLastResponseMeta_(_meta214)
	if _err != nil {
		return
	}
	return _result215.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *TSStatus, _err error) {
	var _args216 TSIServiceTestInsertStringRecordsArgs
	_args216.Req = req
	var _result218 TSIServiceTestInsertStringRecordsResult
	var _meta217 thrift.ResponseMeta
	_meta217, _err = p.Client_().Call(ctx, "testInsertStringRecords", &_args216, &_result218)
	p.SetLastResponseMeta_(_meta217)
	if _err != nil {
		return
	}
	return _result218.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) DeleteData(ctx context.Context, req *TSDeleteDataReq) (_r *TSStatus, _err error) {
	var _args219 TSIServiceDeleteDataArgs
	_args219.Req = req
	var _result221 TSIServiceDeleteDataResult
	var _meta220 thrift.ResponseMeta
	_meta220, _err = p.Client_().Call(ctx, "deleteData", &_args219, &_result221)
	p.SetLastResponseMeta_(_meta220)
	if _err != nil {
		return
	}
	return _result221.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteRawDataQuery(ctx context.Context, req *TSRawDataQueryReq) (_r *TSExecuteStatementResp, _err error) {
	var _args222 TSIServiceExecuteRawDataQueryArgs
	_args222.Req = req
	var _result224 TSIServiceExecuteRawDataQueryResult
	var _meta223 thrift.ResponseMeta
	_meta223, _err = p.Client_().Call(ctx, "executeRawDataQuery", &_args222, &_result224)
	p.SetLastResponseMeta_(_meta223)
	if _err != nil {
		return
	}
	return _result224.GetSuccess(), nil
}

// Parameters:
//  - SessionId
func (p *TSIServiceClient) RequestStatementId(ctx context.Context, sessionId int64) (_r int64, _err error) {
	var _args225 TSIServiceRequestStatementIdArgs
	_args225.SessionId = sessionId
	var _result227 TSIServiceRequestStatementIdResult
	var _meta226 thrift.ResponseMeta
	_meta226, _err = p.Client_().Call(ctx, "requestStatementId", &_args225, &_result227)
	p.SetLastResponseMeta_(_meta226)
	if _err != nil {
		return
	}
	return _result227.GetSuccess(), nil
}

type TSIServiceProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler TSIService
}

func (p *TSIServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *TSIServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *TSIServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewTSIServiceProcessor(handler TSIService) *TSIServiceProcessor {

	self228 := &TSIServiceProcessor{handler:handler, processorMap:make(map[string]thrift.TProcessorFunction)}
	self228.processorMap["openSession"] = &tSIServiceProcessorOpenSession{handler:handler}
	self228.processorMap["closeSession"] = &tSIServiceProcessorCloseSession{handler:handler}
	self228.processorMap["executeStatement"] = &tSIServiceProcessorExecuteStatement{handler:handler}
	self228.processorMap["executeBatchStatement"] = &tSIServiceProcessorExecuteBatchStatement{handler:handler}
	self228.processorMap["executeQueryStatement"] = &tSIServiceProcessorExecuteQueryStatement{handler:handler}
	self228.processorMap["executeUpdateStatement"] = &tSIServiceProcessorExecuteUpdateStatement{handler:handler}
	self228.processorMap["fetchResults"] = &tSIServiceProcessorFetchResults{handler:handler}
	self228.processorMap["fetchMetadata"] = &tSIServiceProcessorFetchMetadata{handler:handler}
	self228.processorMap["cancelOperation"] = &tSIServiceProcessorCancelOperation{handler:handler}
	self228.processorMap["closeOperation"] = &tSIServiceProcessorCloseOperation{handler:handler}
	self228.processorMap["getTimeZone"] = &tSIServiceProcessorGetTimeZone{handler:handler}
	self228.processorMap["setTimeZone"] = &tSIServiceProcessorSetTimeZone{handler:handler}
	self228.processorMap["getProperties"] = &tSIServiceProcessorGetProperties{handler:handler}
	self228.processorMap["setStorageGroup"] = &tSIServiceProcessorSetStorageGroup{handler:handler}
	self228.processorMap["createTimeseries"] = &tSIServiceProcessorCreateTimeseries{handler:handler}
	self228.processorMap["createMultiTimeseries"] = &tSIServiceProcessorCreateMultiTimeseries{handler:handler}
	self228.processorMap["deleteTimeseries"] = &tSIServiceProcessorDeleteTimeseries{handler:handler}
	self228.processorMap["deleteStorageGroups"] = &tSIServiceProcessorDeleteStorageGroups{handler:handler}
	self228.processorMap["insertRecord"] = &tSIServiceProcessorInsertRecord{handler:handler}
	self228.processorMap["insertStringRecord"] = &tSIServiceProcessorInsertStringRecord{handler:handler}
	self228.processorMap["insertTablet"] = &tSIServiceProcessorInsertTablet{handler:handler}
	self228.processorMap["insertTablets"] = &tSIServiceProcessorInsertTablets{handler:handler}
	self228.processorMap["insertRecords"] = &tSIServiceProcessorInsertRecords{handler:handler}
	self228.processorMap["insertRecordsOfOneDevice"] = &tSIServiceProcessorInsertRecordsOfOneDevice{handler:handler}
	self228.processorMap["insertStringRecords"] = &tSIServiceProcessorInsertStringRecords{handler:handler}
	self228.processorMap["testInsertTablet"] = &tSIServiceProcessorTestInsertTablet{handler:handler}
	self228.processorMap["testInsertTablets"] = &tSIServiceProcessorTestInsertTablets{handler:handler}
	self228.processorMap["testInsertRecord"] = &tSIServiceProcessorTestInsertRecord{handler:handler}
	self228.processorMap["testInsertStringRecord"] = &tSIServiceProcessorTestInsertStringRecord{handler:handler}
	self228.processorMap["testInsertRecords"] = &tSIServiceProcessorTestInsertRecords{handler:handler}
	self228.processorMap["testInsertRecordsOfOneDevice"] = &tSIServiceProcessorTestInsertRecordsOfOneDevice{handler:handler}
	self228.processorMap["testInsertStringRecords"] = &tSIServiceProcessorTestInsertStringRecords{handler:handler}
	self228.processorMap["deleteData"] = &tSIServiceProcessorDeleteData{handler:handler}
	self228.processorMap["executeRawDataQuery"] = &tSIServiceProcessorExecuteRawDataQuery{handler:handler}
	self228.processorMap["requestStatementId"] = &tSIServiceProcessorRequestStatementId{handler:handler}
	return self228
}

func (p *TSIServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err2 := iprot.ReadMessageBegin(ctx)
	if err2 != nil { return false, thrift.WrapTException(err2) }
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(ctx, seqId, iprot, oprot)
	}
	iprot.Skip(ctx, thrift.STRUCT)
	iprot.ReadMessageEnd(ctx)
	x229 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function " + name)
	oprot.WriteMessageBegin(ctx, name, thrift.EXCEPTION, seqId)
	x229.Write(ctx, oprot)
	oprot.WriteMessageEnd(ctx)
	oprot.Flush(ctx)
	return false, x229

}

type tSIServiceProcessorOpenSession struct {
	handler TSIService
}

func (p *tSIServiceProcessorOpenSession) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceOpenSessionArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "openSession", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceOpenSessionResult{}
	var retval *TSOpenSessionResp
	if retval, err2 = p.handler.OpenSession(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing openSession: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "openSession", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "openSession", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorCloseSession struct {
	handler TSIService
}

func (p *tSIServiceProcessorCloseSession) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceCloseSessionArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "closeSession", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceCloseSessionResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.CloseSession(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing closeSession: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "closeSession", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "closeSession", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorExecuteStatement struct {
	handler TSIService
}

func (p *tSIServiceProcessorExecuteStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceExecuteStatementArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "executeStatement", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceExecuteStatementResult{}
	var retval *TSExecuteStatementResp
	if retval, err2 = p.handler.ExecuteStatement(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeStatement: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "executeStatement", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "executeStatement", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorExecuteBatchStatement struct {
	handler TSIService
}

func (p *tSIServiceProcessorExecuteBatchStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceExecuteBatchStatementArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceExecuteBatchStatementResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.ExecuteBatchStatement(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeBatchStatement: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorExecuteQueryStatement struct {
	handler TSIService
}

func (p *tSIServiceProcessorExecuteQueryStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceExecuteQueryStatementArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceExecuteQueryStatementResult{}
	var retval *TSExecuteStatementResp
	if retval, err2 = p.handler.ExecuteQueryStatement(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeQueryStatement: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorExecuteUpdateStatement struct {
	handler TSIService
}

func (p *tSIServiceProcessorExecuteUpdateStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceExecuteUpdateStatementArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceExecuteUpdateStatementResult{}
	var retval *TSExecuteStatementResp
	if retval, err2 = p.handler.ExecuteUpdateStatement(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeUpdateStatement: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorFetchResults struct {
	handler TSIService
}

func (p *tSIServiceProcessorFetchResults) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceFetchResultsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "fetchResults", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceFetchResultsResult{}
	var retval *TSFetchResultsResp
	if retval, err2 = p.handler.FetchResults(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchResults: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "fetchResults", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "fetchResults", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorFetchMetadata struct {
	handler TSIService
}

func (p *tSIServiceProcessorFetchMetadata) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceFetchMetadataArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceFetchMetadataResult{}
	var retval *TSFetchMetadataResp
	if retval, err2 = p.handler.FetchMetadata(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchMetadata: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorCancelOperation struct {
	handler TSIService
}

func (p *tSIServiceProcessorCancelOperation) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceCancelOperationArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceCancelOperationResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.CancelOperation(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing cancelOperation: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorCloseOperation struct {
	handler TSIService
}

func (p *tSIServiceProcessorCloseOperation) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceCloseOperationArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "closeOperation", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceCloseOperationResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.CloseOperation(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing closeOperation: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "closeOperation", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "closeOperation", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorGetTimeZone struct {
	handler TSIService
}

func (p *tSIServiceProcessorGetTimeZone) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceGetTimeZoneArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceGetTimeZoneResult{}
	var retval *TSGetTimeZoneResp
	if retval, err2 = p.handler.GetTimeZone(ctx, args.SessionId); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getTimeZone: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorSetTimeZone struct {
	handler TSIService
}

func (p *tSIServiceProcessorSetTimeZone) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceSetTimeZoneArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceSetTimeZoneResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.SetTimeZone(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setTimeZone: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorGetProperties struct {
	handler TSIService
}

func (p *tSIServiceProcessorGetProperties) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceGetPropertiesArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "getProperties", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceGetPropertiesResult{}
	var retval *ServerProperties
	if retval, err2 = p.handler.GetProperties(ctx); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getProperties: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "getProperties", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "getProperties", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorSetStorageGroup struct {
	handler TSIService
}

func (p *tSIServiceProcessorSetStorageGroup) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceSetStorageGroupArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceSetStorageGroupResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.SetStorageGroup(ctx, args.SessionId, args.StorageGroup); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setStorageGroup: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorCreateTimeseries struct {
	handler TSIService
}

func (p *tSIServiceProcessorCreateTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceCreateTimeseriesArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceCreateTimeseriesResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.CreateTimeseries(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createTimeseries: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorCreateMultiTimeseries struct {
	handler TSIService
}

func (p *tSIServiceProcessorCreateMultiTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceCreateMultiTimeseriesArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceCreateMultiTimeseriesResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.CreateMultiTimeseries(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createMultiTimeseries: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorDeleteTimeseries struct {
	handler TSIService
}

func (p *tSIServiceProcessorDeleteTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceDeleteTimeseriesArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceDeleteTimeseriesResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.DeleteTimeseries(ctx, args.SessionId, args.Path); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteTimeseries: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorDeleteStorageGroups struct {
	handler TSIService
}

func (p *tSIServiceProcessorDeleteStorageGroups) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceDeleteStorageGroupsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceDeleteStorageGroupsResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.DeleteStorageGroups(ctx, args.SessionId, args.StorageGroup); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteStorageGroups: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorInsertRecord struct {
	handler TSIService
}

func (p *tSIServiceProcessorInsertRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceInsertRecordArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "insertRecord", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceInsertRecordResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.InsertRecord(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecord: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "insertRecord", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "insertRecord", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorInsertStringRecord struct {
	handler TSIService
}

func (p *tSIServiceProcessorInsertStringRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceInsertStringRecordArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceInsertStringRecordResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.InsertStringRecord(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertStringRecord: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorInsertTablet struct {
	handler TSIService
}

func (p *tSIServiceProcessorInsertTablet) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceInsertTabletArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "insertTablet", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceInsertTabletResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.InsertTablet(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertTablet: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "insertTablet", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "insertTablet", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorInsertTablets struct {
	handler TSIService
}

func (p *tSIServiceProcessorInsertTablets) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceInsertTabletsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "insertTablets", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceInsertTabletsResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.InsertTablets(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertTablets: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "insertTablets", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "insertTablets", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorInsertRecords struct {
	handler TSIService
}

func (p *tSIServiceProcessorInsertRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceInsertRecordsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "insertRecords", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceInsertRecordsResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.InsertRecords(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecords: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "insertRecords", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "insertRecords", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorInsertRecordsOfOneDevice struct {
	handler TSIService
}

func (p *tSIServiceProcessorInsertRecordsOfOneDevice) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceInsertRecordsOfOneDeviceArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceInsertRecordsOfOneDeviceResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.InsertRecordsOfOneDevice(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecordsOfOneDevice: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorInsertStringRecords struct {
	handler TSIService
}

func (p *tSIServiceProcessorInsertStringRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceInsertStringRecordsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceInsertStringRecordsResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.InsertStringRecords(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertStringRecords: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorTestInsertTablet struct {
	handler TSIService
}

func (p *tSIServiceProcessorTestInsertTablet) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceTestInsertTabletArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceTestInsertTabletResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.TestInsertTablet(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertTablet: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorTestInsertTablets struct {
	handler TSIService
}

func (p *tSIServiceProcessorTestInsertTablets) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceTestInsertTabletsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceTestInsertTabletsResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.TestInsertTablets(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertTablets: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorTestInsertRecord struct {
	handler TSIService
}

func (p *tSIServiceProcessorTestInsertRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceTestInsertRecordArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceTestInsertRecordResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.TestInsertRecord(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecord: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorTestInsertStringRecord struct {
	handler TSIService
}

func (p *tSIServiceProcessorTestInsertStringRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceTestInsertStringRecordArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceTestInsertStringRecordResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.TestInsertStringRecord(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertStringRecord: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorTestInsertRecords struct {
	handler TSIService
}

func (p *tSIServiceProcessorTestInsertRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceTestInsertRecordsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceTestInsertRecordsResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.TestInsertRecords(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecords: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorTestInsertRecordsOfOneDevice struct {
	handler TSIService
}

func (p *tSIServiceProcessorTestInsertRecordsOfOneDevice) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceTestInsertRecordsOfOneDeviceArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceTestInsertRecordsOfOneDeviceResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.TestInsertRecordsOfOneDevice(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecordsOfOneDevice: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorTestInsertStringRecords struct {
	handler TSIService
}

func (p *tSIServiceProcessorTestInsertStringRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceTestInsertStringRecordsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceTestInsertStringRecordsResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.TestInsertStringRecords(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertStringRecords: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorDeleteData struct {
	handler TSIService
}

func (p *tSIServiceProcessorDeleteData) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceDeleteDataArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "deleteData", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceDeleteDataResult{}
	var retval *TSStatus
	if retval, err2 = p.handler.DeleteData(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteData: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "deleteData", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "deleteData", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorExecuteRawDataQuery struct {
	handler TSIService
}

func (p *tSIServiceProcessorExecuteRawDataQuery) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceExecuteRawDataQueryArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceExecuteRawDataQueryResult{}
	var retval *TSExecuteStatementResp
	if retval, err2 = p.handler.ExecuteRawDataQuery(ctx, args.Req); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeRawDataQuery: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type tSIServiceProcessorRequestStatementId struct {
	handler TSIService
}

func (p *tSIServiceProcessorRequestStatementId) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := TSIServiceRequestStatementIdArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := TSIServiceRequestStatementIdResult{}
	var retval int64
	if retval, err2 = p.handler.RequestStatementId(ctx, args.SessionId); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing requestStatementId: " + err2.Error())
		oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = &retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Req
type TSIServiceOpenSessionArgs struct {
	Req *TSOpenSessionReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceOpenSessionArgs() *TSIServiceOpenSessionArgs {
	return &TSIServiceOpenSessionArgs{}
}

var TSIServiceOpenSessionArgs_Req_DEFAULT *TSOpenSessionReq
func (p *TSIServiceOpenSessionArgs) GetReq() *TSOpenSessionReq {
	if !p.IsSetReq() {
		return TSIServiceOpenSessionArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceOpenSessionArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceOpenSessionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceOpenSessionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSOpenSessionReq{
		ClientProtocol:   2,
	}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceOpenSessionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "openSession_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceOpenSessionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceOpenSessionArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceOpenSessionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceOpenSessionResult struct {
	Success *TSOpenSessionResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceOpenSessionResult() *TSIServiceOpenSessionResult {
	return &TSIServiceOpenSessionResult{}
}

var TSIServiceOpenSessionResult_Success_DEFAULT *TSOpenSessionResp
func (p *TSIServiceOpenSessionResult) GetSuccess() *TSOpenSessionResp {
	if !p.IsSetSuccess() {
		return TSIServiceOpenSessionResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceOpenSessionResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceOpenSessionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceOpenSessionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSOpenSessionResp{
		ServerProtocolVersion:   0,
	}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceOpenSessionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "openSession_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceOpenSessionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceOpenSessionResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceOpenSessionResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCloseSessionArgs struct {
	Req *TSCloseSessionReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCloseSessionArgs() *TSIServiceCloseSessionArgs {
	return &TSIServiceCloseSessionArgs{}
}

var TSIServiceCloseSessionArgs_Req_DEFAULT *TSCloseSessionReq
func (p *TSIServiceCloseSessionArgs) GetReq() *TSCloseSessionReq {
	if !p.IsSetReq() {
		return TSIServiceCloseSessionArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceCloseSessionArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceCloseSessionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCloseSessionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSCloseSessionReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceCloseSessionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "closeSession_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCloseSessionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceCloseSessionArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCloseSessionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCloseSessionResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCloseSessionResult() *TSIServiceCloseSessionResult {
	return &TSIServiceCloseSessionResult{}
}

var TSIServiceCloseSessionResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCloseSessionResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceCloseSessionResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceCloseSessionResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceCloseSessionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCloseSessionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceCloseSessionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "closeSession_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCloseSessionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceCloseSessionResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCloseSessionResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteStatementArgs struct {
	Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteStatementArgs() *TSIServiceExecuteStatementArgs {
	return &TSIServiceExecuteStatementArgs{}
}

var TSIServiceExecuteStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *TSIServiceExecuteStatementArgs) GetReq() *TSExecuteStatementReq {
	if !p.IsSetReq() {
		return TSIServiceExecuteStatementArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceExecuteStatementArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceExecuteStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSExecuteStatementReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceExecuteStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeStatement_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceExecuteStatementArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteStatementResult struct {
	Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteStatementResult() *TSIServiceExecuteStatementResult {
	return &TSIServiceExecuteStatementResult{}
}

var TSIServiceExecuteStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteStatementResult) GetSuccess() *TSExecuteStatementResp {
	if !p.IsSetSuccess() {
		return TSIServiceExecuteStatementResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceExecuteStatementResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceExecuteStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSExecuteStatementResp{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceExecuteStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeStatement_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceExecuteStatementResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteBatchStatementArgs struct {
	Req *TSExecuteBatchStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteBatchStatementArgs() *TSIServiceExecuteBatchStatementArgs {
	return &TSIServiceExecuteBatchStatementArgs{}
}

var TSIServiceExecuteBatchStatementArgs_Req_DEFAULT *TSExecuteBatchStatementReq
func (p *TSIServiceExecuteBatchStatementArgs) GetReq() *TSExecuteBatchStatementReq {
	if !p.IsSetReq() {
		return TSIServiceExecuteBatchStatementArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceExecuteBatchStatementArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceExecuteBatchStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteBatchStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSExecuteBatchStatementReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceExecuteBatchStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeBatchStatement_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteBatchStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceExecuteBatchStatementArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteBatchStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteBatchStatementResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteBatchStatementResult() *TSIServiceExecuteBatchStatementResult {
	return &TSIServiceExecuteBatchStatementResult{}
}

var TSIServiceExecuteBatchStatementResult_Success_DEFAULT *TSStatus
func (p *TSIServiceExecuteBatchStatementResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceExecuteBatchStatementResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceExecuteBatchStatementResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceExecuteBatchStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteBatchStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceExecuteBatchStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeBatchStatement_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteBatchStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceExecuteBatchStatementResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteBatchStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteQueryStatementArgs struct {
	Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteQueryStatementArgs() *TSIServiceExecuteQueryStatementArgs {
	return &TSIServiceExecuteQueryStatementArgs{}
}

var TSIServiceExecuteQueryStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *TSIServiceExecuteQueryStatementArgs) GetReq() *TSExecuteStatementReq {
	if !p.IsSetReq() {
		return TSIServiceExecuteQueryStatementArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceExecuteQueryStatementArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceExecuteQueryStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteQueryStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSExecuteStatementReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceExecuteQueryStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeQueryStatement_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteQueryStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceExecuteQueryStatementArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteQueryStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteQueryStatementResult struct {
	Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteQueryStatementResult() *TSIServiceExecuteQueryStatementResult {
	return &TSIServiceExecuteQueryStatementResult{}
}

var TSIServiceExecuteQueryStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteQueryStatementResult) GetSuccess() *TSExecuteStatementResp {
	if !p.IsSetSuccess() {
		return TSIServiceExecuteQueryStatementResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceExecuteQueryStatementResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceExecuteQueryStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteQueryStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSExecuteStatementResp{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceExecuteQueryStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeQueryStatement_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteQueryStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceExecuteQueryStatementResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteQueryStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteUpdateStatementArgs struct {
	Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteUpdateStatementArgs() *TSIServiceExecuteUpdateStatementArgs {
	return &TSIServiceExecuteUpdateStatementArgs{}
}

var TSIServiceExecuteUpdateStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *TSIServiceExecuteUpdateStatementArgs) GetReq() *TSExecuteStatementReq {
	if !p.IsSetReq() {
		return TSIServiceExecuteUpdateStatementArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceExecuteUpdateStatementArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceExecuteUpdateStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteUpdateStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSExecuteStatementReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceExecuteUpdateStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeUpdateStatement_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteUpdateStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceExecuteUpdateStatementArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteUpdateStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteUpdateStatementResult struct {
	Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteUpdateStatementResult() *TSIServiceExecuteUpdateStatementResult {
	return &TSIServiceExecuteUpdateStatementResult{}
}

var TSIServiceExecuteUpdateStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteUpdateStatementResult) GetSuccess() *TSExecuteStatementResp {
	if !p.IsSetSuccess() {
		return TSIServiceExecuteUpdateStatementResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceExecuteUpdateStatementResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceExecuteUpdateStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteUpdateStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSExecuteStatementResp{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceExecuteUpdateStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeUpdateStatement_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteUpdateStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceExecuteUpdateStatementResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteUpdateStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceFetchResultsArgs struct {
	Req *TSFetchResultsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceFetchResultsArgs() *TSIServiceFetchResultsArgs {
	return &TSIServiceFetchResultsArgs{}
}

var TSIServiceFetchResultsArgs_Req_DEFAULT *TSFetchResultsReq
func (p *TSIServiceFetchResultsArgs) GetReq() *TSFetchResultsReq {
	if !p.IsSetReq() {
		return TSIServiceFetchResultsArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceFetchResultsArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceFetchResultsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceFetchResultsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSFetchResultsReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceFetchResultsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "fetchResults_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceFetchResultsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceFetchResultsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceFetchResultsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceFetchResultsResult struct {
	Success *TSFetchResultsResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceFetchResultsResult() *TSIServiceFetchResultsResult {
	return &TSIServiceFetchResultsResult{}
}

var TSIServiceFetchResultsResult_Success_DEFAULT *TSFetchResultsResp
func (p *TSIServiceFetchResultsResult) GetSuccess() *TSFetchResultsResp {
	if !p.IsSetSuccess() {
		return TSIServiceFetchResultsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceFetchResultsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceFetchResultsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceFetchResultsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSFetchResultsResp{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceFetchResultsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "fetchResults_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceFetchResultsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceFetchResultsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceFetchResultsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceFetchMetadataArgs struct {
	Req *TSFetchMetadataReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceFetchMetadataArgs() *TSIServiceFetchMetadataArgs {
	return &TSIServiceFetchMetadataArgs{}
}

var TSIServiceFetchMetadataArgs_Req_DEFAULT *TSFetchMetadataReq
func (p *TSIServiceFetchMetadataArgs) GetReq() *TSFetchMetadataReq {
	if !p.IsSetReq() {
		return TSIServiceFetchMetadataArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceFetchMetadataArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceFetchMetadataArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceFetchMetadataArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSFetchMetadataReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceFetchMetadataArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "fetchMetadata_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceFetchMetadataArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceFetchMetadataArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceFetchMetadataArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceFetchMetadataResult struct {
	Success *TSFetchMetadataResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceFetchMetadataResult() *TSIServiceFetchMetadataResult {
	return &TSIServiceFetchMetadataResult{}
}

var TSIServiceFetchMetadataResult_Success_DEFAULT *TSFetchMetadataResp
func (p *TSIServiceFetchMetadataResult) GetSuccess() *TSFetchMetadataResp {
	if !p.IsSetSuccess() {
		return TSIServiceFetchMetadataResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceFetchMetadataResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceFetchMetadataResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceFetchMetadataResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSFetchMetadataResp{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceFetchMetadataResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "fetchMetadata_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceFetchMetadataResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceFetchMetadataResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceFetchMetadataResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCancelOperationArgs struct {
	Req *TSCancelOperationReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCancelOperationArgs() *TSIServiceCancelOperationArgs {
	return &TSIServiceCancelOperationArgs{}
}

var TSIServiceCancelOperationArgs_Req_DEFAULT *TSCancelOperationReq
func (p *TSIServiceCancelOperationArgs) GetReq() *TSCancelOperationReq {
	if !p.IsSetReq() {
		return TSIServiceCancelOperationArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceCancelOperationArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceCancelOperationArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCancelOperationArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSCancelOperationReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceCancelOperationArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "cancelOperation_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCancelOperationArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceCancelOperationArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCancelOperationArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCancelOperationResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCancelOperationResult() *TSIServiceCancelOperationResult {
	return &TSIServiceCancelOperationResult{}
}

var TSIServiceCancelOperationResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCancelOperationResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceCancelOperationResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceCancelOperationResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceCancelOperationResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCancelOperationResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceCancelOperationResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "cancelOperation_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCancelOperationResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceCancelOperationResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCancelOperationResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCloseOperationArgs struct {
	Req *TSCloseOperationReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCloseOperationArgs() *TSIServiceCloseOperationArgs {
	return &TSIServiceCloseOperationArgs{}
}

var TSIServiceCloseOperationArgs_Req_DEFAULT *TSCloseOperationReq
func (p *TSIServiceCloseOperationArgs) GetReq() *TSCloseOperationReq {
	if !p.IsSetReq() {
		return TSIServiceCloseOperationArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceCloseOperationArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceCloseOperationArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCloseOperationArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSCloseOperationReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceCloseOperationArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "closeOperation_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCloseOperationArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceCloseOperationArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCloseOperationArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCloseOperationResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCloseOperationResult() *TSIServiceCloseOperationResult {
	return &TSIServiceCloseOperationResult{}
}

var TSIServiceCloseOperationResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCloseOperationResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceCloseOperationResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceCloseOperationResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceCloseOperationResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCloseOperationResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceCloseOperationResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "closeOperation_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCloseOperationResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceCloseOperationResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCloseOperationResult(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSIServiceGetTimeZoneArgs struct {
	SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
}

func NewTSIServiceGetTimeZoneArgs() *TSIServiceGetTimeZoneArgs {
	return &TSIServiceGetTimeZoneArgs{}
}


func (p *TSIServiceGetTimeZoneArgs) GetSessionId() int64 {
	return p.SessionId
}
func (p *TSIServiceGetTimeZoneArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceGetTimeZoneArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSIServiceGetTimeZoneArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "getTimeZone_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceGetTimeZoneArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSIServiceGetTimeZoneArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceGetTimeZoneArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceGetTimeZoneResult struct {
	Success *TSGetTimeZoneResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceGetTimeZoneResult() *TSIServiceGetTimeZoneResult {
	return &TSIServiceGetTimeZoneResult{}
}

var TSIServiceGetTimeZoneResult_Success_DEFAULT *TSGetTimeZoneResp
func (p *TSIServiceGetTimeZoneResult) GetSuccess() *TSGetTimeZoneResp {
	if !p.IsSetSuccess() {
		return TSIServiceGetTimeZoneResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceGetTimeZoneResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceGetTimeZoneResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceGetTimeZoneResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSGetTimeZoneResp{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceGetTimeZoneResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "getTimeZone_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceGetTimeZoneResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceGetTimeZoneResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceGetTimeZoneResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceSetTimeZoneArgs struct {
	Req *TSSetTimeZoneReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceSetTimeZoneArgs() *TSIServiceSetTimeZoneArgs {
	return &TSIServiceSetTimeZoneArgs{}
}

var TSIServiceSetTimeZoneArgs_Req_DEFAULT *TSSetTimeZoneReq
func (p *TSIServiceSetTimeZoneArgs) GetReq() *TSSetTimeZoneReq {
	if !p.IsSetReq() {
		return TSIServiceSetTimeZoneArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceSetTimeZoneArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceSetTimeZoneArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceSetTimeZoneArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSSetTimeZoneReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceSetTimeZoneArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "setTimeZone_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceSetTimeZoneArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceSetTimeZoneArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceSetTimeZoneArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceSetTimeZoneResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceSetTimeZoneResult() *TSIServiceSetTimeZoneResult {
	return &TSIServiceSetTimeZoneResult{}
}

var TSIServiceSetTimeZoneResult_Success_DEFAULT *TSStatus
func (p *TSIServiceSetTimeZoneResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceSetTimeZoneResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceSetTimeZoneResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceSetTimeZoneResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceSetTimeZoneResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceSetTimeZoneResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "setTimeZone_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceSetTimeZoneResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceSetTimeZoneResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceSetTimeZoneResult(%+v)", *p)
}

type TSIServiceGetPropertiesArgs struct {
}

func NewTSIServiceGetPropertiesArgs() *TSIServiceGetPropertiesArgs {
	return &TSIServiceGetPropertiesArgs{}
}

func (p *TSIServiceGetPropertiesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceGetPropertiesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "getProperties_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceGetPropertiesArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceGetPropertiesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceGetPropertiesResult struct {
	Success *ServerProperties `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceGetPropertiesResult() *TSIServiceGetPropertiesResult {
	return &TSIServiceGetPropertiesResult{}
}

var TSIServiceGetPropertiesResult_Success_DEFAULT *ServerProperties
func (p *TSIServiceGetPropertiesResult) GetSuccess() *ServerProperties {
	if !p.IsSetSuccess() {
		return TSIServiceGetPropertiesResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceGetPropertiesResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceGetPropertiesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceGetPropertiesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &ServerProperties{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceGetPropertiesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "getProperties_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceGetPropertiesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceGetPropertiesResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceGetPropertiesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - StorageGroup
type TSIServiceSetStorageGroupArgs struct {
	SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
	StorageGroup string `thrift:"storageGroup,2" db:"storageGroup" json:"storageGroup"`
}

func NewTSIServiceSetStorageGroupArgs() *TSIServiceSetStorageGroupArgs {
	return &TSIServiceSetStorageGroupArgs{}
}


func (p *TSIServiceSetStorageGroupArgs) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSIServiceSetStorageGroupArgs) GetStorageGroup() string {
	return p.StorageGroup
}
func (p *TSIServiceSetStorageGroupArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceSetStorageGroupArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSIServiceSetStorageGroupArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.StorageGroup = v
	}
	return nil
}

func (p *TSIServiceSetStorageGroupArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "setStorageGroup_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceSetStorageGroupArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSIServiceSetStorageGroupArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "storageGroup", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:storageGroup: ", p), err) }
	if err := oprot.WriteString(ctx, string(p.StorageGroup)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.storageGroup (2) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:storageGroup: ", p), err) }
	return err
}

func (p *TSIServiceSetStorageGroupArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceSetStorageGroupArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceSetStorageGroupResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceSetStorageGroupResult() *TSIServiceSetStorageGroupResult {
	return &TSIServiceSetStorageGroupResult{}
}

var TSIServiceSetStorageGroupResult_Success_DEFAULT *TSStatus
func (p *TSIServiceSetStorageGroupResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceSetStorageGroupResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceSetStorageGroupResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceSetStorageGroupResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceSetStorageGroupResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceSetStorageGroupResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "setStorageGroup_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceSetStorageGroupResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceSetStorageGroupResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceSetStorageGroupResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCreateTimeseriesArgs struct {
	Req *TSCreateTimeseriesReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCreateTimeseriesArgs() *TSIServiceCreateTimeseriesArgs {
	return &TSIServiceCreateTimeseriesArgs{}
}

var TSIServiceCreateTimeseriesArgs_Req_DEFAULT *TSCreateTimeseriesReq
func (p *TSIServiceCreateTimeseriesArgs) GetReq() *TSCreateTimeseriesReq {
	if !p.IsSetReq() {
		return TSIServiceCreateTimeseriesArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceCreateTimeseriesArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceCreateTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCreateTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSCreateTimeseriesReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceCreateTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "createTimeseries_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCreateTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceCreateTimeseriesArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCreateTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCreateTimeseriesResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCreateTimeseriesResult() *TSIServiceCreateTimeseriesResult {
	return &TSIServiceCreateTimeseriesResult{}
}

var TSIServiceCreateTimeseriesResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCreateTimeseriesResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceCreateTimeseriesResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceCreateTimeseriesResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceCreateTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCreateTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceCreateTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "createTimeseries_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCreateTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceCreateTimeseriesResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCreateTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCreateMultiTimeseriesArgs struct {
	Req *TSCreateMultiTimeseriesReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCreateMultiTimeseriesArgs() *TSIServiceCreateMultiTimeseriesArgs {
	return &TSIServiceCreateMultiTimeseriesArgs{}
}

var TSIServiceCreateMultiTimeseriesArgs_Req_DEFAULT *TSCreateMultiTimeseriesReq
func (p *TSIServiceCreateMultiTimeseriesArgs) GetReq() *TSCreateMultiTimeseriesReq {
	if !p.IsSetReq() {
		return TSIServiceCreateMultiTimeseriesArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceCreateMultiTimeseriesArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceCreateMultiTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCreateMultiTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSCreateMultiTimeseriesReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceCreateMultiTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "createMultiTimeseries_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCreateMultiTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceCreateMultiTimeseriesArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCreateMultiTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCreateMultiTimeseriesResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCreateMultiTimeseriesResult() *TSIServiceCreateMultiTimeseriesResult {
	return &TSIServiceCreateMultiTimeseriesResult{}
}

var TSIServiceCreateMultiTimeseriesResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCreateMultiTimeseriesResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceCreateMultiTimeseriesResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceCreateMultiTimeseriesResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceCreateMultiTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceCreateMultiTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceCreateMultiTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "createMultiTimeseries_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceCreateMultiTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceCreateMultiTimeseriesResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceCreateMultiTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Path
type TSIServiceDeleteTimeseriesArgs struct {
	SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
	Path []string `thrift:"path,2" db:"path" json:"path"`
}

func NewTSIServiceDeleteTimeseriesArgs() *TSIServiceDeleteTimeseriesArgs {
	return &TSIServiceDeleteTimeseriesArgs{}
}


func (p *TSIServiceDeleteTimeseriesArgs) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSIServiceDeleteTimeseriesArgs) GetPath() []string {
	return p.Path
}
func (p *TSIServiceDeleteTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceDeleteTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSIServiceDeleteTimeseriesArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.Path =  tSlice
	for i := 0; i < size; i ++ {
		var _elem230 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem230 = v
		}
		p.Path = append(p.Path, _elem230)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSIServiceDeleteTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "deleteTimeseries_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceDeleteTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSIServiceDeleteTimeseriesArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "path", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Path)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Path {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
	return err
}

func (p *TSIServiceDeleteTimeseriesArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceDeleteTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceDeleteTimeseriesResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceDeleteTimeseriesResult() *TSIServiceDeleteTimeseriesResult {
	return &TSIServiceDeleteTimeseriesResult{}
}

var TSIServiceDeleteTimeseriesResult_Success_DEFAULT *TSStatus
func (p *TSIServiceDeleteTimeseriesResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceDeleteTimeseriesResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceDeleteTimeseriesResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceDeleteTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceDeleteTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceDeleteTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "deleteTimeseries_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceDeleteTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceDeleteTimeseriesResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceDeleteTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - StorageGroup
type TSIServiceDeleteStorageGroupsArgs struct {
	SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
	StorageGroup []string `thrift:"storageGroup,2" db:"storageGroup" json:"storageGroup"`
}

func NewTSIServiceDeleteStorageGroupsArgs() *TSIServiceDeleteStorageGroupsArgs {
	return &TSIServiceDeleteStorageGroupsArgs{}
}


func (p *TSIServiceDeleteStorageGroupsArgs) GetSessionId() int64 {
	return p.SessionId
}

func (p *TSIServiceDeleteStorageGroupsArgs) GetStorageGroup() []string {
	return p.StorageGroup
}
func (p *TSIServiceDeleteStorageGroupsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceDeleteStorageGroupsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSIServiceDeleteStorageGroupsArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.StorageGroup =  tSlice
	for i := 0; i < size; i ++ {
		var _elem231 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem231 = v
		}
		p.StorageGroup = append(p.StorageGroup, _elem231)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *TSIServiceDeleteStorageGroupsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "deleteStorageGroups_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
		if err := p.writeField2(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceDeleteStorageGroupsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSIServiceDeleteStorageGroupsArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "storageGroup", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:storageGroup: ", p), err) }
	if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.StorageGroup)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.StorageGroup {
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:storageGroup: ", p), err) }
	return err
}

func (p *TSIServiceDeleteStorageGroupsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceDeleteStorageGroupsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceDeleteStorageGroupsResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceDeleteStorageGroupsResult() *TSIServiceDeleteStorageGroupsResult {
	return &TSIServiceDeleteStorageGroupsResult{}
}

var TSIServiceDeleteStorageGroupsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceDeleteStorageGroupsResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceDeleteStorageGroupsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceDeleteStorageGroupsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceDeleteStorageGroupsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceDeleteStorageGroupsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceDeleteStorageGroupsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "deleteStorageGroups_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceDeleteStorageGroupsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceDeleteStorageGroupsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceDeleteStorageGroupsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertRecordArgs struct {
	Req *TSInsertRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertRecordArgs() *TSIServiceInsertRecordArgs {
	return &TSIServiceInsertRecordArgs{}
}

var TSIServiceInsertRecordArgs_Req_DEFAULT *TSInsertRecordReq
func (p *TSIServiceInsertRecordArgs) GetReq() *TSInsertRecordReq {
	if !p.IsSetReq() {
		return TSIServiceInsertRecordArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceInsertRecordArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceInsertRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertRecordReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertRecord_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceInsertRecordArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertRecordResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertRecordResult() *TSIServiceInsertRecordResult {
	return &TSIServiceInsertRecordResult{}
}

var TSIServiceInsertRecordResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertRecordResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceInsertRecordResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceInsertRecordResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceInsertRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertRecord_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceInsertRecordResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertStringRecordArgs struct {
	Req *TSInsertStringRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertStringRecordArgs() *TSIServiceInsertStringRecordArgs {
	return &TSIServiceInsertStringRecordArgs{}
}

var TSIServiceInsertStringRecordArgs_Req_DEFAULT *TSInsertStringRecordReq
func (p *TSIServiceInsertStringRecordArgs) GetReq() *TSInsertStringRecordReq {
	if !p.IsSetReq() {
		return TSIServiceInsertStringRecordArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceInsertStringRecordArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceInsertStringRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertStringRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertStringRecordReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceInsertStringRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertStringRecord_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertStringRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceInsertStringRecordArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertStringRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertStringRecordResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertStringRecordResult() *TSIServiceInsertStringRecordResult {
	return &TSIServiceInsertStringRecordResult{}
}

var TSIServiceInsertStringRecordResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertStringRecordResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceInsertStringRecordResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceInsertStringRecordResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceInsertStringRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertStringRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceInsertStringRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertStringRecord_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertStringRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceInsertStringRecordResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertStringRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertTabletArgs struct {
	Req *TSInsertTabletReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertTabletArgs() *TSIServiceInsertTabletArgs {
	return &TSIServiceInsertTabletArgs{}
}

var TSIServiceInsertTabletArgs_Req_DEFAULT *TSInsertTabletReq
func (p *TSIServiceInsertTabletArgs) GetReq() *TSInsertTabletReq {
	if !p.IsSetReq() {
		return TSIServiceInsertTabletArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceInsertTabletArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceInsertTabletArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertTabletArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertTabletReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceInsertTabletArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertTablet_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertTabletArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceInsertTabletArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertTabletArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertTabletResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertTabletResult() *TSIServiceInsertTabletResult {
	return &TSIServiceInsertTabletResult{}
}

var TSIServiceInsertTabletResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertTabletResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceInsertTabletResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceInsertTabletResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceInsertTabletResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertTabletResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceInsertTabletResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertTablet_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertTabletResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceInsertTabletResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertTabletResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertTabletsArgs struct {
	Req *TSInsertTabletsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertTabletsArgs() *TSIServiceInsertTabletsArgs {
	return &TSIServiceInsertTabletsArgs{}
}

var TSIServiceInsertTabletsArgs_Req_DEFAULT *TSInsertTabletsReq
func (p *TSIServiceInsertTabletsArgs) GetReq() *TSInsertTabletsReq {
	if !p.IsSetReq() {
		return TSIServiceInsertTabletsArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceInsertTabletsArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceInsertTabletsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertTabletsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertTabletsReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceInsertTabletsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertTablets_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertTabletsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceInsertTabletsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertTabletsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertTabletsResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertTabletsResult() *TSIServiceInsertTabletsResult {
	return &TSIServiceInsertTabletsResult{}
}

var TSIServiceInsertTabletsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertTabletsResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceInsertTabletsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceInsertTabletsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceInsertTabletsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertTabletsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceInsertTabletsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertTablets_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertTabletsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceInsertTabletsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertTabletsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertRecordsArgs struct {
	Req *TSInsertRecordsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertRecordsArgs() *TSIServiceInsertRecordsArgs {
	return &TSIServiceInsertRecordsArgs{}
}

var TSIServiceInsertRecordsArgs_Req_DEFAULT *TSInsertRecordsReq
func (p *TSIServiceInsertRecordsArgs) GetReq() *TSInsertRecordsReq {
	if !p.IsSetReq() {
		return TSIServiceInsertRecordsArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceInsertRecordsArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceInsertRecordsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertRecordsReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertRecords_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertRecordsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceInsertRecordsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertRecordsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertRecordsResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertRecordsResult() *TSIServiceInsertRecordsResult {
	return &TSIServiceInsertRecordsResult{}
}

var TSIServiceInsertRecordsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertRecordsResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceInsertRecordsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceInsertRecordsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceInsertRecordsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertRecords_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertRecordsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceInsertRecordsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertRecordsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertRecordsOfOneDeviceArgs struct {
	Req *TSInsertRecordsOfOneDeviceReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertRecordsOfOneDeviceArgs() *TSIServiceInsertRecordsOfOneDeviceArgs {
	return &TSIServiceInsertRecordsOfOneDeviceArgs{}
}

var TSIServiceInsertRecordsOfOneDeviceArgs_Req_DEFAULT *TSInsertRecordsOfOneDeviceReq
func (p *TSIServiceInsertRecordsOfOneDeviceArgs) GetReq() *TSInsertRecordsOfOneDeviceReq {
	if !p.IsSetReq() {
		return TSIServiceInsertRecordsOfOneDeviceArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceInsertRecordsOfOneDeviceArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertRecordsOfOneDeviceReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertRecordsOfOneDevice_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertRecordsOfOneDeviceArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertRecordsOfOneDeviceResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertRecordsOfOneDeviceResult() *TSIServiceInsertRecordsOfOneDeviceResult {
	return &TSIServiceInsertRecordsOfOneDeviceResult{}
}

var TSIServiceInsertRecordsOfOneDeviceResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertRecordsOfOneDeviceResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceInsertRecordsOfOneDeviceResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceInsertRecordsOfOneDeviceResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertRecordsOfOneDevice_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertRecordsOfOneDeviceResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertStringRecordsArgs struct {
	Req *TSInsertStringRecordsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertStringRecordsArgs() *TSIServiceInsertStringRecordsArgs {
	return &TSIServiceInsertStringRecordsArgs{}
}

var TSIServiceInsertStringRecordsArgs_Req_DEFAULT *TSInsertStringRecordsReq
func (p *TSIServiceInsertStringRecordsArgs) GetReq() *TSInsertStringRecordsReq {
	if !p.IsSetReq() {
		return TSIServiceInsertStringRecordsArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceInsertStringRecordsArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceInsertStringRecordsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertStringRecordsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertStringRecordsReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceInsertStringRecordsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertStringRecords_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertStringRecordsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceInsertStringRecordsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertStringRecordsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertStringRecordsResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertStringRecordsResult() *TSIServiceInsertStringRecordsResult {
	return &TSIServiceInsertStringRecordsResult{}
}

var TSIServiceInsertStringRecordsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertStringRecordsResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceInsertStringRecordsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceInsertStringRecordsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceInsertStringRecordsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceInsertStringRecordsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceInsertStringRecordsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "insertStringRecords_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceInsertStringRecordsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceInsertStringRecordsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceInsertStringRecordsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertTabletArgs struct {
	Req *TSInsertTabletReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertTabletArgs() *TSIServiceTestInsertTabletArgs {
	return &TSIServiceTestInsertTabletArgs{}
}

var TSIServiceTestInsertTabletArgs_Req_DEFAULT *TSInsertTabletReq
func (p *TSIServiceTestInsertTabletArgs) GetReq() *TSInsertTabletReq {
	if !p.IsSetReq() {
		return TSIServiceTestInsertTabletArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceTestInsertTabletArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceTestInsertTabletArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertTabletArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertTabletReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceTestInsertTabletArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertTablet_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertTabletArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceTestInsertTabletArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertTabletArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertTabletResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertTabletResult() *TSIServiceTestInsertTabletResult {
	return &TSIServiceTestInsertTabletResult{}
}

var TSIServiceTestInsertTabletResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertTabletResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceTestInsertTabletResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceTestInsertTabletResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceTestInsertTabletResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertTabletResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceTestInsertTabletResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertTablet_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertTabletResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceTestInsertTabletResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertTabletResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertTabletsArgs struct {
	Req *TSInsertTabletsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertTabletsArgs() *TSIServiceTestInsertTabletsArgs {
	return &TSIServiceTestInsertTabletsArgs{}
}

var TSIServiceTestInsertTabletsArgs_Req_DEFAULT *TSInsertTabletsReq
func (p *TSIServiceTestInsertTabletsArgs) GetReq() *TSInsertTabletsReq {
	if !p.IsSetReq() {
		return TSIServiceTestInsertTabletsArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceTestInsertTabletsArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceTestInsertTabletsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertTabletsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertTabletsReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceTestInsertTabletsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertTablets_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertTabletsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceTestInsertTabletsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertTabletsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertTabletsResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertTabletsResult() *TSIServiceTestInsertTabletsResult {
	return &TSIServiceTestInsertTabletsResult{}
}

var TSIServiceTestInsertTabletsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertTabletsResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceTestInsertTabletsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceTestInsertTabletsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceTestInsertTabletsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertTabletsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceTestInsertTabletsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertTablets_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertTabletsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceTestInsertTabletsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertTabletsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertRecordArgs struct {
	Req *TSInsertRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertRecordArgs() *TSIServiceTestInsertRecordArgs {
	return &TSIServiceTestInsertRecordArgs{}
}

var TSIServiceTestInsertRecordArgs_Req_DEFAULT *TSInsertRecordReq
func (p *TSIServiceTestInsertRecordArgs) GetReq() *TSInsertRecordReq {
	if !p.IsSetReq() {
		return TSIServiceTestInsertRecordArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceTestInsertRecordArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceTestInsertRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertRecordReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertRecord_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceTestInsertRecordArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertRecordResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertRecordResult() *TSIServiceTestInsertRecordResult {
	return &TSIServiceTestInsertRecordResult{}
}

var TSIServiceTestInsertRecordResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertRecordResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceTestInsertRecordResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceTestInsertRecordResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceTestInsertRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertRecord_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceTestInsertRecordResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertStringRecordArgs struct {
	Req *TSInsertStringRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertStringRecordArgs() *TSIServiceTestInsertStringRecordArgs {
	return &TSIServiceTestInsertStringRecordArgs{}
}

var TSIServiceTestInsertStringRecordArgs_Req_DEFAULT *TSInsertStringRecordReq
func (p *TSIServiceTestInsertStringRecordArgs) GetReq() *TSInsertStringRecordReq {
	if !p.IsSetReq() {
		return TSIServiceTestInsertStringRecordArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceTestInsertStringRecordArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceTestInsertStringRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertStringRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertStringRecordReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceTestInsertStringRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertStringRecord_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertStringRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceTestInsertStringRecordArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertStringRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertStringRecordResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertStringRecordResult() *TSIServiceTestInsertStringRecordResult {
	return &TSIServiceTestInsertStringRecordResult{}
}

var TSIServiceTestInsertStringRecordResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertStringRecordResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceTestInsertStringRecordResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceTestInsertStringRecordResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceTestInsertStringRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertStringRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceTestInsertStringRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertStringRecord_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertStringRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceTestInsertStringRecordResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertStringRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertRecordsArgs struct {
	Req *TSInsertRecordsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertRecordsArgs() *TSIServiceTestInsertRecordsArgs {
	return &TSIServiceTestInsertRecordsArgs{}
}

var TSIServiceTestInsertRecordsArgs_Req_DEFAULT *TSInsertRecordsReq
func (p *TSIServiceTestInsertRecordsArgs) GetReq() *TSInsertRecordsReq {
	if !p.IsSetReq() {
		return TSIServiceTestInsertRecordsArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceTestInsertRecordsArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceTestInsertRecordsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertRecordsReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertRecords_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertRecordsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceTestInsertRecordsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertRecordsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertRecordsResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertRecordsResult() *TSIServiceTestInsertRecordsResult {
	return &TSIServiceTestInsertRecordsResult{}
}

var TSIServiceTestInsertRecordsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertRecordsResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceTestInsertRecordsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceTestInsertRecordsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceTestInsertRecordsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertRecords_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertRecordsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceTestInsertRecordsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertRecordsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertRecordsOfOneDeviceArgs struct {
	Req *TSInsertRecordsOfOneDeviceReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertRecordsOfOneDeviceArgs() *TSIServiceTestInsertRecordsOfOneDeviceArgs {
	return &TSIServiceTestInsertRecordsOfOneDeviceArgs{}
}

var TSIServiceTestInsertRecordsOfOneDeviceArgs_Req_DEFAULT *TSInsertRecordsOfOneDeviceReq
func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) GetReq() *TSInsertRecordsOfOneDeviceReq {
	if !p.IsSetReq() {
		return TSIServiceTestInsertRecordsOfOneDeviceArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertRecordsOfOneDeviceReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertRecordsOfOneDevice_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertRecordsOfOneDeviceArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertRecordsOfOneDeviceResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertRecordsOfOneDeviceResult() *TSIServiceTestInsertRecordsOfOneDeviceResult {
	return &TSIServiceTestInsertRecordsOfOneDeviceResult{}
}

var TSIServiceTestInsertRecordsOfOneDeviceResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceTestInsertRecordsOfOneDeviceResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertRecordsOfOneDevice_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertRecordsOfOneDeviceResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertStringRecordsArgs struct {
	Req *TSInsertStringRecordsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertStringRecordsArgs() *TSIServiceTestInsertStringRecordsArgs {
	return &TSIServiceTestInsertStringRecordsArgs{}
}

var TSIServiceTestInsertStringRecordsArgs_Req_DEFAULT *TSInsertStringRecordsReq
func (p *TSIServiceTestInsertStringRecordsArgs) GetReq() *TSInsertStringRecordsReq {
	if !p.IsSetReq() {
		return TSIServiceTestInsertStringRecordsArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceTestInsertStringRecordsArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceTestInsertStringRecordsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertStringRecordsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSInsertStringRecordsReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceTestInsertStringRecordsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertStringRecords_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertStringRecordsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceTestInsertStringRecordsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertStringRecordsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertStringRecordsResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertStringRecordsResult() *TSIServiceTestInsertStringRecordsResult {
	return &TSIServiceTestInsertStringRecordsResult{}
}

var TSIServiceTestInsertStringRecordsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertStringRecordsResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceTestInsertStringRecordsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceTestInsertStringRecordsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceTestInsertStringRecordsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceTestInsertStringRecordsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceTestInsertStringRecordsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "testInsertStringRecords_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceTestInsertStringRecordsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceTestInsertStringRecordsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceTestInsertStringRecordsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceDeleteDataArgs struct {
	Req *TSDeleteDataReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceDeleteDataArgs() *TSIServiceDeleteDataArgs {
	return &TSIServiceDeleteDataArgs{}
}

var TSIServiceDeleteDataArgs_Req_DEFAULT *TSDeleteDataReq
func (p *TSIServiceDeleteDataArgs) GetReq() *TSDeleteDataReq {
	if !p.IsSetReq() {
		return TSIServiceDeleteDataArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceDeleteDataArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceDeleteDataArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceDeleteDataArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSDeleteDataReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceDeleteDataArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "deleteData_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceDeleteDataArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceDeleteDataArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceDeleteDataArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceDeleteDataResult struct {
	Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceDeleteDataResult() *TSIServiceDeleteDataResult {
	return &TSIServiceDeleteDataResult{}
}

var TSIServiceDeleteDataResult_Success_DEFAULT *TSStatus
func (p *TSIServiceDeleteDataResult) GetSuccess() *TSStatus {
	if !p.IsSetSuccess() {
		return TSIServiceDeleteDataResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceDeleteDataResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceDeleteDataResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceDeleteDataResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceDeleteDataResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "deleteData_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceDeleteDataResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceDeleteDataResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceDeleteDataResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteRawDataQueryArgs struct {
	Req *TSRawDataQueryReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteRawDataQueryArgs() *TSIServiceExecuteRawDataQueryArgs {
	return &TSIServiceExecuteRawDataQueryArgs{}
}

var TSIServiceExecuteRawDataQueryArgs_Req_DEFAULT *TSRawDataQueryReq
func (p *TSIServiceExecuteRawDataQueryArgs) GetReq() *TSRawDataQueryReq {
	if !p.IsSetReq() {
		return TSIServiceExecuteRawDataQueryArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *TSIServiceExecuteRawDataQueryArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *TSIServiceExecuteRawDataQueryArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteRawDataQueryArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Req = &TSRawDataQueryReq{}
	if err := p.Req.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *TSIServiceExecuteRawDataQueryArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeRawDataQuery_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteRawDataQueryArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
	if err := p.Req.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
	return err
}

func (p *TSIServiceExecuteRawDataQueryArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteRawDataQueryArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteRawDataQueryResult struct {
	Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteRawDataQueryResult() *TSIServiceExecuteRawDataQueryResult {
	return &TSIServiceExecuteRawDataQueryResult{}
}

var TSIServiceExecuteRawDataQueryResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteRawDataQueryResult) GetSuccess() *TSExecuteStatementResp {
	if !p.IsSetSuccess() {
		return TSIServiceExecuteRawDataQueryResult_Success_DEFAULT
	}
	return p.Success
}
func (p *TSIServiceExecuteRawDataQueryResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceExecuteRawDataQueryResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceExecuteRawDataQueryResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &TSExecuteStatementResp{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *TSIServiceExecuteRawDataQueryResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "executeRawDataQuery_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceExecuteRawDataQueryResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceExecuteRawDataQueryResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceExecuteRawDataQueryResult(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSIServiceRequestStatementIdArgs struct {
	SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
}

func NewTSIServiceRequestStatementIdArgs() *TSIServiceRequestStatementIdArgs {
	return &TSIServiceRequestStatementIdArgs{}
}


func (p *TSIServiceRequestStatementIdArgs) GetSessionId() int64 {
	return p.SessionId
}
func (p *TSIServiceRequestStatementIdArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceRequestStatementIdArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.SessionId = v
	}
	return nil
}

func (p *TSIServiceRequestStatementIdArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "requestStatementId_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceRequestStatementIdArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
	if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
	return err
}

func (p *TSIServiceRequestStatementIdArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceRequestStatementIdArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceRequestStatementIdResult struct {
	Success *int64 `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceRequestStatementIdResult() *TSIServiceRequestStatementIdResult {
	return &TSIServiceRequestStatementIdResult{}
}

var TSIServiceRequestStatementIdResult_Success_DEFAULT int64
func (p *TSIServiceRequestStatementIdResult) GetSuccess() int64 {
	if !p.IsSetSuccess() {
		return TSIServiceRequestStatementIdResult_Success_DEFAULT
	}
	return *p.Success
}
func (p *TSIServiceRequestStatementIdResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *TSIServiceRequestStatementIdResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}


	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP { break; }
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *TSIServiceRequestStatementIdResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 0: ", err)
	} else {
		p.Success = &v
	}
	return nil
}

func (p *TSIServiceRequestStatementIdResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "requestStatementId_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil { return err }
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err) }
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err) }
	return nil
}

func (p *TSIServiceRequestStatementIdResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
		if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
	}
	return err
}

func (p *TSIServiceRequestStatementIdResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TSIServiceRequestStatementIdResult(%+v)", *p)
}


