//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// EventCategoriesClient contains the methods for the EventCategories group.
// Don't use this type directly, use NewEventCategoriesClient() instead.
type EventCategoriesClient struct {
	host string
	pl   runtime.Pipeline
}

// NewEventCategoriesClient creates a new instance of EventCategoriesClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewEventCategoriesClient(credential azcore.TokenCredential, options *arm.ClientOptions) *EventCategoriesClient {
	cp := arm.ClientOptions{}
	if options != nil {
		cp = *options
	}
	if len(cp.Endpoint) == 0 {
		cp.Endpoint = arm.AzurePublicCloud
	}
	client := &EventCategoriesClient{
		host: string(cp.Endpoint),
		pl:   armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, &cp),
	}
	return client
}

// List - Get the list of available event categories supported in the Activity Logs Service. The current list includes the
// following: Administrative, Security, ServiceHealth, Alert, Recommendation, Policy.
// If the operation fails it returns an *azcore.ResponseError type.
// options - EventCategoriesClientListOptions contains the optional parameters for the EventCategoriesClient.List method.
func (client *EventCategoriesClient) List(ctx context.Context, options *EventCategoriesClientListOptions) (EventCategoriesClientListResponse, error) {
	req, err := client.listCreateRequest(ctx, options)
	if err != nil {
		return EventCategoriesClientListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EventCategoriesClientListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EventCategoriesClientListResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHandleResponse(resp)
}

// listCreateRequest creates the List request.
func (client *EventCategoriesClient) listCreateRequest(ctx context.Context, options *EventCategoriesClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Insights/eventcategories"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2015-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listHandleResponse handles the List response.
func (client *EventCategoriesClient) listHandleResponse(resp *http.Response) (EventCategoriesClientListResponse, error) {
	result := EventCategoriesClientListResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventCategoryCollection); err != nil {
		return EventCategoriesClientListResponse{}, err
	}
	return result, nil
}
