//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
)

// x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/listMetricAlert.json
func ExampleMetricAlertsClient_ListBySubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armmonitor.NewMetricAlertsClient("<subscription-id>", cred, nil)
	res, err := client.ListBySubscription(ctx,
		nil)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.MetricAlertsClientListBySubscriptionResult)
}

// x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/listMetricAlert.json
func ExampleMetricAlertsClient_ListByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armmonitor.NewMetricAlertsClient("<subscription-id>", cred, nil)
	res, err := client.ListByResourceGroup(ctx,
		"<resource-group-name>",
		nil)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.MetricAlertsClientListByResourceGroupResult)
}

// x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getDynamicMetricAlertMultipleResource.json
func ExampleMetricAlertsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armmonitor.NewMetricAlertsClient("<subscription-id>", cred, nil)
	res, err := client.Get(ctx,
		"<resource-group-name>",
		"<rule-name>",
		nil)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.MetricAlertsClientGetResult)
}

// x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateDynamicMetricAlertMultipleResource.json
func ExampleMetricAlertsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armmonitor.NewMetricAlertsClient("<subscription-id>", cred, nil)
	res, err := client.CreateOrUpdate(ctx,
		"<resource-group-name>",
		"<rule-name>",
		armmonitor.MetricAlertResource{
			Location: to.StringPtr("<location>"),
			Tags:     map[string]*string{},
			Properties: &armmonitor.MetricAlertProperties{
				Description: to.StringPtr("<description>"),
				Actions: []*armmonitor.MetricAlertAction{
					{
						ActionGroupID: to.StringPtr("<action-group-id>"),
						WebHookProperties: map[string]*string{
							"key11": to.StringPtr("value11"),
							"key12": to.StringPtr("value12"),
						},
					}},
				AutoMitigate: to.BoolPtr(true),
				Criteria: &armmonitor.MetricAlertMultipleResourceMultipleMetricCriteria{
					ODataType: armmonitor.Odatatype("Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria").ToPtr(),
					AllOf: []armmonitor.MultiMetricCriteriaClassification{
						&armmonitor.DynamicMetricCriteria{
							Name:             to.StringPtr("<name>"),
							CriterionType:    armmonitor.CriterionType("DynamicThresholdCriterion").ToPtr(),
							Dimensions:       []*armmonitor.MetricDimension{},
							MetricName:       to.StringPtr("<metric-name>"),
							MetricNamespace:  to.StringPtr("<metric-namespace>"),
							TimeAggregation:  armmonitor.AggregationTypeEnum("Average").ToPtr(),
							AlertSensitivity: armmonitor.DynamicThresholdSensitivity("Medium").ToPtr(),
							FailingPeriods: &armmonitor.DynamicThresholdFailingPeriods{
								MinFailingPeriodsToAlert:  to.Float32Ptr(4),
								NumberOfEvaluationPeriods: to.Float32Ptr(4),
							},
							Operator: armmonitor.DynamicThresholdOperator("GreaterOrLessThan").ToPtr(),
						}},
				},
				Enabled:             to.BoolPtr(true),
				EvaluationFrequency: to.StringPtr("<evaluation-frequency>"),
				Scopes: []*string{
					to.StringPtr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
					to.StringPtr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")},
				Severity:             to.Int32Ptr(3),
				TargetResourceRegion: to.StringPtr("<target-resource-region>"),
				TargetResourceType:   to.StringPtr("<target-resource-type>"),
				WindowSize:           to.StringPtr("<window-size>"),
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.MetricAlertsClientCreateOrUpdateResult)
}

// x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/UpdateMetricAlert.json
func ExampleMetricAlertsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armmonitor.NewMetricAlertsClient("<subscription-id>", cred, nil)
	res, err := client.Update(ctx,
		"<resource-group-name>",
		"<rule-name>",
		armmonitor.MetricAlertResourcePatch{
			Properties: &armmonitor.MetricAlertPropertiesPatch{
				Description: to.StringPtr("<description>"),
				Actions: []*armmonitor.MetricAlertAction{
					{
						ActionGroupID: to.StringPtr("<action-group-id>"),
						WebHookProperties: map[string]*string{
							"key11": to.StringPtr("value11"),
							"key12": to.StringPtr("value12"),
						},
					}},
				AutoMitigate: to.BoolPtr(true),
				Criteria: &armmonitor.MetricAlertSingleResourceMultipleMetricCriteria{
					ODataType: armmonitor.Odatatype("Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria").ToPtr(),
					AllOf: []*armmonitor.MetricCriteria{
						{
							Name:            to.StringPtr("<name>"),
							CriterionType:   armmonitor.CriterionType("StaticThresholdCriterion").ToPtr(),
							Dimensions:      []*armmonitor.MetricDimension{},
							MetricName:      to.StringPtr("<metric-name>"),
							TimeAggregation: armmonitor.AggregationTypeEnum("Average").ToPtr(),
							Operator:        armmonitor.Operator("GreaterThan").ToPtr(),
							Threshold:       to.Float64Ptr(80.5),
						}},
				},
				Enabled:             to.BoolPtr(true),
				EvaluationFrequency: to.StringPtr("<evaluation-frequency>"),
				Scopes: []*string{
					to.StringPtr("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")},
				Severity:   to.Int32Ptr(3),
				WindowSize: to.StringPtr("<window-size>"),
			},
			Tags: map[string]*string{},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.MetricAlertsClientUpdateResult)
}

// x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/deleteMetricAlert.json
func ExampleMetricAlertsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armmonitor.NewMetricAlertsClient("<subscription-id>", cred, nil)
	_, err = client.Delete(ctx,
		"<resource-group-name>",
		"<rule-name>",
		nil)
	if err != nil {
		log.Fatal(err)
	}
}
