package computeapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/compute/mgmt/2021-11-01/compute"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result compute.OperationListResult, err error)
}

var _ OperationsClientAPI = (*compute.OperationsClient)(nil)

// AvailabilitySetsClientAPI contains the set of methods on the AvailabilitySetsClient type.
type AvailabilitySetsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, availabilitySetName string, parameters compute.AvailabilitySet) (result compute.AvailabilitySet, err error)
	Delete(ctx context.Context, resourceGroupName string, availabilitySetName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, availabilitySetName string) (result compute.AvailabilitySet, err error)
	List(ctx context.Context, resourceGroupName string) (result compute.AvailabilitySetListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string) (result compute.AvailabilitySetListResultIterator, err error)
	ListAvailableSizes(ctx context.Context, resourceGroupName string, availabilitySetName string) (result compute.VirtualMachineSizeListResult, err error)
	ListBySubscription(ctx context.Context, expand string) (result compute.AvailabilitySetListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context, expand string) (result compute.AvailabilitySetListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, availabilitySetName string, parameters compute.AvailabilitySetUpdate) (result compute.AvailabilitySet, err error)
}

var _ AvailabilitySetsClientAPI = (*compute.AvailabilitySetsClient)(nil)

// ProximityPlacementGroupsClientAPI contains the set of methods on the ProximityPlacementGroupsClient type.
type ProximityPlacementGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, proximityPlacementGroupName string, parameters compute.ProximityPlacementGroup) (result compute.ProximityPlacementGroup, err error)
	Delete(ctx context.Context, resourceGroupName string, proximityPlacementGroupName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, proximityPlacementGroupName string, includeColocationStatus string) (result compute.ProximityPlacementGroup, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.ProximityPlacementGroupListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.ProximityPlacementGroupListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result compute.ProximityPlacementGroupListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result compute.ProximityPlacementGroupListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, proximityPlacementGroupName string, parameters compute.ProximityPlacementGroupUpdate) (result compute.ProximityPlacementGroup, err error)
}

var _ ProximityPlacementGroupsClientAPI = (*compute.ProximityPlacementGroupsClient)(nil)

// DedicatedHostGroupsClientAPI contains the set of methods on the DedicatedHostGroupsClient type.
type DedicatedHostGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, hostGroupName string, parameters compute.DedicatedHostGroup) (result compute.DedicatedHostGroup, err error)
	Delete(ctx context.Context, resourceGroupName string, hostGroupName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, hostGroupName string, expand compute.InstanceViewTypes) (result compute.DedicatedHostGroup, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.DedicatedHostGroupListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.DedicatedHostGroupListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result compute.DedicatedHostGroupListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result compute.DedicatedHostGroupListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, hostGroupName string, parameters compute.DedicatedHostGroupUpdate) (result compute.DedicatedHostGroup, err error)
}

var _ DedicatedHostGroupsClientAPI = (*compute.DedicatedHostGroupsClient)(nil)

// DedicatedHostsClientAPI contains the set of methods on the DedicatedHostsClient type.
type DedicatedHostsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, hostGroupName string, hostName string, parameters compute.DedicatedHost) (result compute.DedicatedHostsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, hostGroupName string, hostName string) (result compute.DedicatedHostsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, hostGroupName string, hostName string, expand compute.InstanceViewTypes) (result compute.DedicatedHost, err error)
	ListByHostGroup(ctx context.Context, resourceGroupName string, hostGroupName string) (result compute.DedicatedHostListResultPage, err error)
	ListByHostGroupComplete(ctx context.Context, resourceGroupName string, hostGroupName string) (result compute.DedicatedHostListResultIterator, err error)
	Restart(ctx context.Context, resourceGroupName string, hostGroupName string, hostName string) (result compute.DedicatedHostsRestartFuture, err error)
	Update(ctx context.Context, resourceGroupName string, hostGroupName string, hostName string, parameters compute.DedicatedHostUpdate) (result compute.DedicatedHostsUpdateFuture, err error)
}

var _ DedicatedHostsClientAPI = (*compute.DedicatedHostsClient)(nil)

// SSHPublicKeysClientAPI contains the set of methods on the SSHPublicKeysClient type.
type SSHPublicKeysClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, SSHPublicKeyName string, parameters compute.SSHPublicKeyResource) (result compute.SSHPublicKeyResource, err error)
	Delete(ctx context.Context, resourceGroupName string, SSHPublicKeyName string) (result autorest.Response, err error)
	GenerateKeyPair(ctx context.Context, resourceGroupName string, SSHPublicKeyName string) (result compute.SSHPublicKeyGenerateKeyPairResult, err error)
	Get(ctx context.Context, resourceGroupName string, SSHPublicKeyName string) (result compute.SSHPublicKeyResource, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.SSHPublicKeysGroupListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.SSHPublicKeysGroupListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result compute.SSHPublicKeysGroupListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result compute.SSHPublicKeysGroupListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, SSHPublicKeyName string, parameters compute.SSHPublicKeyUpdateResource) (result compute.SSHPublicKeyResource, err error)
}

var _ SSHPublicKeysClientAPI = (*compute.SSHPublicKeysClient)(nil)

// VirtualMachineExtensionImagesClientAPI contains the set of methods on the VirtualMachineExtensionImagesClient type.
type VirtualMachineExtensionImagesClientAPI interface {
	Get(ctx context.Context, location string, publisherName string, typeParameter string, version string) (result compute.VirtualMachineExtensionImage, err error)
	ListTypes(ctx context.Context, location string, publisherName string) (result compute.ListVirtualMachineExtensionImage, err error)
	ListVersions(ctx context.Context, location string, publisherName string, typeParameter string, filter string, top *int32, orderby string) (result compute.ListVirtualMachineExtensionImage, err error)
}

var _ VirtualMachineExtensionImagesClientAPI = (*compute.VirtualMachineExtensionImagesClient)(nil)

// VirtualMachineExtensionsClientAPI contains the set of methods on the VirtualMachineExtensionsClient type.
type VirtualMachineExtensionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, VMName string, VMExtensionName string, extensionParameters compute.VirtualMachineExtension) (result compute.VirtualMachineExtensionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, VMName string, VMExtensionName string) (result compute.VirtualMachineExtensionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, VMName string, VMExtensionName string, expand string) (result compute.VirtualMachineExtension, err error)
	List(ctx context.Context, resourceGroupName string, VMName string, expand string) (result compute.VirtualMachineExtensionsListResult, err error)
	Update(ctx context.Context, resourceGroupName string, VMName string, VMExtensionName string, extensionParameters compute.VirtualMachineExtensionUpdate) (result compute.VirtualMachineExtensionsUpdateFuture, err error)
}

var _ VirtualMachineExtensionsClientAPI = (*compute.VirtualMachineExtensionsClient)(nil)

// VirtualMachineImagesClientAPI contains the set of methods on the VirtualMachineImagesClient type.
type VirtualMachineImagesClientAPI interface {
	Get(ctx context.Context, location string, publisherName string, offer string, skus string, version string) (result compute.VirtualMachineImage, err error)
	List(ctx context.Context, location string, publisherName string, offer string, skus string, expand string, top *int32, orderby string) (result compute.ListVirtualMachineImageResource, err error)
	ListOffers(ctx context.Context, location string, publisherName string) (result compute.ListVirtualMachineImageResource, err error)
	ListPublishers(ctx context.Context, location string) (result compute.ListVirtualMachineImageResource, err error)
	ListSkus(ctx context.Context, location string, publisherName string, offer string) (result compute.ListVirtualMachineImageResource, err error)
}

var _ VirtualMachineImagesClientAPI = (*compute.VirtualMachineImagesClient)(nil)

// VirtualMachineImagesEdgeZoneClientAPI contains the set of methods on the VirtualMachineImagesEdgeZoneClient type.
type VirtualMachineImagesEdgeZoneClientAPI interface {
	Get(ctx context.Context, location string, edgeZone string, publisherName string, offer string, skus string, version string) (result compute.VirtualMachineImage, err error)
	List(ctx context.Context, location string, edgeZone string, publisherName string, offer string, skus string, expand string, top *int32, orderby string) (result compute.ListVirtualMachineImageResource, err error)
	ListOffers(ctx context.Context, location string, edgeZone string, publisherName string) (result compute.ListVirtualMachineImageResource, err error)
	ListPublishers(ctx context.Context, location string, edgeZone string) (result compute.ListVirtualMachineImageResource, err error)
	ListSkus(ctx context.Context, location string, edgeZone string, publisherName string, offer string) (result compute.ListVirtualMachineImageResource, err error)
}

var _ VirtualMachineImagesEdgeZoneClientAPI = (*compute.VirtualMachineImagesEdgeZoneClient)(nil)

// UsageClientAPI contains the set of methods on the UsageClient type.
type UsageClientAPI interface {
	List(ctx context.Context, location string) (result compute.ListUsagesResultPage, err error)
	ListComplete(ctx context.Context, location string) (result compute.ListUsagesResultIterator, err error)
}

var _ UsageClientAPI = (*compute.UsageClient)(nil)

// VirtualMachinesClientAPI contains the set of methods on the VirtualMachinesClient type.
type VirtualMachinesClientAPI interface {
	AssessPatches(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachinesAssessPatchesFuture, err error)
	Capture(ctx context.Context, resourceGroupName string, VMName string, parameters compute.VirtualMachineCaptureParameters) (result compute.VirtualMachinesCaptureFuture, err error)
	ConvertToManagedDisks(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachinesConvertToManagedDisksFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, VMName string, parameters compute.VirtualMachine) (result compute.VirtualMachinesCreateOrUpdateFuture, err error)
	Deallocate(ctx context.Context, resourceGroupName string, VMName string, hibernate *bool) (result compute.VirtualMachinesDeallocateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, VMName string, forceDeletion *bool) (result compute.VirtualMachinesDeleteFuture, err error)
	Generalize(ctx context.Context, resourceGroupName string, VMName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, VMName string, expand compute.InstanceViewTypes) (result compute.VirtualMachine, err error)
	InstallPatches(ctx context.Context, resourceGroupName string, VMName string, installPatchesInput compute.VirtualMachineInstallPatchesParameters) (result compute.VirtualMachinesInstallPatchesFuture, err error)
	InstanceView(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachineInstanceView, err error)
	List(ctx context.Context, resourceGroupName string, filter string) (result compute.VirtualMachineListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, filter string) (result compute.VirtualMachineListResultIterator, err error)
	ListAll(ctx context.Context, statusOnly string, filter string) (result compute.VirtualMachineListResultPage, err error)
	ListAllComplete(ctx context.Context, statusOnly string, filter string) (result compute.VirtualMachineListResultIterator, err error)
	ListAvailableSizes(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachineSizeListResult, err error)
	ListByLocation(ctx context.Context, location string) (result compute.VirtualMachineListResultPage, err error)
	ListByLocationComplete(ctx context.Context, location string) (result compute.VirtualMachineListResultIterator, err error)
	PerformMaintenance(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachinesPerformMaintenanceFuture, err error)
	PowerOff(ctx context.Context, resourceGroupName string, VMName string, skipShutdown *bool) (result compute.VirtualMachinesPowerOffFuture, err error)
	Reapply(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachinesReapplyFuture, err error)
	Redeploy(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachinesRedeployFuture, err error)
	Reimage(ctx context.Context, resourceGroupName string, VMName string, parameters *compute.VirtualMachineReimageParameters) (result compute.VirtualMachinesReimageFuture, err error)
	Restart(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachinesRestartFuture, err error)
	RetrieveBootDiagnosticsData(ctx context.Context, resourceGroupName string, VMName string, sasURIExpirationTimeInMinutes *int32) (result compute.RetrieveBootDiagnosticsDataResult, err error)
	RunCommand(ctx context.Context, resourceGroupName string, VMName string, parameters compute.RunCommandInput) (result compute.VirtualMachinesRunCommandFuture, err error)
	SimulateEviction(ctx context.Context, resourceGroupName string, VMName string) (result autorest.Response, err error)
	Start(ctx context.Context, resourceGroupName string, VMName string) (result compute.VirtualMachinesStartFuture, err error)
	Update(ctx context.Context, resourceGroupName string, VMName string, parameters compute.VirtualMachineUpdate) (result compute.VirtualMachinesUpdateFuture, err error)
}

var _ VirtualMachinesClientAPI = (*compute.VirtualMachinesClient)(nil)

// VirtualMachineScaleSetsClientAPI contains the set of methods on the VirtualMachineScaleSetsClient type.
type VirtualMachineScaleSetsClientAPI interface {
	ConvertToSinglePlacementGroup(ctx context.Context, resourceGroupName string, VMScaleSetName string, parameters compute.VMScaleSetConvertToSinglePlacementGroupInput) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, VMScaleSetName string, parameters compute.VirtualMachineScaleSet) (result compute.VirtualMachineScaleSetsCreateOrUpdateFuture, err error)
	Deallocate(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs *compute.VirtualMachineScaleSetVMInstanceIDs) (result compute.VirtualMachineScaleSetsDeallocateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, VMScaleSetName string, forceDeletion *bool) (result compute.VirtualMachineScaleSetsDeleteFuture, err error)
	DeleteInstances(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs compute.VirtualMachineScaleSetVMInstanceRequiredIDs, forceDeletion *bool) (result compute.VirtualMachineScaleSetsDeleteInstancesFuture, err error)
	ForceRecoveryServiceFabricPlatformUpdateDomainWalk(ctx context.Context, resourceGroupName string, VMScaleSetName string, platformUpdateDomain int32, zone string, placementGroupID string) (result compute.RecoveryWalkResponse, err error)
	Get(ctx context.Context, resourceGroupName string, VMScaleSetName string, expand compute.ExpandTypesForGetVMScaleSets) (result compute.VirtualMachineScaleSet, err error)
	GetInstanceView(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetInstanceView, err error)
	GetOSUpgradeHistory(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetListOSUpgradeHistoryPage, err error)
	GetOSUpgradeHistoryComplete(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetListOSUpgradeHistoryIterator, err error)
	List(ctx context.Context, resourceGroupName string) (result compute.VirtualMachineScaleSetListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string) (result compute.VirtualMachineScaleSetListResultIterator, err error)
	ListAll(ctx context.Context) (result compute.VirtualMachineScaleSetListWithLinkResultPage, err error)
	ListAllComplete(ctx context.Context) (result compute.VirtualMachineScaleSetListWithLinkResultIterator, err error)
	ListByLocation(ctx context.Context, location string) (result compute.VirtualMachineScaleSetListResultPage, err error)
	ListByLocationComplete(ctx context.Context, location string) (result compute.VirtualMachineScaleSetListResultIterator, err error)
	ListSkus(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetListSkusResultPage, err error)
	ListSkusComplete(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetListSkusResultIterator, err error)
	PerformMaintenance(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs *compute.VirtualMachineScaleSetVMInstanceIDs) (result compute.VirtualMachineScaleSetsPerformMaintenanceFuture, err error)
	PowerOff(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs *compute.VirtualMachineScaleSetVMInstanceIDs, skipShutdown *bool) (result compute.VirtualMachineScaleSetsPowerOffFuture, err error)
	Redeploy(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs *compute.VirtualMachineScaleSetVMInstanceIDs) (result compute.VirtualMachineScaleSetsRedeployFuture, err error)
	Reimage(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMScaleSetReimageInput *compute.VirtualMachineScaleSetReimageParameters) (result compute.VirtualMachineScaleSetsReimageFuture, err error)
	ReimageAll(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs *compute.VirtualMachineScaleSetVMInstanceIDs) (result compute.VirtualMachineScaleSetsReimageAllFuture, err error)
	Restart(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs *compute.VirtualMachineScaleSetVMInstanceIDs) (result compute.VirtualMachineScaleSetsRestartFuture, err error)
	SetOrchestrationServiceState(ctx context.Context, resourceGroupName string, VMScaleSetName string, parameters compute.OrchestrationServiceStateInput) (result compute.VirtualMachineScaleSetsSetOrchestrationServiceStateFuture, err error)
	Start(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs *compute.VirtualMachineScaleSetVMInstanceIDs) (result compute.VirtualMachineScaleSetsStartFuture, err error)
	Update(ctx context.Context, resourceGroupName string, VMScaleSetName string, parameters compute.VirtualMachineScaleSetUpdate) (result compute.VirtualMachineScaleSetsUpdateFuture, err error)
	UpdateInstances(ctx context.Context, resourceGroupName string, VMScaleSetName string, VMInstanceIDs compute.VirtualMachineScaleSetVMInstanceRequiredIDs) (result compute.VirtualMachineScaleSetsUpdateInstancesFuture, err error)
}

var _ VirtualMachineScaleSetsClientAPI = (*compute.VirtualMachineScaleSetsClient)(nil)

// VirtualMachineSizesClientAPI contains the set of methods on the VirtualMachineSizesClient type.
type VirtualMachineSizesClientAPI interface {
	List(ctx context.Context, location string) (result compute.VirtualMachineSizeListResult, err error)
}

var _ VirtualMachineSizesClientAPI = (*compute.VirtualMachineSizesClient)(nil)

// ImagesClientAPI contains the set of methods on the ImagesClient type.
type ImagesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, imageName string, parameters compute.Image) (result compute.ImagesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, imageName string) (result compute.ImagesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, imageName string, expand string) (result compute.Image, err error)
	List(ctx context.Context) (result compute.ImageListResultPage, err error)
	ListComplete(ctx context.Context) (result compute.ImageListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.ImageListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.ImageListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, imageName string, parameters compute.ImageUpdate) (result compute.ImagesUpdateFuture, err error)
}

var _ ImagesClientAPI = (*compute.ImagesClient)(nil)

// RestorePointCollectionsClientAPI contains the set of methods on the RestorePointCollectionsClient type.
type RestorePointCollectionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, restorePointCollectionName string, parameters compute.RestorePointCollection) (result compute.RestorePointCollection, err error)
	Delete(ctx context.Context, resourceGroupName string, restorePointCollectionName string) (result compute.RestorePointCollectionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, restorePointCollectionName string, expand compute.RestorePointCollectionExpandOptions) (result compute.RestorePointCollection, err error)
	List(ctx context.Context, resourceGroupName string) (result compute.RestorePointCollectionListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string) (result compute.RestorePointCollectionListResultIterator, err error)
	ListAll(ctx context.Context) (result compute.RestorePointCollectionListResultPage, err error)
	ListAllComplete(ctx context.Context) (result compute.RestorePointCollectionListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, restorePointCollectionName string, parameters compute.RestorePointCollectionUpdate) (result compute.RestorePointCollection, err error)
}

var _ RestorePointCollectionsClientAPI = (*compute.RestorePointCollectionsClient)(nil)

// RestorePointsClientAPI contains the set of methods on the RestorePointsClient type.
type RestorePointsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, restorePointCollectionName string, restorePointName string, parameters compute.RestorePoint) (result compute.RestorePointsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, restorePointCollectionName string, restorePointName string) (result compute.RestorePointsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, restorePointCollectionName string, restorePointName string, expand compute.RestorePointExpandOptions) (result compute.RestorePoint, err error)
}

var _ RestorePointsClientAPI = (*compute.RestorePointsClient)(nil)

// CapacityReservationGroupsClientAPI contains the set of methods on the CapacityReservationGroupsClient type.
type CapacityReservationGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, capacityReservationGroupName string, parameters compute.CapacityReservationGroup) (result compute.CapacityReservationGroup, err error)
	Delete(ctx context.Context, resourceGroupName string, capacityReservationGroupName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, capacityReservationGroupName string, expand compute.CapacityReservationGroupInstanceViewTypes) (result compute.CapacityReservationGroup, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, expand compute.ExpandTypesForGetCapacityReservationGroups) (result compute.CapacityReservationGroupListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, expand compute.ExpandTypesForGetCapacityReservationGroups) (result compute.CapacityReservationGroupListResultIterator, err error)
	ListBySubscription(ctx context.Context, expand compute.ExpandTypesForGetCapacityReservationGroups) (result compute.CapacityReservationGroupListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context, expand compute.ExpandTypesForGetCapacityReservationGroups) (result compute.CapacityReservationGroupListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, capacityReservationGroupName string, parameters compute.CapacityReservationGroupUpdate) (result compute.CapacityReservationGroup, err error)
}

var _ CapacityReservationGroupsClientAPI = (*compute.CapacityReservationGroupsClient)(nil)

// CapacityReservationsClientAPI contains the set of methods on the CapacityReservationsClient type.
type CapacityReservationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, capacityReservationGroupName string, capacityReservationName string, parameters compute.CapacityReservation) (result compute.CapacityReservationsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, capacityReservationGroupName string, capacityReservationName string) (result compute.CapacityReservationsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, capacityReservationGroupName string, capacityReservationName string, expand compute.CapacityReservationInstanceViewTypes) (result compute.CapacityReservation, err error)
	ListByCapacityReservationGroup(ctx context.Context, resourceGroupName string, capacityReservationGroupName string) (result compute.CapacityReservationListResultPage, err error)
	ListByCapacityReservationGroupComplete(ctx context.Context, resourceGroupName string, capacityReservationGroupName string) (result compute.CapacityReservationListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, capacityReservationGroupName string, capacityReservationName string, parameters compute.CapacityReservationUpdate) (result compute.CapacityReservationsUpdateFuture, err error)
}

var _ CapacityReservationsClientAPI = (*compute.CapacityReservationsClient)(nil)

// VirtualMachineScaleSetExtensionsClientAPI contains the set of methods on the VirtualMachineScaleSetExtensionsClient type.
type VirtualMachineScaleSetExtensionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, VMScaleSetName string, vmssExtensionName string, extensionParameters compute.VirtualMachineScaleSetExtension) (result compute.VirtualMachineScaleSetExtensionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, VMScaleSetName string, vmssExtensionName string) (result compute.VirtualMachineScaleSetExtensionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, VMScaleSetName string, vmssExtensionName string, expand string) (result compute.VirtualMachineScaleSetExtension, err error)
	List(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetExtensionListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetExtensionListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, VMScaleSetName string, vmssExtensionName string, extensionParameters compute.VirtualMachineScaleSetExtensionUpdate) (result compute.VirtualMachineScaleSetExtensionsUpdateFuture, err error)
}

var _ VirtualMachineScaleSetExtensionsClientAPI = (*compute.VirtualMachineScaleSetExtensionsClient)(nil)

// VirtualMachineScaleSetRollingUpgradesClientAPI contains the set of methods on the VirtualMachineScaleSetRollingUpgradesClient type.
type VirtualMachineScaleSetRollingUpgradesClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetRollingUpgradesCancelFuture, err error)
	GetLatest(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.RollingUpgradeStatusInfo, err error)
	StartExtensionUpgrade(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture, err error)
	StartOSUpgrade(ctx context.Context, resourceGroupName string, VMScaleSetName string) (result compute.VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture, err error)
}

var _ VirtualMachineScaleSetRollingUpgradesClientAPI = (*compute.VirtualMachineScaleSetRollingUpgradesClient)(nil)

// VirtualMachineScaleSetVMExtensionsClientAPI contains the set of methods on the VirtualMachineScaleSetVMExtensionsClient type.
type VirtualMachineScaleSetVMExtensionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, VMExtensionName string, extensionParameters compute.VirtualMachineScaleSetVMExtension) (result compute.VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, VMExtensionName string) (result compute.VirtualMachineScaleSetVMExtensionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, VMExtensionName string, expand string) (result compute.VirtualMachineScaleSetVMExtension, err error)
	List(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, expand string) (result compute.VirtualMachineScaleSetVMExtensionsListResult, err error)
	Update(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, VMExtensionName string, extensionParameters compute.VirtualMachineScaleSetVMExtensionUpdate) (result compute.VirtualMachineScaleSetVMExtensionsUpdateFuture, err error)
}

var _ VirtualMachineScaleSetVMExtensionsClientAPI = (*compute.VirtualMachineScaleSetVMExtensionsClient)(nil)

// VirtualMachineScaleSetVMsClientAPI contains the set of methods on the VirtualMachineScaleSetVMsClient type.
type VirtualMachineScaleSetVMsClientAPI interface {
	Deallocate(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string) (result compute.VirtualMachineScaleSetVMsDeallocateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, forceDeletion *bool) (result compute.VirtualMachineScaleSetVMsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, expand compute.InstanceViewTypes) (result compute.VirtualMachineScaleSetVM, err error)
	GetInstanceView(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string) (result compute.VirtualMachineScaleSetVMInstanceView, err error)
	List(ctx context.Context, resourceGroupName string, virtualMachineScaleSetName string, filter string, selectParameter string, expand string) (result compute.VirtualMachineScaleSetVMListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, virtualMachineScaleSetName string, filter string, selectParameter string, expand string) (result compute.VirtualMachineScaleSetVMListResultIterator, err error)
	PerformMaintenance(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string) (result compute.VirtualMachineScaleSetVMsPerformMaintenanceFuture, err error)
	PowerOff(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, skipShutdown *bool) (result compute.VirtualMachineScaleSetVMsPowerOffFuture, err error)
	Redeploy(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string) (result compute.VirtualMachineScaleSetVMsRedeployFuture, err error)
	Reimage(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, VMScaleSetVMReimageInput *compute.VirtualMachineScaleSetVMReimageParameters) (result compute.VirtualMachineScaleSetVMsReimageFuture, err error)
	ReimageAll(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string) (result compute.VirtualMachineScaleSetVMsReimageAllFuture, err error)
	Restart(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string) (result compute.VirtualMachineScaleSetVMsRestartFuture, err error)
	RetrieveBootDiagnosticsData(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, sasURIExpirationTimeInMinutes *int32) (result compute.RetrieveBootDiagnosticsDataResult, err error)
	RunCommand(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, parameters compute.RunCommandInput) (result compute.VirtualMachineScaleSetVMsRunCommandFuture, err error)
	SimulateEviction(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string) (result autorest.Response, err error)
	Start(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string) (result compute.VirtualMachineScaleSetVMsStartFuture, err error)
	Update(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, parameters compute.VirtualMachineScaleSetVM) (result compute.VirtualMachineScaleSetVMsUpdateFuture, err error)
}

var _ VirtualMachineScaleSetVMsClientAPI = (*compute.VirtualMachineScaleSetVMsClient)(nil)

// LogAnalyticsClientAPI contains the set of methods on the LogAnalyticsClient type.
type LogAnalyticsClientAPI interface {
	ExportRequestRateByInterval(ctx context.Context, parameters compute.RequestRateByIntervalInput, location string) (result compute.LogAnalyticsExportRequestRateByIntervalFuture, err error)
	ExportThrottledRequests(ctx context.Context, parameters compute.ThrottledRequestsInput, location string) (result compute.LogAnalyticsExportThrottledRequestsFuture, err error)
}

var _ LogAnalyticsClientAPI = (*compute.LogAnalyticsClient)(nil)

// VirtualMachineRunCommandsClientAPI contains the set of methods on the VirtualMachineRunCommandsClient type.
type VirtualMachineRunCommandsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, VMName string, runCommandName string, runCommand compute.VirtualMachineRunCommand) (result compute.VirtualMachineRunCommandsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, VMName string, runCommandName string) (result compute.VirtualMachineRunCommandsDeleteFuture, err error)
	Get(ctx context.Context, location string, commandID string) (result compute.RunCommandDocument, err error)
	GetByVirtualMachine(ctx context.Context, resourceGroupName string, VMName string, runCommandName string, expand string) (result compute.VirtualMachineRunCommand, err error)
	List(ctx context.Context, location string) (result compute.RunCommandListResultPage, err error)
	ListComplete(ctx context.Context, location string) (result compute.RunCommandListResultIterator, err error)
	ListByVirtualMachine(ctx context.Context, resourceGroupName string, VMName string, expand string) (result compute.VirtualMachineRunCommandsListResultPage, err error)
	ListByVirtualMachineComplete(ctx context.Context, resourceGroupName string, VMName string, expand string) (result compute.VirtualMachineRunCommandsListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, VMName string, runCommandName string, runCommand compute.VirtualMachineRunCommandUpdate) (result compute.VirtualMachineRunCommandsUpdateFuture, err error)
}

var _ VirtualMachineRunCommandsClientAPI = (*compute.VirtualMachineRunCommandsClient)(nil)

// VirtualMachineScaleSetVMRunCommandsClientAPI contains the set of methods on the VirtualMachineScaleSetVMRunCommandsClient type.
type VirtualMachineScaleSetVMRunCommandsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, runCommandName string, runCommand compute.VirtualMachineRunCommand) (result compute.VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, runCommandName string) (result compute.VirtualMachineScaleSetVMRunCommandsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, runCommandName string, expand string) (result compute.VirtualMachineRunCommand, err error)
	List(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, expand string) (result compute.VirtualMachineRunCommandsListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, expand string) (result compute.VirtualMachineRunCommandsListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, VMScaleSetName string, instanceID string, runCommandName string, runCommand compute.VirtualMachineRunCommandUpdate) (result compute.VirtualMachineScaleSetVMRunCommandsUpdateFuture, err error)
}

var _ VirtualMachineScaleSetVMRunCommandsClientAPI = (*compute.VirtualMachineScaleSetVMRunCommandsClient)(nil)

// ResourceSkusClientAPI contains the set of methods on the ResourceSkusClient type.
type ResourceSkusClientAPI interface {
	List(ctx context.Context, filter string, includeExtendedLocations string) (result compute.ResourceSkusResultPage, err error)
	ListComplete(ctx context.Context, filter string, includeExtendedLocations string) (result compute.ResourceSkusResultIterator, err error)
}

var _ ResourceSkusClientAPI = (*compute.ResourceSkusClient)(nil)

// DisksClientAPI contains the set of methods on the DisksClient type.
type DisksClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, diskName string, disk compute.Disk) (result compute.DisksCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, diskName string) (result compute.DisksDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, diskName string) (result compute.Disk, err error)
	GrantAccess(ctx context.Context, resourceGroupName string, diskName string, grantAccessData compute.GrantAccessData) (result compute.DisksGrantAccessFuture, err error)
	List(ctx context.Context) (result compute.DiskListPage, err error)
	ListComplete(ctx context.Context) (result compute.DiskListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.DiskListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.DiskListIterator, err error)
	RevokeAccess(ctx context.Context, resourceGroupName string, diskName string) (result compute.DisksRevokeAccessFuture, err error)
	Update(ctx context.Context, resourceGroupName string, diskName string, disk compute.DiskUpdate) (result compute.DisksUpdateFuture, err error)
}

var _ DisksClientAPI = (*compute.DisksClient)(nil)

// SnapshotsClientAPI contains the set of methods on the SnapshotsClient type.
type SnapshotsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, snapshotName string, snapshot compute.Snapshot) (result compute.SnapshotsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, snapshotName string) (result compute.SnapshotsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, snapshotName string) (result compute.Snapshot, err error)
	GrantAccess(ctx context.Context, resourceGroupName string, snapshotName string, grantAccessData compute.GrantAccessData) (result compute.SnapshotsGrantAccessFuture, err error)
	List(ctx context.Context) (result compute.SnapshotListPage, err error)
	ListComplete(ctx context.Context) (result compute.SnapshotListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.SnapshotListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.SnapshotListIterator, err error)
	RevokeAccess(ctx context.Context, resourceGroupName string, snapshotName string) (result compute.SnapshotsRevokeAccessFuture, err error)
	Update(ctx context.Context, resourceGroupName string, snapshotName string, snapshot compute.SnapshotUpdate) (result compute.SnapshotsUpdateFuture, err error)
}

var _ SnapshotsClientAPI = (*compute.SnapshotsClient)(nil)

// DiskEncryptionSetsClientAPI contains the set of methods on the DiskEncryptionSetsClient type.
type DiskEncryptionSetsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, diskEncryptionSetName string, diskEncryptionSet compute.DiskEncryptionSet) (result compute.DiskEncryptionSetsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, diskEncryptionSetName string) (result compute.DiskEncryptionSetsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, diskEncryptionSetName string) (result compute.DiskEncryptionSet, err error)
	List(ctx context.Context) (result compute.DiskEncryptionSetListPage, err error)
	ListComplete(ctx context.Context) (result compute.DiskEncryptionSetListIterator, err error)
	ListAssociatedResources(ctx context.Context, resourceGroupName string, diskEncryptionSetName string) (result compute.ResourceURIListPage, err error)
	ListAssociatedResourcesComplete(ctx context.Context, resourceGroupName string, diskEncryptionSetName string) (result compute.ResourceURIListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.DiskEncryptionSetListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.DiskEncryptionSetListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, diskEncryptionSetName string, diskEncryptionSet compute.DiskEncryptionSetUpdate) (result compute.DiskEncryptionSetsUpdateFuture, err error)
}

var _ DiskEncryptionSetsClientAPI = (*compute.DiskEncryptionSetsClient)(nil)

// DiskAccessesClientAPI contains the set of methods on the DiskAccessesClient type.
type DiskAccessesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, diskAccessName string, diskAccess compute.DiskAccess) (result compute.DiskAccessesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, diskAccessName string) (result compute.DiskAccessesDeleteFuture, err error)
	DeleteAPrivateEndpointConnection(ctx context.Context, resourceGroupName string, diskAccessName string, privateEndpointConnectionName string) (result compute.DiskAccessesDeleteAPrivateEndpointConnectionFuture, err error)
	Get(ctx context.Context, resourceGroupName string, diskAccessName string) (result compute.DiskAccess, err error)
	GetAPrivateEndpointConnection(ctx context.Context, resourceGroupName string, diskAccessName string, privateEndpointConnectionName string) (result compute.PrivateEndpointConnection, err error)
	GetPrivateLinkResources(ctx context.Context, resourceGroupName string, diskAccessName string) (result compute.PrivateLinkResourceListResult, err error)
	List(ctx context.Context) (result compute.DiskAccessListPage, err error)
	ListComplete(ctx context.Context) (result compute.DiskAccessListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.DiskAccessListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.DiskAccessListIterator, err error)
	ListPrivateEndpointConnections(ctx context.Context, resourceGroupName string, diskAccessName string) (result compute.PrivateEndpointConnectionListResultPage, err error)
	ListPrivateEndpointConnectionsComplete(ctx context.Context, resourceGroupName string, diskAccessName string) (result compute.PrivateEndpointConnectionListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, diskAccessName string, diskAccess compute.DiskAccessUpdate) (result compute.DiskAccessesUpdateFuture, err error)
	UpdateAPrivateEndpointConnection(ctx context.Context, resourceGroupName string, diskAccessName string, privateEndpointConnectionName string, privateEndpointConnection compute.PrivateEndpointConnection) (result compute.DiskAccessesUpdateAPrivateEndpointConnectionFuture, err error)
}

var _ DiskAccessesClientAPI = (*compute.DiskAccessesClient)(nil)

// DiskRestorePointClientAPI contains the set of methods on the DiskRestorePointClient type.
type DiskRestorePointClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, restorePointCollectionName string, VMRestorePointName string, diskRestorePointName string) (result compute.DiskRestorePoint, err error)
	GrantAccess(ctx context.Context, resourceGroupName string, restorePointCollectionName string, VMRestorePointName string, diskRestorePointName string, grantAccessData compute.GrantAccessData) (result compute.DiskRestorePointGrantAccessFuture, err error)
	ListByRestorePoint(ctx context.Context, resourceGroupName string, restorePointCollectionName string, VMRestorePointName string) (result compute.DiskRestorePointListPage, err error)
	ListByRestorePointComplete(ctx context.Context, resourceGroupName string, restorePointCollectionName string, VMRestorePointName string) (result compute.DiskRestorePointListIterator, err error)
	RevokeAccess(ctx context.Context, resourceGroupName string, restorePointCollectionName string, VMRestorePointName string, diskRestorePointName string) (result compute.DiskRestorePointRevokeAccessFuture, err error)
}

var _ DiskRestorePointClientAPI = (*compute.DiskRestorePointClient)(nil)

// GalleriesClientAPI contains the set of methods on the GalleriesClient type.
type GalleriesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, galleryName string, gallery compute.Gallery) (result compute.GalleriesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, galleryName string) (result compute.GalleriesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, galleryName string, selectParameter compute.SelectPermissions, expand compute.GalleryExpandParams) (result compute.Gallery, err error)
	List(ctx context.Context) (result compute.GalleryListPage, err error)
	ListComplete(ctx context.Context) (result compute.GalleryListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result compute.GalleryListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result compute.GalleryListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, galleryName string, gallery compute.GalleryUpdate) (result compute.GalleriesUpdateFuture, err error)
}

var _ GalleriesClientAPI = (*compute.GalleriesClient)(nil)

// GalleryImagesClientAPI contains the set of methods on the GalleryImagesClient type.
type GalleryImagesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string, galleryImage compute.GalleryImage) (result compute.GalleryImagesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string) (result compute.GalleryImagesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string) (result compute.GalleryImage, err error)
	ListByGallery(ctx context.Context, resourceGroupName string, galleryName string) (result compute.GalleryImageListPage, err error)
	ListByGalleryComplete(ctx context.Context, resourceGroupName string, galleryName string) (result compute.GalleryImageListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string, galleryImage compute.GalleryImageUpdate) (result compute.GalleryImagesUpdateFuture, err error)
}

var _ GalleryImagesClientAPI = (*compute.GalleryImagesClient)(nil)

// GalleryImageVersionsClientAPI contains the set of methods on the GalleryImageVersionsClient type.
type GalleryImageVersionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string, galleryImageVersionName string, galleryImageVersion compute.GalleryImageVersion) (result compute.GalleryImageVersionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string, galleryImageVersionName string) (result compute.GalleryImageVersionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string, galleryImageVersionName string, expand compute.ReplicationStatusTypes) (result compute.GalleryImageVersion, err error)
	ListByGalleryImage(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string) (result compute.GalleryImageVersionListPage, err error)
	ListByGalleryImageComplete(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string) (result compute.GalleryImageVersionListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, galleryName string, galleryImageName string, galleryImageVersionName string, galleryImageVersion compute.GalleryImageVersionUpdate) (result compute.GalleryImageVersionsUpdateFuture, err error)
}

var _ GalleryImageVersionsClientAPI = (*compute.GalleryImageVersionsClient)(nil)

// GalleryApplicationsClientAPI contains the set of methods on the GalleryApplicationsClient type.
type GalleryApplicationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string, galleryApplication compute.GalleryApplication) (result compute.GalleryApplicationsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string) (result compute.GalleryApplicationsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string) (result compute.GalleryApplication, err error)
	ListByGallery(ctx context.Context, resourceGroupName string, galleryName string) (result compute.GalleryApplicationListPage, err error)
	ListByGalleryComplete(ctx context.Context, resourceGroupName string, galleryName string) (result compute.GalleryApplicationListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string, galleryApplication compute.GalleryApplicationUpdate) (result compute.GalleryApplicationsUpdateFuture, err error)
}

var _ GalleryApplicationsClientAPI = (*compute.GalleryApplicationsClient)(nil)

// GalleryApplicationVersionsClientAPI contains the set of methods on the GalleryApplicationVersionsClient type.
type GalleryApplicationVersionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string, galleryApplicationVersionName string, galleryApplicationVersion compute.GalleryApplicationVersion) (result compute.GalleryApplicationVersionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string, galleryApplicationVersionName string) (result compute.GalleryApplicationVersionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string, galleryApplicationVersionName string, expand compute.ReplicationStatusTypes) (result compute.GalleryApplicationVersion, err error)
	ListByGalleryApplication(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string) (result compute.GalleryApplicationVersionListPage, err error)
	ListByGalleryApplicationComplete(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string) (result compute.GalleryApplicationVersionListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, galleryName string, galleryApplicationName string, galleryApplicationVersionName string, galleryApplicationVersion compute.GalleryApplicationVersionUpdate) (result compute.GalleryApplicationVersionsUpdateFuture, err error)
}

var _ GalleryApplicationVersionsClientAPI = (*compute.GalleryApplicationVersionsClient)(nil)

// GallerySharingProfileClientAPI contains the set of methods on the GallerySharingProfileClient type.
type GallerySharingProfileClientAPI interface {
	Update(ctx context.Context, resourceGroupName string, galleryName string, sharingUpdate compute.SharingUpdate) (result compute.GallerySharingProfileUpdateFuture, err error)
}

var _ GallerySharingProfileClientAPI = (*compute.GallerySharingProfileClient)(nil)

// SharedGalleriesClientAPI contains the set of methods on the SharedGalleriesClient type.
type SharedGalleriesClientAPI interface {
	Get(ctx context.Context, location string, galleryUniqueName string) (result compute.SharedGallery, err error)
	List(ctx context.Context, location string, sharedTo compute.SharedToValues) (result compute.SharedGalleryListPage, err error)
	ListComplete(ctx context.Context, location string, sharedTo compute.SharedToValues) (result compute.SharedGalleryListIterator, err error)
}

var _ SharedGalleriesClientAPI = (*compute.SharedGalleriesClient)(nil)

// SharedGalleryImagesClientAPI contains the set of methods on the SharedGalleryImagesClient type.
type SharedGalleryImagesClientAPI interface {
	Get(ctx context.Context, location string, galleryUniqueName string, galleryImageName string) (result compute.SharedGalleryImage, err error)
	List(ctx context.Context, location string, galleryUniqueName string, sharedTo compute.SharedToValues) (result compute.SharedGalleryImageListPage, err error)
	ListComplete(ctx context.Context, location string, galleryUniqueName string, sharedTo compute.SharedToValues) (result compute.SharedGalleryImageListIterator, err error)
}

var _ SharedGalleryImagesClientAPI = (*compute.SharedGalleryImagesClient)(nil)

// SharedGalleryImageVersionsClientAPI contains the set of methods on the SharedGalleryImageVersionsClient type.
type SharedGalleryImageVersionsClientAPI interface {
	Get(ctx context.Context, location string, galleryUniqueName string, galleryImageName string, galleryImageVersionName string) (result compute.SharedGalleryImageVersion, err error)
	List(ctx context.Context, location string, galleryUniqueName string, galleryImageName string, sharedTo compute.SharedToValues) (result compute.SharedGalleryImageVersionListPage, err error)
	ListComplete(ctx context.Context, location string, galleryUniqueName string, galleryImageName string, sharedTo compute.SharedToValues) (result compute.SharedGalleryImageVersionListIterator, err error)
}

var _ SharedGalleryImageVersionsClientAPI = (*compute.SharedGalleryImageVersionsClient)(nil)

// CommunityGalleriesClientAPI contains the set of methods on the CommunityGalleriesClient type.
type CommunityGalleriesClientAPI interface {
	Get(ctx context.Context, location string, publicGalleryName string) (result compute.CommunityGallery, err error)
}

var _ CommunityGalleriesClientAPI = (*compute.CommunityGalleriesClient)(nil)

// CommunityGalleryImagesClientAPI contains the set of methods on the CommunityGalleryImagesClient type.
type CommunityGalleryImagesClientAPI interface {
	Get(ctx context.Context, location string, publicGalleryName string, galleryImageName string) (result compute.CommunityGalleryImage, err error)
}

var _ CommunityGalleryImagesClientAPI = (*compute.CommunityGalleryImagesClient)(nil)

// CommunityGalleryImageVersionsClientAPI contains the set of methods on the CommunityGalleryImageVersionsClient type.
type CommunityGalleryImageVersionsClientAPI interface {
	Get(ctx context.Context, location string, publicGalleryName string, galleryImageName string, galleryImageVersionName string) (result compute.CommunityGalleryImageVersion, err error)
}

var _ CommunityGalleryImageVersionsClientAPI = (*compute.CommunityGalleryImageVersionsClient)(nil)

// CloudServiceRoleInstancesClientAPI contains the set of methods on the CloudServiceRoleInstancesClient type.
type CloudServiceRoleInstancesClientAPI interface {
	Delete(ctx context.Context, roleInstanceName string, resourceGroupName string, cloudServiceName string) (result compute.CloudServiceRoleInstancesDeleteFuture, err error)
	Get(ctx context.Context, roleInstanceName string, resourceGroupName string, cloudServiceName string, expand compute.InstanceViewTypes) (result compute.RoleInstance, err error)
	GetInstanceView(ctx context.Context, roleInstanceName string, resourceGroupName string, cloudServiceName string) (result compute.RoleInstanceInstanceView, err error)
	GetRemoteDesktopFile(ctx context.Context, roleInstanceName string, resourceGroupName string, cloudServiceName string) (result compute.ReadCloser, err error)
	List(ctx context.Context, resourceGroupName string, cloudServiceName string, expand compute.InstanceViewTypes) (result compute.RoleInstanceListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, cloudServiceName string, expand compute.InstanceViewTypes) (result compute.RoleInstanceListResultIterator, err error)
	Rebuild(ctx context.Context, roleInstanceName string, resourceGroupName string, cloudServiceName string) (result compute.CloudServiceRoleInstancesRebuildFuture, err error)
	Reimage(ctx context.Context, roleInstanceName string, resourceGroupName string, cloudServiceName string) (result compute.CloudServiceRoleInstancesReimageFuture, err error)
	Restart(ctx context.Context, roleInstanceName string, resourceGroupName string, cloudServiceName string) (result compute.CloudServiceRoleInstancesRestartFuture, err error)
}

var _ CloudServiceRoleInstancesClientAPI = (*compute.CloudServiceRoleInstancesClient)(nil)

// CloudServiceRolesClientAPI contains the set of methods on the CloudServiceRolesClient type.
type CloudServiceRolesClientAPI interface {
	Get(ctx context.Context, roleName string, resourceGroupName string, cloudServiceName string) (result compute.CloudServiceRole, err error)
	List(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.CloudServiceRoleListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.CloudServiceRoleListResultIterator, err error)
}

var _ CloudServiceRolesClientAPI = (*compute.CloudServiceRolesClient)(nil)

// CloudServicesClientAPI contains the set of methods on the CloudServicesClient type.
type CloudServicesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, cloudServiceName string, parameters *compute.CloudService) (result compute.CloudServicesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.CloudServicesDeleteFuture, err error)
	DeleteInstances(ctx context.Context, resourceGroupName string, cloudServiceName string, parameters *compute.RoleInstances) (result compute.CloudServicesDeleteInstancesFuture, err error)
	Get(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.CloudService, err error)
	GetInstanceView(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.CloudServiceInstanceView, err error)
	List(ctx context.Context, resourceGroupName string) (result compute.CloudServiceListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string) (result compute.CloudServiceListResultIterator, err error)
	ListAll(ctx context.Context) (result compute.CloudServiceListResultPage, err error)
	ListAllComplete(ctx context.Context) (result compute.CloudServiceListResultIterator, err error)
	PowerOff(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.CloudServicesPowerOffFuture, err error)
	Rebuild(ctx context.Context, resourceGroupName string, cloudServiceName string, parameters *compute.RoleInstances) (result compute.CloudServicesRebuildFuture, err error)
	Reimage(ctx context.Context, resourceGroupName string, cloudServiceName string, parameters *compute.RoleInstances) (result compute.CloudServicesReimageFuture, err error)
	Restart(ctx context.Context, resourceGroupName string, cloudServiceName string, parameters *compute.RoleInstances) (result compute.CloudServicesRestartFuture, err error)
	Start(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.CloudServicesStartFuture, err error)
	Update(ctx context.Context, resourceGroupName string, cloudServiceName string, parameters *compute.CloudServiceUpdate) (result compute.CloudServicesUpdateFuture, err error)
}

var _ CloudServicesClientAPI = (*compute.CloudServicesClient)(nil)

// CloudServicesUpdateDomainClientAPI contains the set of methods on the CloudServicesUpdateDomainClient type.
type CloudServicesUpdateDomainClientAPI interface {
	GetUpdateDomain(ctx context.Context, resourceGroupName string, cloudServiceName string, updateDomain int32) (result compute.UpdateDomain, err error)
	ListUpdateDomains(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.UpdateDomainListResultPage, err error)
	ListUpdateDomainsComplete(ctx context.Context, resourceGroupName string, cloudServiceName string) (result compute.UpdateDomainListResultIterator, err error)
	WalkUpdateDomain(ctx context.Context, resourceGroupName string, cloudServiceName string, updateDomain int32, parameters *compute.UpdateDomain) (result compute.CloudServicesUpdateDomainWalkUpdateDomainFuture, err error)
}

var _ CloudServicesUpdateDomainClientAPI = (*compute.CloudServicesUpdateDomainClient)(nil)

// CloudServiceOperatingSystemsClientAPI contains the set of methods on the CloudServiceOperatingSystemsClient type.
type CloudServiceOperatingSystemsClientAPI interface {
	GetOSFamily(ctx context.Context, location string, osFamilyName string) (result compute.OSFamily, err error)
	GetOSVersion(ctx context.Context, location string, osVersionName string) (result compute.OSVersion, err error)
	ListOSFamilies(ctx context.Context, location string) (result compute.OSFamilyListResultPage, err error)
	ListOSFamiliesComplete(ctx context.Context, location string) (result compute.OSFamilyListResultIterator, err error)
	ListOSVersions(ctx context.Context, location string) (result compute.OSVersionListResultPage, err error)
	ListOSVersionsComplete(ctx context.Context, location string) (result compute.OSVersionListResultIterator, err error)
}

var _ CloudServiceOperatingSystemsClientAPI = (*compute.CloudServiceOperatingSystemsClient)(nil)
