// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/sensu/sensu-go/api/core/v2/metric_threshold.proto

package v2

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A rule to apply to a metric to determine its status
type MetricThresholdRule struct {
	// Minimum value for the metric to be considered ok
	Min string `protobuf:"bytes,1,opt,name=min,proto3" json:"min"`
	// Maximum value for the metric to be considered ok
	Max string `protobuf:"bytes,2,opt,name=max,proto3" json:"max"`
	// The status of the metric if the value is below the minimum or above the maximum
	Status               uint32   `protobuf:"varint,3,opt,name=status,proto3" json:"status"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetricThresholdRule) Reset()         { *m = MetricThresholdRule{} }
func (m *MetricThresholdRule) String() string { return proto.CompactTextString(m) }
func (*MetricThresholdRule) ProtoMessage()    {}
func (*MetricThresholdRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_d6f3da758ea11cc5, []int{0}
}
func (m *MetricThresholdRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricThresholdRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricThresholdRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricThresholdRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricThresholdRule.Merge(m, src)
}
func (m *MetricThresholdRule) XXX_Size() int {
	return m.Size()
}
func (m *MetricThresholdRule) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricThresholdRule.DiscardUnknown(m)
}

var xxx_messageInfo_MetricThresholdRule proto.InternalMessageInfo

func (m *MetricThresholdRule) GetMin() string {
	if m != nil {
		return m.Min
	}
	return ""
}

func (m *MetricThresholdRule) GetMax() string {
	if m != nil {
		return m.Max
	}
	return ""
}

func (m *MetricThresholdRule) GetStatus() uint32 {
	if m != nil {
		return m.Status
	}
	return 0
}

// Represents the measurement tags to match
type MetricThresholdTag struct {
	// Name of the metric tag to match
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	// Value of the metric tag to match
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetricThresholdTag) Reset()         { *m = MetricThresholdTag{} }
func (m *MetricThresholdTag) String() string { return proto.CompactTextString(m) }
func (*MetricThresholdTag) ProtoMessage()    {}
func (*MetricThresholdTag) Descriptor() ([]byte, []int) {
	return fileDescriptor_d6f3da758ea11cc5, []int{1}
}
func (m *MetricThresholdTag) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricThresholdTag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricThresholdTag.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricThresholdTag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricThresholdTag.Merge(m, src)
}
func (m *MetricThresholdTag) XXX_Size() int {
	return m.Size()
}
func (m *MetricThresholdTag) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricThresholdTag.DiscardUnknown(m)
}

var xxx_messageInfo_MetricThresholdTag proto.InternalMessageInfo

func (m *MetricThresholdTag) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MetricThresholdTag) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Represents an instance of a metric filter to evaluate
type MetricThreshold struct {
	// Name of the metric to match
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	// Tag values to match with the metric
	Tags []*MetricThresholdTag `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags"`
	// Rules to evaluate when the filter matches a metric
	Thresholds []*MetricThresholdRule `protobuf:"bytes,3,rep,name=thresholds,proto3" json:"thresholds"`
	// The metric status if the measurement is missing
	NullStatus           uint32   `protobuf:"varint,4,opt,name=null_status,json=nullStatus,proto3" json:"null_status"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetricThreshold) Reset()         { *m = MetricThreshold{} }
func (m *MetricThreshold) String() string { return proto.CompactTextString(m) }
func (*MetricThreshold) ProtoMessage()    {}
func (*MetricThreshold) Descriptor() ([]byte, []int) {
	return fileDescriptor_d6f3da758ea11cc5, []int{2}
}
func (m *MetricThreshold) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricThreshold) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricThreshold.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricThreshold) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricThreshold.Merge(m, src)
}
func (m *MetricThreshold) XXX_Size() int {
	return m.Size()
}
func (m *MetricThreshold) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricThreshold.DiscardUnknown(m)
}

var xxx_messageInfo_MetricThreshold proto.InternalMessageInfo

func (m *MetricThreshold) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MetricThreshold) GetTags() []*MetricThresholdTag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *MetricThreshold) GetThresholds() []*MetricThresholdRule {
	if m != nil {
		return m.Thresholds
	}
	return nil
}

func (m *MetricThreshold) GetNullStatus() uint32 {
	if m != nil {
		return m.NullStatus
	}
	return 0
}

func init() {
	proto.RegisterType((*MetricThresholdRule)(nil), "sensu.core.v2.MetricThresholdRule")
	proto.RegisterType((*MetricThresholdTag)(nil), "sensu.core.v2.MetricThresholdTag")
	proto.RegisterType((*MetricThreshold)(nil), "sensu.core.v2.MetricThreshold")
}

func init() {
	proto.RegisterFile("github.com/sensu/sensu-go/api/core/v2/metric_threshold.proto", fileDescriptor_d6f3da758ea11cc5)
}

var fileDescriptor_d6f3da758ea11cc5 = []byte{
	// 369 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x91, 0x3f, 0x4e, 0xeb, 0x40,
	0x10, 0xc6, 0xdf, 0x26, 0x79, 0x81, 0x4c, 0x14, 0x22, 0x2d, 0x8d, 0x41, 0xc8, 0x36, 0xae, 0xd2,
	0xb0, 0x26, 0x0e, 0x25, 0x12, 0xc8, 0x3d, 0xcd, 0x26, 0x15, 0x4d, 0xb4, 0x09, 0xc6, 0xb1, 0x64,
	0x7b, 0x23, 0xff, 0x53, 0x8e, 0xc2, 0x11, 0x38, 0x02, 0x47, 0xa0, 0xe4, 0x04, 0x16, 0x98, 0xce,
	0x07, 0x40, 0x94, 0x68, 0xd7, 0x06, 0x99, 0x20, 0x41, 0xf3, 0xed, 0xcc, 0xb7, 0xb3, 0xbf, 0xb1,
	0x67, 0xe0, 0xdc, 0xf5, 0x92, 0x55, 0xba, 0x20, 0x4b, 0x1e, 0x98, 0xb1, 0x13, 0xc6, 0x69, 0xa5,
	0x27, 0x2e, 0x37, 0xd9, 0xda, 0x33, 0x97, 0x3c, 0x72, 0xcc, 0xcc, 0x32, 0x03, 0x27, 0x89, 0xbc,
	0xe5, 0x3c, 0x59, 0x45, 0x4e, 0xbc, 0xe2, 0xfe, 0x0d, 0x59, 0x47, 0x3c, 0xe1, 0x78, 0x20, 0x8b,
	0x89, 0xa8, 0x22, 0x99, 0x75, 0x78, 0xd6, 0x80, 0xb9, 0xdc, 0xe5, 0xa6, 0xac, 0x5a, 0xa4, 0xb7,
	0x97, 0xd9, 0x98, 0x4c, 0xc8, 0x58, 0x9a, 0xd2, 0x93, 0x51, 0x05, 0x31, 0x38, 0xec, 0x5f, 0x49,
	0xfc, 0xec, 0x93, 0x4e, 0x53, 0xdf, 0xc1, 0x07, 0xd0, 0x0e, 0xbc, 0x50, 0x41, 0x3a, 0x1a, 0xf5,
	0xec, 0x9d, 0x32, 0xd7, 0x44, 0x4a, 0x85, 0xc8, 0x2b, 0xb6, 0x51, 0x5a, 0x8d, 0x2b, 0xb6, 0xa1,
	0x42, 0xb0, 0x01, 0xdd, 0x38, 0x61, 0x49, 0x1a, 0x2b, 0x6d, 0x1d, 0x8d, 0x06, 0x36, 0x94, 0xb9,
	0x56, 0x3b, 0xb4, 0x3e, 0x8d, 0x29, 0xe0, 0xad, 0x86, 0x33, 0xe6, 0xe2, 0x23, 0xe8, 0x84, 0x2c,
	0x70, 0xea, 0x86, 0xbb, 0x65, 0xae, 0xc9, 0x9c, 0x4a, 0xc5, 0x1a, 0xfc, 0xcf, 0x98, 0x9f, 0x3a,
	0x75, 0xd3, 0x5e, 0x99, 0x6b, 0x95, 0x41, 0xab, 0xc3, 0x78, 0x43, 0x30, 0xdc, 0xa2, 0xfe, 0x81,
	0xbc, 0x80, 0x4e, 0xc2, 0xdc, 0x58, 0x69, 0xe9, 0xed, 0x51, 0xdf, 0x3a, 0x26, 0xdf, 0x66, 0x49,
	0x7e, 0x7e, 0x61, 0x05, 0x10, 0x4f, 0xa8, 0x54, 0x4c, 0x01, 0xbe, 0x16, 0x22, 0xfe, 0x57, 0x60,
	0x8c, 0xdf, 0x31, 0x62, 0xb2, 0xf6, 0x5e, 0x99, 0x6b, 0x8d, 0x97, 0xb4, 0x11, 0xe3, 0x53, 0xe8,
	0x87, 0xa9, 0xef, 0xcf, 0xeb, 0x21, 0x76, 0xe4, 0x10, 0x87, 0x65, 0xae, 0x35, 0x6d, 0x0a, 0x22,
	0x99, 0xca, 0xd8, 0xd6, 0xdf, 0x5f, 0x54, 0x74, 0x5f, 0xa8, 0xe8, 0xa1, 0x50, 0xd1, 0x63, 0xa1,
	0xa2, 0xa7, 0x42, 0x45, 0xcf, 0x85, 0x8a, 0xee, 0x5e, 0xd5, 0x7f, 0xd7, 0xad, 0xcc, 0x5a, 0x74,
	0xe5, 0x9e, 0x27, 0x1f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xf1, 0x1e, 0xf8, 0x72, 0x6c, 0x02, 0x00,
	0x00,
}

func (this *MetricThresholdRule) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MetricThresholdRule)
	if !ok {
		that2, ok := that.(MetricThresholdRule)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Min != that1.Min {
		return false
	}
	if this.Max != that1.Max {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MetricThresholdTag) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MetricThresholdTag)
	if !ok {
		that2, ok := that.(MetricThresholdTag)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MetricThreshold) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MetricThreshold)
	if !ok {
		that2, ok := that.(MetricThreshold)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Tags) != len(that1.Tags) {
		return false
	}
	for i := range this.Tags {
		if !this.Tags[i].Equal(that1.Tags[i]) {
			return false
		}
	}
	if len(this.Thresholds) != len(that1.Thresholds) {
		return false
	}
	for i := range this.Thresholds {
		if !this.Thresholds[i].Equal(that1.Thresholds[i]) {
			return false
		}
	}
	if this.NullStatus != that1.NullStatus {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (m *MetricThresholdRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricThresholdRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricThresholdRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Status != 0 {
		i = encodeVarintMetricThreshold(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Max) > 0 {
		i -= len(m.Max)
		copy(dAtA[i:], m.Max)
		i = encodeVarintMetricThreshold(dAtA, i, uint64(len(m.Max)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Min) > 0 {
		i -= len(m.Min)
		copy(dAtA[i:], m.Min)
		i = encodeVarintMetricThreshold(dAtA, i, uint64(len(m.Min)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MetricThresholdTag) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricThresholdTag) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricThresholdTag) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintMetricThreshold(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMetricThreshold(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MetricThreshold) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricThreshold) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricThreshold) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NullStatus != 0 {
		i = encodeVarintMetricThreshold(dAtA, i, uint64(m.NullStatus))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Thresholds) > 0 {
		for iNdEx := len(m.Thresholds) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Thresholds[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetricThreshold(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tags[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetricThreshold(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMetricThreshold(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMetricThreshold(dAtA []byte, offset int, v uint64) int {
	offset -= sovMetricThreshold(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedMetricThresholdRule(r randyMetricThreshold, easy bool) *MetricThresholdRule {
	this := &MetricThresholdRule{}
	this.Min = string(randStringMetricThreshold(r))
	this.Max = string(randStringMetricThreshold(r))
	this.Status = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMetricThreshold(r, 4)
	}
	return this
}

func NewPopulatedMetricThresholdTag(r randyMetricThreshold, easy bool) *MetricThresholdTag {
	this := &MetricThresholdTag{}
	this.Name = string(randStringMetricThreshold(r))
	this.Value = string(randStringMetricThreshold(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMetricThreshold(r, 3)
	}
	return this
}

func NewPopulatedMetricThreshold(r randyMetricThreshold, easy bool) *MetricThreshold {
	this := &MetricThreshold{}
	this.Name = string(randStringMetricThreshold(r))
	if r.Intn(5) != 0 {
		v1 := r.Intn(5)
		this.Tags = make([]*MetricThresholdTag, v1)
		for i := 0; i < v1; i++ {
			this.Tags[i] = NewPopulatedMetricThresholdTag(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v2 := r.Intn(5)
		this.Thresholds = make([]*MetricThresholdRule, v2)
		for i := 0; i < v2; i++ {
			this.Thresholds[i] = NewPopulatedMetricThresholdRule(r, easy)
		}
	}
	this.NullStatus = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMetricThreshold(r, 5)
	}
	return this
}

type randyMetricThreshold interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMetricThreshold(r randyMetricThreshold) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMetricThreshold(r randyMetricThreshold) string {
	v3 := r.Intn(100)
	tmps := make([]rune, v3)
	for i := 0; i < v3; i++ {
		tmps[i] = randUTF8RuneMetricThreshold(r)
	}
	return string(tmps)
}
func randUnrecognizedMetricThreshold(r randyMetricThreshold, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMetricThreshold(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMetricThreshold(dAtA []byte, r randyMetricThreshold, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMetricThreshold(dAtA, uint64(key))
		v4 := r.Int63()
		if r.Intn(2) == 0 {
			v4 *= -1
		}
		dAtA = encodeVarintPopulateMetricThreshold(dAtA, uint64(v4))
	case 1:
		dAtA = encodeVarintPopulateMetricThreshold(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMetricThreshold(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMetricThreshold(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMetricThreshold(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMetricThreshold(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *MetricThresholdRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Min)
	if l > 0 {
		n += 1 + l + sovMetricThreshold(uint64(l))
	}
	l = len(m.Max)
	if l > 0 {
		n += 1 + l + sovMetricThreshold(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovMetricThreshold(uint64(m.Status))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MetricThresholdTag) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMetricThreshold(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovMetricThreshold(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MetricThreshold) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMetricThreshold(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, e := range m.Tags {
			l = e.Size()
			n += 1 + l + sovMetricThreshold(uint64(l))
		}
	}
	if len(m.Thresholds) > 0 {
		for _, e := range m.Thresholds {
			l = e.Size()
			n += 1 + l + sovMetricThreshold(uint64(l))
		}
	}
	if m.NullStatus != 0 {
		n += 1 + sovMetricThreshold(uint64(m.NullStatus))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMetricThreshold(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMetricThreshold(x uint64) (n int) {
	return sovMetricThreshold(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MetricThresholdRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricThreshold
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricThresholdRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricThresholdRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Min = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Max = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetricThreshold(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricThresholdTag) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricThreshold
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricThresholdTag: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricThresholdTag: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetricThreshold(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricThreshold) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetricThreshold
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricThreshold: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricThreshold: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, &MetricThresholdTag{})
			if err := m.Tags[len(m.Tags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Thresholds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Thresholds = append(m.Thresholds, &MetricThresholdRule{})
			if err := m.Thresholds[len(m.Thresholds)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NullStatus", wireType)
			}
			m.NullStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NullStatus |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetricThreshold(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetricThreshold
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetricThreshold(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetricThreshold
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetricThreshold
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMetricThreshold
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMetricThreshold
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMetricThreshold
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMetricThreshold        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetricThreshold          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMetricThreshold = fmt.Errorf("proto: unexpected end of group")
)
