//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azblob

import (
	"context"
	"encoding/xml"
	"fmt"
	"net/http"
	"strconv"
	"strings"
	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

type containerClient struct {
	con *connection
}

// AcquireLease - [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60 seconds, or can be infinite
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) AcquireLease(ctx context.Context, containerAcquireLeaseOptions *ContainerAcquireLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (ContainerAcquireLeaseResponse, error) {
	req, err := client.acquireLeaseCreateRequest(ctx, containerAcquireLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return ContainerAcquireLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerAcquireLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return ContainerAcquireLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.acquireLeaseHandleResponse(resp)
}

// acquireLeaseCreateRequest creates the AcquireLease request.
func (client *containerClient) acquireLeaseCreateRequest(ctx context.Context, containerAcquireLeaseOptions *ContainerAcquireLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "container")
	if containerAcquireLeaseOptions != nil && containerAcquireLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerAcquireLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "acquire")
	if containerAcquireLeaseOptions != nil && containerAcquireLeaseOptions.Duration != nil {
		req.Raw().Header.Set("x-ms-lease-duration", strconv.FormatInt(int64(*containerAcquireLeaseOptions.Duration), 10))
	}
	if containerAcquireLeaseOptions != nil && containerAcquireLeaseOptions.ProposedLeaseID != nil {
		req.Raw().Header.Set("x-ms-proposed-lease-id", *containerAcquireLeaseOptions.ProposedLeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerAcquireLeaseOptions != nil && containerAcquireLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerAcquireLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// acquireLeaseHandleResponse handles the AcquireLease response.
func (client *containerClient) acquireLeaseHandleResponse(resp *http.Response) (ContainerAcquireLeaseResponse, error) {
	result := ContainerAcquireLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerAcquireLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerAcquireLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// BreakLease - [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60 seconds, or can be infinite
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) BreakLease(ctx context.Context, containerBreakLeaseOptions *ContainerBreakLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (ContainerBreakLeaseResponse, error) {
	req, err := client.breakLeaseCreateRequest(ctx, containerBreakLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return ContainerBreakLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerBreakLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return ContainerBreakLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.breakLeaseHandleResponse(resp)
}

// breakLeaseCreateRequest creates the BreakLease request.
func (client *containerClient) breakLeaseCreateRequest(ctx context.Context, containerBreakLeaseOptions *ContainerBreakLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "container")
	if containerBreakLeaseOptions != nil && containerBreakLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerBreakLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "break")
	if containerBreakLeaseOptions != nil && containerBreakLeaseOptions.BreakPeriod != nil {
		req.Raw().Header.Set("x-ms-lease-break-period", strconv.FormatInt(int64(*containerBreakLeaseOptions.BreakPeriod), 10))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerBreakLeaseOptions != nil && containerBreakLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerBreakLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// breakLeaseHandleResponse handles the BreakLease response.
func (client *containerClient) breakLeaseHandleResponse(resp *http.Response) (ContainerBreakLeaseResponse, error) {
	result := ContainerBreakLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerBreakLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-time"); val != "" {
		leaseTime32, err := strconv.ParseInt(val, 10, 32)
		leaseTime := int32(leaseTime32)
		if err != nil {
			return ContainerBreakLeaseResponse{}, err
		}
		result.LeaseTime = &leaseTime
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerBreakLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// ChangeLease - [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60 seconds, or can be infinite
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) ChangeLease(ctx context.Context, leaseID string, proposedLeaseID string, containerChangeLeaseOptions *ContainerChangeLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (ContainerChangeLeaseResponse, error) {
	req, err := client.changeLeaseCreateRequest(ctx, leaseID, proposedLeaseID, containerChangeLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return ContainerChangeLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerChangeLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainerChangeLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.changeLeaseHandleResponse(resp)
}

// changeLeaseCreateRequest creates the ChangeLease request.
func (client *containerClient) changeLeaseCreateRequest(ctx context.Context, leaseID string, proposedLeaseID string, containerChangeLeaseOptions *ContainerChangeLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "container")
	if containerChangeLeaseOptions != nil && containerChangeLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerChangeLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "change")
	req.Raw().Header.Set("x-ms-lease-id", leaseID)
	req.Raw().Header.Set("x-ms-proposed-lease-id", proposedLeaseID)
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerChangeLeaseOptions != nil && containerChangeLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerChangeLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// changeLeaseHandleResponse handles the ChangeLease response.
func (client *containerClient) changeLeaseHandleResponse(resp *http.Response) (ContainerChangeLeaseResponse, error) {
	result := ContainerChangeLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerChangeLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerChangeLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// Create - creates a new container under the specified account. If the container with the same name already exists, the operation fails
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) Create(ctx context.Context, containerCreateOptions *ContainerCreateOptions, containerCpkScopeInfo *ContainerCpkScopeInfo) (ContainerCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, containerCreateOptions, containerCpkScopeInfo)
	if err != nil {
		return ContainerCreateResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return ContainerCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *containerClient) createCreateRequest(ctx context.Context, containerCreateOptions *ContainerCreateOptions, containerCpkScopeInfo *ContainerCpkScopeInfo) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	if containerCreateOptions != nil && containerCreateOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerCreateOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if containerCreateOptions != nil && containerCreateOptions.Metadata != nil {
		for k, v := range containerCreateOptions.Metadata {
			req.Raw().Header.Set("x-ms-meta-"+k, v)
		}
	}
	if containerCreateOptions != nil && containerCreateOptions.Access != nil {
		req.Raw().Header.Set("x-ms-blob-public-access", string(*containerCreateOptions.Access))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerCreateOptions != nil && containerCreateOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerCreateOptions.RequestID)
	}
	if containerCpkScopeInfo != nil && containerCpkScopeInfo.DefaultEncryptionScope != nil {
		req.Raw().Header.Set("x-ms-default-encryption-scope", *containerCpkScopeInfo.DefaultEncryptionScope)
	}
	if containerCpkScopeInfo != nil && containerCpkScopeInfo.PreventEncryptionScopeOverride != nil {
		req.Raw().Header.Set("x-ms-deny-encryption-scope-override", strconv.FormatBool(*containerCpkScopeInfo.PreventEncryptionScopeOverride))
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *containerClient) createHandleResponse(resp *http.Response) (ContainerCreateResponse, error) {
	result := ContainerCreateResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerCreateResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerCreateResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// Delete - operation marks the specified container for deletion. The container and any blobs contained within it are later deleted during garbage collection
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) Delete(ctx context.Context, containerDeleteOptions *ContainerDeleteOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (ContainerDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, containerDeleteOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return ContainerDeleteResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return ContainerDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteHandleResponse(resp)
}

// deleteCreateRequest creates the Delete request.
func (client *containerClient) deleteCreateRequest(ctx context.Context, containerDeleteOptions *ContainerDeleteOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodDelete, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	if containerDeleteOptions != nil && containerDeleteOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerDeleteOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerDeleteOptions != nil && containerDeleteOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerDeleteOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *containerClient) deleteHandleResponse(resp *http.Response) (ContainerDeleteResponse, error) {
	result := ContainerDeleteResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerDeleteResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// GetAccessPolicy - gets the permissions for the specified container. The permissions indicate whether container data may be accessed publicly.
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) GetAccessPolicy(ctx context.Context, containerGetAccessPolicyOptions *ContainerGetAccessPolicyOptions, leaseAccessConditions *LeaseAccessConditions) (ContainerGetAccessPolicyResponse, error) {
	req, err := client.getAccessPolicyCreateRequest(ctx, containerGetAccessPolicyOptions, leaseAccessConditions)
	if err != nil {
		return ContainerGetAccessPolicyResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerGetAccessPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainerGetAccessPolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAccessPolicyHandleResponse(resp)
}

// getAccessPolicyCreateRequest creates the GetAccessPolicy request.
func (client *containerClient) getAccessPolicyCreateRequest(ctx context.Context, containerGetAccessPolicyOptions *ContainerGetAccessPolicyOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	reqQP.Set("comp", "acl")
	if containerGetAccessPolicyOptions != nil && containerGetAccessPolicyOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerGetAccessPolicyOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerGetAccessPolicyOptions != nil && containerGetAccessPolicyOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerGetAccessPolicyOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getAccessPolicyHandleResponse handles the GetAccessPolicy response.
func (client *containerClient) getAccessPolicyHandleResponse(resp *http.Response) (ContainerGetAccessPolicyResponse, error) {
	result := ContainerGetAccessPolicyResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-blob-public-access"); val != "" {
		result.BlobPublicAccess = (*PublicAccessType)(&val)
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerGetAccessPolicyResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerGetAccessPolicyResponse{}, err
		}
		result.Date = &date
	}
	if err := runtime.UnmarshalAsXML(resp, &result); err != nil {
		return ContainerGetAccessPolicyResponse{}, err
	}
	return result, nil
}

// GetAccountInfo - Returns the sku name and account kind
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) GetAccountInfo(ctx context.Context, options *ContainerGetAccountInfoOptions) (ContainerGetAccountInfoResponse, error) {
	req, err := client.getAccountInfoCreateRequest(ctx, options)
	if err != nil {
		return ContainerGetAccountInfoResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerGetAccountInfoResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainerGetAccountInfoResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAccountInfoHandleResponse(resp)
}

// getAccountInfoCreateRequest creates the GetAccountInfo request.
func (client *containerClient) getAccountInfoCreateRequest(ctx context.Context, options *ContainerGetAccountInfoOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "account")
	reqQP.Set("comp", "properties")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getAccountInfoHandleResponse handles the GetAccountInfo response.
func (client *containerClient) getAccountInfoHandleResponse(resp *http.Response) (ContainerGetAccountInfoResponse, error) {
	result := ContainerGetAccountInfoResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerGetAccountInfoResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-sku-name"); val != "" {
		result.SKUName = (*SKUName)(&val)
	}
	if val := resp.Header.Get("x-ms-account-kind"); val != "" {
		result.AccountKind = (*AccountKind)(&val)
	}
	return result, nil
}

// GetProperties - returns all user-defined metadata and system properties for the specified container. The data returned does not include the container's
// list of blobs
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) GetProperties(ctx context.Context, containerGetPropertiesOptions *ContainerGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions) (ContainerGetPropertiesResponse, error) {
	req, err := client.getPropertiesCreateRequest(ctx, containerGetPropertiesOptions, leaseAccessConditions)
	if err != nil {
		return ContainerGetPropertiesResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerGetPropertiesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainerGetPropertiesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPropertiesHandleResponse(resp)
}

// getPropertiesCreateRequest creates the GetProperties request.
func (client *containerClient) getPropertiesCreateRequest(ctx context.Context, containerGetPropertiesOptions *ContainerGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	if containerGetPropertiesOptions != nil && containerGetPropertiesOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerGetPropertiesOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerGetPropertiesOptions != nil && containerGetPropertiesOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerGetPropertiesOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getPropertiesHandleResponse handles the GetProperties response.
func (client *containerClient) getPropertiesHandleResponse(resp *http.Response) (ContainerGetPropertiesResponse, error) {
	result := ContainerGetPropertiesResponse{RawResponse: resp}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-meta-") && strings.EqualFold(hh[:len("x-ms-meta-")], "x-ms-meta-") {
			if result.Metadata == nil {
				result.Metadata = map[string]string{}
			}
			result.Metadata[hh[len("x-ms-meta-"):]] = resp.Header.Get(hh)
		}
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerGetPropertiesResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = (*LeaseDurationType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = (*LeaseStateType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = (*LeaseStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerGetPropertiesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-blob-public-access"); val != "" {
		result.BlobPublicAccess = (*PublicAccessType)(&val)
	}
	if val := resp.Header.Get("x-ms-has-immutability-policy"); val != "" {
		hasImmutabilityPolicy, err := strconv.ParseBool(val)
		if err != nil {
			return ContainerGetPropertiesResponse{}, err
		}
		result.HasImmutabilityPolicy = &hasImmutabilityPolicy
	}
	if val := resp.Header.Get("x-ms-has-legal-hold"); val != "" {
		hasLegalHold, err := strconv.ParseBool(val)
		if err != nil {
			return ContainerGetPropertiesResponse{}, err
		}
		result.HasLegalHold = &hasLegalHold
	}
	if val := resp.Header.Get("x-ms-default-encryption-scope"); val != "" {
		result.DefaultEncryptionScope = &val
	}
	if val := resp.Header.Get("x-ms-deny-encryption-scope-override"); val != "" {
		denyEncryptionScopeOverride, err := strconv.ParseBool(val)
		if err != nil {
			return ContainerGetPropertiesResponse{}, err
		}
		result.DenyEncryptionScopeOverride = &denyEncryptionScopeOverride
	}
	return result, nil
}

// ListBlobFlatSegment - [Update] The List Blobs operation returns a list of the blobs under the specified container
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) ListBlobFlatSegment(options *ContainerListBlobFlatSegmentOptions) *ContainerListBlobFlatSegmentPager {
	return &ContainerListBlobFlatSegmentPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.listBlobFlatSegmentCreateRequest(ctx, options)
		},
		advancer: func(ctx context.Context, resp ContainerListBlobFlatSegmentResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.ListBlobsFlatSegmentResponse.NextMarker)
		},
	}
}

// listBlobFlatSegmentCreateRequest creates the ListBlobFlatSegment request.
func (client *containerClient) listBlobFlatSegmentCreateRequest(ctx context.Context, options *ContainerListBlobFlatSegmentOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	reqQP.Set("comp", "list")
	if options != nil && options.Prefix != nil {
		reqQP.Set("prefix", *options.Prefix)
	}
	if options != nil && options.Marker != nil {
		reqQP.Set("marker", *options.Marker)
	}
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	if options != nil && options.Include != nil {
		reqQP.Set("include", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Include), "[]")), ","))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// listBlobFlatSegmentHandleResponse handles the ListBlobFlatSegment response.
func (client *containerClient) listBlobFlatSegmentHandleResponse(resp *http.Response) (ContainerListBlobFlatSegmentResponse, error) {
	result := ContainerListBlobFlatSegmentResponse{RawResponse: resp}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerListBlobFlatSegmentResponse{}, err
		}
		result.Date = &date
	}
	if err := runtime.UnmarshalAsXML(resp, &result.ListBlobsFlatSegmentResponse); err != nil {
		return ContainerListBlobFlatSegmentResponse{}, err
	}
	return result, nil
}

// ListBlobHierarchySegment - [Update] The List Blobs operation returns a list of the blobs under the specified container
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) ListBlobHierarchySegment(delimiter string, options *ContainerListBlobHierarchySegmentOptions) *ContainerListBlobHierarchySegmentPager {
	return &ContainerListBlobHierarchySegmentPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.listBlobHierarchySegmentCreateRequest(ctx, delimiter, options)
		},
		advancer: func(ctx context.Context, resp ContainerListBlobHierarchySegmentResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.ListBlobsHierarchySegmentResponse.NextMarker)
		},
	}
}

// listBlobHierarchySegmentCreateRequest creates the ListBlobHierarchySegment request.
func (client *containerClient) listBlobHierarchySegmentCreateRequest(ctx context.Context, delimiter string, options *ContainerListBlobHierarchySegmentOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	reqQP.Set("comp", "list")
	if options != nil && options.Prefix != nil {
		reqQP.Set("prefix", *options.Prefix)
	}
	reqQP.Set("delimiter", delimiter)
	if options != nil && options.Marker != nil {
		reqQP.Set("marker", *options.Marker)
	}
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	if options != nil && options.Include != nil {
		reqQP.Set("include", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Include), "[]")), ","))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// listBlobHierarchySegmentHandleResponse handles the ListBlobHierarchySegment response.
func (client *containerClient) listBlobHierarchySegmentHandleResponse(resp *http.Response) (ContainerListBlobHierarchySegmentResponse, error) {
	result := ContainerListBlobHierarchySegmentResponse{RawResponse: resp}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerListBlobHierarchySegmentResponse{}, err
		}
		result.Date = &date
	}
	if err := runtime.UnmarshalAsXML(resp, &result.ListBlobsHierarchySegmentResponse); err != nil {
		return ContainerListBlobHierarchySegmentResponse{}, err
	}
	return result, nil
}

// ReleaseLease - [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60 seconds, or can be infinite
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) ReleaseLease(ctx context.Context, leaseID string, containerReleaseLeaseOptions *ContainerReleaseLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (ContainerReleaseLeaseResponse, error) {
	req, err := client.releaseLeaseCreateRequest(ctx, leaseID, containerReleaseLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return ContainerReleaseLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerReleaseLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainerReleaseLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.releaseLeaseHandleResponse(resp)
}

// releaseLeaseCreateRequest creates the ReleaseLease request.
func (client *containerClient) releaseLeaseCreateRequest(ctx context.Context, leaseID string, containerReleaseLeaseOptions *ContainerReleaseLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "container")
	if containerReleaseLeaseOptions != nil && containerReleaseLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerReleaseLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "release")
	req.Raw().Header.Set("x-ms-lease-id", leaseID)
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerReleaseLeaseOptions != nil && containerReleaseLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerReleaseLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// releaseLeaseHandleResponse handles the ReleaseLease response.
func (client *containerClient) releaseLeaseHandleResponse(resp *http.Response) (ContainerReleaseLeaseResponse, error) {
	result := ContainerReleaseLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerReleaseLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerReleaseLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// RenewLease - [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60 seconds, or can be infinite
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) RenewLease(ctx context.Context, leaseID string, containerRenewLeaseOptions *ContainerRenewLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (ContainerRenewLeaseResponse, error) {
	req, err := client.renewLeaseCreateRequest(ctx, leaseID, containerRenewLeaseOptions, modifiedAccessConditions)
	if err != nil {
		return ContainerRenewLeaseResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerRenewLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainerRenewLeaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.renewLeaseHandleResponse(resp)
}

// renewLeaseCreateRequest creates the RenewLease request.
func (client *containerClient) renewLeaseCreateRequest(ctx context.Context, leaseID string, containerRenewLeaseOptions *ContainerRenewLeaseOptions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	reqQP.Set("restype", "container")
	if containerRenewLeaseOptions != nil && containerRenewLeaseOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerRenewLeaseOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-lease-action", "renew")
	req.Raw().Header.Set("x-ms-lease-id", leaseID)
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerRenewLeaseOptions != nil && containerRenewLeaseOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerRenewLeaseOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// renewLeaseHandleResponse handles the RenewLease response.
func (client *containerClient) renewLeaseHandleResponse(resp *http.Response) (ContainerRenewLeaseResponse, error) {
	result := ContainerRenewLeaseResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerRenewLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerRenewLeaseResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// Restore - Restores a previously-deleted container.
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) Restore(ctx context.Context, options *ContainerRestoreOptions) (ContainerRestoreResponse, error) {
	req, err := client.restoreCreateRequest(ctx, options)
	if err != nil {
		return ContainerRestoreResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerRestoreResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return ContainerRestoreResponse{}, runtime.NewResponseError(resp)
	}
	return client.restoreHandleResponse(resp)
}

// restoreCreateRequest creates the Restore request.
func (client *containerClient) restoreCreateRequest(ctx context.Context, options *ContainerRestoreOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	reqQP.Set("comp", "undelete")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if options != nil && options.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *options.RequestID)
	}
	if options != nil && options.DeletedContainerName != nil {
		req.Raw().Header.Set("x-ms-deleted-container-name", *options.DeletedContainerName)
	}
	if options != nil && options.DeletedContainerVersion != nil {
		req.Raw().Header.Set("x-ms-deleted-container-version", *options.DeletedContainerVersion)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// restoreHandleResponse handles the Restore response.
func (client *containerClient) restoreHandleResponse(resp *http.Response) (ContainerRestoreResponse, error) {
	result := ContainerRestoreResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerRestoreResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// SetAccessPolicy - sets the permissions for the specified container. The permissions indicate whether blobs in a container may be accessed publicly.
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) SetAccessPolicy(ctx context.Context, containerSetAccessPolicyOptions *ContainerSetAccessPolicyOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (ContainerSetAccessPolicyResponse, error) {
	req, err := client.setAccessPolicyCreateRequest(ctx, containerSetAccessPolicyOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return ContainerSetAccessPolicyResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerSetAccessPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainerSetAccessPolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.setAccessPolicyHandleResponse(resp)
}

// setAccessPolicyCreateRequest creates the SetAccessPolicy request.
func (client *containerClient) setAccessPolicyCreateRequest(ctx context.Context, containerSetAccessPolicyOptions *ContainerSetAccessPolicyOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	reqQP.Set("comp", "acl")
	if containerSetAccessPolicyOptions != nil && containerSetAccessPolicyOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerSetAccessPolicyOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if containerSetAccessPolicyOptions != nil && containerSetAccessPolicyOptions.Access != nil {
		req.Raw().Header.Set("x-ms-blob-public-access", string(*containerSetAccessPolicyOptions.Access))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerSetAccessPolicyOptions != nil && containerSetAccessPolicyOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerSetAccessPolicyOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	type wrapper struct {
		XMLName      xml.Name             `xml:"SignedIdentifiers"`
		ContainerACL *[]*SignedIdentifier `xml:"SignedIdentifier"`
	}
	if containerSetAccessPolicyOptions != nil && containerSetAccessPolicyOptions.ContainerACL != nil {
		return req, runtime.MarshalAsXML(req, wrapper{ContainerACL: &containerSetAccessPolicyOptions.ContainerACL})
	}
	return req, nil
}

// setAccessPolicyHandleResponse handles the SetAccessPolicy response.
func (client *containerClient) setAccessPolicyHandleResponse(resp *http.Response) (ContainerSetAccessPolicyResponse, error) {
	result := ContainerSetAccessPolicyResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerSetAccessPolicyResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerSetAccessPolicyResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// SetMetadata - operation sets one or more user-defined name-value pairs for the specified container.
// If the operation fails it returns the *StorageError error type.
func (client *containerClient) SetMetadata(ctx context.Context, containerSetMetadataOptions *ContainerSetMetadataOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (ContainerSetMetadataResponse, error) {
	req, err := client.setMetadataCreateRequest(ctx, containerSetMetadataOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return ContainerSetMetadataResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return ContainerSetMetadataResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ContainerSetMetadataResponse{}, runtime.NewResponseError(resp)
	}
	return client.setMetadataHandleResponse(resp)
}

// setMetadataCreateRequest creates the SetMetadata request.
func (client *containerClient) setMetadataCreateRequest(ctx context.Context, containerSetMetadataOptions *ContainerSetMetadataOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "container")
	reqQP.Set("comp", "metadata")
	if containerSetMetadataOptions != nil && containerSetMetadataOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*containerSetMetadataOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if containerSetMetadataOptions != nil && containerSetMetadataOptions.Metadata != nil {
		for k, v := range containerSetMetadataOptions.Metadata {
			req.Raw().Header.Set("x-ms-meta-"+k, v)
		}
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if containerSetMetadataOptions != nil && containerSetMetadataOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *containerSetMetadataOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// setMetadataHandleResponse handles the SetMetadata response.
func (client *containerClient) setMetadataHandleResponse(resp *http.Response) (ContainerSetMetadataResponse, error) {
	result := ContainerSetMetadataResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerSetMetadataResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return ContainerSetMetadataResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}
