package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateConfigSetting invokes the webplus.ValidateConfigSetting API synchronously
// api document: https://help.aliyun.com/api/webplus/validateconfigsetting.html
func (client *Client) ValidateConfigSetting(request *ValidateConfigSettingRequest) (response *ValidateConfigSettingResponse, err error) {
	response = CreateValidateConfigSettingResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateConfigSettingWithChan invokes the webplus.ValidateConfigSetting API asynchronously
// api document: https://help.aliyun.com/api/webplus/validateconfigsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateConfigSettingWithChan(request *ValidateConfigSettingRequest) (<-chan *ValidateConfigSettingResponse, <-chan error) {
	responseChan := make(chan *ValidateConfigSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateConfigSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateConfigSettingWithCallback invokes the webplus.ValidateConfigSetting API asynchronously
// api document: https://help.aliyun.com/api/webplus/validateconfigsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateConfigSettingWithCallback(request *ValidateConfigSettingRequest, callback func(response *ValidateConfigSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateConfigSettingResponse
		var err error
		defer close(result)
		response, err = client.ValidateConfigSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateConfigSettingRequest is the request struct for api ValidateConfigSetting
type ValidateConfigSettingRequest struct {
	*requests.RoaRequest
	OptionSettings string `position:"Body" name:"OptionSettings"`
	StackId        string `position:"Body" name:"StackId"`
	EnvId          string `position:"Body" name:"EnvId"`
	TemplateId     string `position:"Body" name:"TemplateId"`
}

// ValidateConfigSettingResponse is the response struct for api ValidateConfigSetting
type ValidateConfigSettingResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	Code                    string                  `json:"Code" xml:"Code"`
	Message                 string                  `json:"Message" xml:"Message"`
	ConfigValidationResults ConfigValidationResults `json:"ConfigValidationResults" xml:"ConfigValidationResults"`
}

// CreateValidateConfigSettingRequest creates a request to invoke ValidateConfigSetting API
func CreateValidateConfigSettingRequest() (request *ValidateConfigSettingRequest) {
	request = &ValidateConfigSettingRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "ValidateConfigSetting", "/pop/v1/wam/config/configSetting/validate", "", "")
	request.Method = requests.POST
	return
}

// CreateValidateConfigSettingResponse creates a response to parse from ValidateConfigSetting response
func CreateValidateConfigSettingResponse() (response *ValidateConfigSettingResponse) {
	response = &ValidateConfigSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
