package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PauseChange invokes the webplus.PauseChange API synchronously
// api document: https://help.aliyun.com/api/webplus/pausechange.html
func (client *Client) PauseChange(request *PauseChangeRequest) (response *PauseChangeResponse, err error) {
	response = CreatePauseChangeResponse()
	err = client.DoAction(request, response)
	return
}

// PauseChangeWithChan invokes the webplus.PauseChange API asynchronously
// api document: https://help.aliyun.com/api/webplus/pausechange.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PauseChangeWithChan(request *PauseChangeRequest) (<-chan *PauseChangeResponse, <-chan error) {
	responseChan := make(chan *PauseChangeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PauseChange(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PauseChangeWithCallback invokes the webplus.PauseChange API asynchronously
// api document: https://help.aliyun.com/api/webplus/pausechange.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PauseChangeWithCallback(request *PauseChangeRequest, callback func(response *PauseChangeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PauseChangeResponse
		var err error
		defer close(result)
		response, err = client.PauseChange(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PauseChangeRequest is the request struct for api PauseChange
type PauseChangeRequest struct {
	*requests.RoaRequest
	ChangeId string `position:"Body" name:"ChangeId"`
}

// PauseChangeResponse is the response struct for api PauseChange
type PauseChangeResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Code      string    `json:"Code" xml:"Code"`
	Message   string    `json:"Message" xml:"Message"`
	EnvChange EnvChange `json:"EnvChange" xml:"EnvChange"`
}

// CreatePauseChangeRequest creates a request to invoke PauseChange API
func CreatePauseChangeRequest() (request *PauseChangeRequest) {
	request = &PauseChangeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "PauseChange", "/pop/v1/wam/change/pause", "", "")
	request.Method = requests.POST
	return
}

// CreatePauseChangeResponse creates a response to parse from PauseChange response
func CreatePauseChangeResponse() (response *PauseChangeResponse) {
	response = &PauseChangeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
