package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStatisticalData invokes the voicenavigator.DescribeStatisticalData API synchronously
func (client *Client) DescribeStatisticalData(request *DescribeStatisticalDataRequest) (response *DescribeStatisticalDataResponse, err error) {
	response = CreateDescribeStatisticalDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStatisticalDataWithChan invokes the voicenavigator.DescribeStatisticalData API asynchronously
func (client *Client) DescribeStatisticalDataWithChan(request *DescribeStatisticalDataRequest) (<-chan *DescribeStatisticalDataResponse, <-chan error) {
	responseChan := make(chan *DescribeStatisticalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStatisticalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStatisticalDataWithCallback invokes the voicenavigator.DescribeStatisticalData API asynchronously
func (client *Client) DescribeStatisticalDataWithCallback(request *DescribeStatisticalDataRequest, callback func(response *DescribeStatisticalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStatisticalDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeStatisticalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStatisticalDataRequest is the request struct for api DescribeStatisticalData
type DescribeStatisticalDataRequest struct {
	*requests.RpcRequest
	BeginTimeLeftRange  requests.Integer `position:"Query" name:"BeginTimeLeftRange"`
	TimeUnit            string           `position:"Query" name:"TimeUnit"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
	BeginTimeRightRange requests.Integer `position:"Query" name:"BeginTimeRightRange"`
}

// DescribeStatisticalDataResponse is the response struct for api DescribeStatisticalData
type DescribeStatisticalDataResponse struct {
	*responses.BaseResponse
	TotalDialoguePassRate    string                  `json:"TotalDialoguePassRate" xml:"TotalDialoguePassRate"`
	TotalKnowledgeHitRate    string                  `json:"TotalKnowledgeHitRate" xml:"TotalKnowledgeHitRate"`
	TotalResolutionRate      string                  `json:"TotalResolutionRate" xml:"TotalResolutionRate"`
	TotalValidAnswerRate     string                  `json:"TotalValidAnswerRate" xml:"TotalValidAnswerRate"`
	RequestId                string                  `json:"RequestId" xml:"RequestId"`
	ResolvedQuestionTotalNum int64                   `json:"ResolvedQuestionTotalNum" xml:"ResolvedQuestionTotalNum"`
	ConversationTotalNum     int64                   `json:"ConversationTotalNum" xml:"ConversationTotalNum"`
	StatisticalDataReports   []StatisticalDataReport `json:"StatisticalDataReports" xml:"StatisticalDataReports"`
}

// CreateDescribeStatisticalDataRequest creates a request to invoke DescribeStatisticalData API
func CreateDescribeStatisticalDataRequest() (request *DescribeStatisticalDataRequest) {
	request = &DescribeStatisticalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "DescribeStatisticalData", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeStatisticalDataResponse creates a response to parse from DescribeStatisticalData response
func CreateDescribeStatisticalDataResponse() (response *DescribeStatisticalDataResponse) {
	response = &DescribeStatisticalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
