package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeTenantStatus invokes the unimkt.ChangeTenantStatus API synchronously
func (client *Client) ChangeTenantStatus(request *ChangeTenantStatusRequest) (response *ChangeTenantStatusResponse, err error) {
	response = CreateChangeTenantStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeTenantStatusWithChan invokes the unimkt.ChangeTenantStatus API asynchronously
func (client *Client) ChangeTenantStatusWithChan(request *ChangeTenantStatusRequest) (<-chan *ChangeTenantStatusResponse, <-chan error) {
	responseChan := make(chan *ChangeTenantStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeTenantStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeTenantStatusWithCallback invokes the unimkt.ChangeTenantStatus API asynchronously
func (client *Client) ChangeTenantStatusWithCallback(request *ChangeTenantStatusRequest, callback func(response *ChangeTenantStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeTenantStatusResponse
		var err error
		defer close(result)
		response, err = client.ChangeTenantStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeTenantStatusRequest is the request struct for api ChangeTenantStatus
type ChangeTenantStatusRequest struct {
	*requests.RpcRequest
	MessageKey       string `position:"Body" name:"MessageKey"`
	Business         string `position:"Query" name:"Business"`
	Message          string `position:"Body" name:"Message"`
	UserId           string `position:"Query" name:"UserId"`
	OriginSiteUserId string `position:"Query" name:"OriginSiteUserId"`
	Environment      string `position:"Query" name:"Environment"`
	AppName          string `position:"Query" name:"AppName"`
	TenantId         string `position:"Query" name:"TenantId"`
	UserSite         string `position:"Query" name:"UserSite"`
	Status           string `position:"Body" name:"Status"`
}

// ChangeTenantStatusResponse is the response struct for api ChangeTenantStatus
type ChangeTenantStatusResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateChangeTenantStatusRequest creates a request to invoke ChangeTenantStatus API
func CreateChangeTenantStatusRequest() (request *ChangeTenantStatusRequest) {
	request = &ChangeTenantStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "ChangeTenantStatus", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeTenantStatusResponse creates a response to parse from ChangeTenantStatus response
func CreateChangeTenantStatusResponse() (response *ChangeTenantStatusResponse) {
	response = &ChangeTenantStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
