package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSmartAGDpiAttribute invokes the smartag.UpdateSmartAGDpiAttribute API synchronously
func (client *Client) UpdateSmartAGDpiAttribute(request *UpdateSmartAGDpiAttributeRequest) (response *UpdateSmartAGDpiAttributeResponse, err error) {
	response = CreateUpdateSmartAGDpiAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSmartAGDpiAttributeWithChan invokes the smartag.UpdateSmartAGDpiAttribute API asynchronously
func (client *Client) UpdateSmartAGDpiAttributeWithChan(request *UpdateSmartAGDpiAttributeRequest) (<-chan *UpdateSmartAGDpiAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateSmartAGDpiAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSmartAGDpiAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSmartAGDpiAttributeWithCallback invokes the smartag.UpdateSmartAGDpiAttribute API asynchronously
func (client *Client) UpdateSmartAGDpiAttributeWithCallback(request *UpdateSmartAGDpiAttributeRequest, callback func(response *UpdateSmartAGDpiAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSmartAGDpiAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateSmartAGDpiAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSmartAGDpiAttributeRequest is the request struct for api UpdateSmartAGDpiAttribute
type UpdateSmartAGDpiAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DpiEnabled           requests.Boolean `position:"Query" name:"DpiEnabled"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// UpdateSmartAGDpiAttributeResponse is the response struct for api UpdateSmartAGDpiAttribute
type UpdateSmartAGDpiAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateSmartAGDpiAttributeRequest creates a request to invoke UpdateSmartAGDpiAttribute API
func CreateUpdateSmartAGDpiAttributeRequest() (request *UpdateSmartAGDpiAttributeRequest) {
	request = &UpdateSmartAGDpiAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "UpdateSmartAGDpiAttribute", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSmartAGDpiAttributeResponse creates a response to parse from UpdateSmartAGDpiAttribute response
func CreateUpdateSmartAGDpiAttributeResponse() (response *UpdateSmartAGDpiAttributeResponse) {
	response = &UpdateSmartAGDpiAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
