package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSmartAGAccessPoint invokes the smartag.UpdateSmartAGAccessPoint API synchronously
func (client *Client) UpdateSmartAGAccessPoint(request *UpdateSmartAGAccessPointRequest) (response *UpdateSmartAGAccessPointResponse, err error) {
	response = CreateUpdateSmartAGAccessPointResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSmartAGAccessPointWithChan invokes the smartag.UpdateSmartAGAccessPoint API asynchronously
func (client *Client) UpdateSmartAGAccessPointWithChan(request *UpdateSmartAGAccessPointRequest) (<-chan *UpdateSmartAGAccessPointResponse, <-chan error) {
	responseChan := make(chan *UpdateSmartAGAccessPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSmartAGAccessPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSmartAGAccessPointWithCallback invokes the smartag.UpdateSmartAGAccessPoint API asynchronously
func (client *Client) UpdateSmartAGAccessPointWithCallback(request *UpdateSmartAGAccessPointRequest, callback func(response *UpdateSmartAGAccessPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSmartAGAccessPointResponse
		var err error
		defer close(result)
		response, err = client.UpdateSmartAGAccessPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSmartAGAccessPointRequest is the request struct for api UpdateSmartAGAccessPoint
type UpdateSmartAGAccessPointRequest struct {
	*requests.RpcRequest
	AccessPointId        requests.Integer `position:"Query" name:"AccessPointId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// UpdateSmartAGAccessPointResponse is the response struct for api UpdateSmartAGAccessPoint
type UpdateSmartAGAccessPointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateSmartAGAccessPointRequest creates a request to invoke UpdateSmartAGAccessPoint API
func CreateUpdateSmartAGAccessPointRequest() (request *UpdateSmartAGAccessPointRequest) {
	request = &UpdateSmartAGAccessPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "UpdateSmartAGAccessPoint", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSmartAGAccessPointResponse creates a response to parse from UpdateSmartAGAccessPoint response
func CreateUpdateSmartAGAccessPointResponse() (response *UpdateSmartAGAccessPointResponse) {
	response = &UpdateSmartAGAccessPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
