package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWorkflowInstance invokes the schedulerx2.GetWorkflowInstance API synchronously
func (client *Client) GetWorkflowInstance(request *GetWorkflowInstanceRequest) (response *GetWorkflowInstanceResponse, err error) {
	response = CreateGetWorkflowInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// GetWorkflowInstanceWithChan invokes the schedulerx2.GetWorkflowInstance API asynchronously
func (client *Client) GetWorkflowInstanceWithChan(request *GetWorkflowInstanceRequest) (<-chan *GetWorkflowInstanceResponse, <-chan error) {
	responseChan := make(chan *GetWorkflowInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWorkflowInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWorkflowInstanceWithCallback invokes the schedulerx2.GetWorkflowInstance API asynchronously
func (client *Client) GetWorkflowInstanceWithCallback(request *GetWorkflowInstanceRequest, callback func(response *GetWorkflowInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWorkflowInstanceResponse
		var err error
		defer close(result)
		response, err = client.GetWorkflowInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWorkflowInstanceRequest is the request struct for api GetWorkflowInstance
type GetWorkflowInstanceRequest struct {
	*requests.RpcRequest
	NamespaceSource string           `position:"Query" name:"NamespaceSource"`
	GroupId         string           `position:"Query" name:"GroupId"`
	WfInstanceId    requests.Integer `position:"Query" name:"WfInstanceId"`
	Namespace       string           `position:"Query" name:"Namespace"`
	WorkflowId      requests.Integer `position:"Query" name:"WorkflowId"`
}

// GetWorkflowInstanceResponse is the response struct for api GetWorkflowInstance
type GetWorkflowInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetWorkflowInstanceRequest creates a request to invoke GetWorkflowInstance API
func CreateGetWorkflowInstanceRequest() (request *GetWorkflowInstanceRequest) {
	request = &GetWorkflowInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "GetWorkflowInstance", "", "")
	request.Method = requests.GET
	return
}

// CreateGetWorkflowInstanceResponse creates a response to parse from GetWorkflowInstance response
func CreateGetWorkflowInstanceResponse() (response *GetWorkflowInstanceResponse) {
	response = &GetWorkflowInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
