package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHoneyPotSuspStatistics invokes the sas.DescribeHoneyPotSuspStatistics API synchronously
func (client *Client) DescribeHoneyPotSuspStatistics(request *DescribeHoneyPotSuspStatisticsRequest) (response *DescribeHoneyPotSuspStatisticsResponse, err error) {
	response = CreateDescribeHoneyPotSuspStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHoneyPotSuspStatisticsWithChan invokes the sas.DescribeHoneyPotSuspStatistics API asynchronously
func (client *Client) DescribeHoneyPotSuspStatisticsWithChan(request *DescribeHoneyPotSuspStatisticsRequest) (<-chan *DescribeHoneyPotSuspStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeHoneyPotSuspStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHoneyPotSuspStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHoneyPotSuspStatisticsWithCallback invokes the sas.DescribeHoneyPotSuspStatistics API asynchronously
func (client *Client) DescribeHoneyPotSuspStatisticsWithCallback(request *DescribeHoneyPotSuspStatisticsRequest, callback func(response *DescribeHoneyPotSuspStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHoneyPotSuspStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeHoneyPotSuspStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHoneyPotSuspStatisticsRequest is the request struct for api DescribeHoneyPotSuspStatistics
type DescribeHoneyPotSuspStatisticsRequest struct {
	*requests.RpcRequest
	StatisticsDays    requests.Integer `position:"Query" name:"StatisticsDays"`
	StatisticsKeyType string           `position:"Query" name:"StatisticsKeyType"`
	SourceIp          string           `position:"Query" name:"SourceIp"`
	From              string           `position:"Query" name:"From"`
}

// DescribeHoneyPotSuspStatisticsResponse is the response struct for api DescribeHoneyPotSuspStatistics
type DescribeHoneyPotSuspStatisticsResponse struct {
	*responses.BaseResponse
	RequestId                      string                               `json:"RequestId" xml:"RequestId"`
	SuspHoneyPotStatisticsResponse []SuspHoneyPotStatisticsResponseItem `json:"SuspHoneyPotStatisticsResponse" xml:"SuspHoneyPotStatisticsResponse"`
}

// CreateDescribeHoneyPotSuspStatisticsRequest creates a request to invoke DescribeHoneyPotSuspStatistics API
func CreateDescribeHoneyPotSuspStatisticsRequest() (request *DescribeHoneyPotSuspStatisticsRequest) {
	request = &DescribeHoneyPotSuspStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeHoneyPotSuspStatistics", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHoneyPotSuspStatisticsResponse creates a response to parse from DescribeHoneyPotSuspStatistics response
func CreateDescribeHoneyPotSuspStatisticsResponse() (response *DescribeHoneyPotSuspStatisticsResponse) {
	response = &DescribeHoneyPotSuspStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
