package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGADInstance invokes the rds.CreateGADInstance API synchronously
func (client *Client) CreateGADInstance(request *CreateGADInstanceRequest) (response *CreateGADInstanceResponse, err error) {
	response = CreateCreateGADInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGADInstanceWithChan invokes the rds.CreateGADInstance API asynchronously
func (client *Client) CreateGADInstanceWithChan(request *CreateGADInstanceRequest) (<-chan *CreateGADInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateGADInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGADInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGADInstanceWithCallback invokes the rds.CreateGADInstance API asynchronously
func (client *Client) CreateGADInstanceWithCallback(request *CreateGADInstanceRequest, callback func(response *CreateGADInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGADInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateGADInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGADInstanceRequest is the request struct for api CreateGADInstance
type CreateGADInstanceRequest struct {
	*requests.RpcRequest
	Description                string                       `position:"Query" name:"Description"`
	CentralRdsDtsAdminAccount  string                       `position:"Query" name:"CentralRdsDtsAdminAccount"`
	CentralRegionId            string                       `position:"Query" name:"CentralRegionId"`
	ResourceGroupId            string                       `position:"Query" name:"ResourceGroupId"`
	Tag                        *[]CreateGADInstanceTag      `position:"Query" name:"Tag"  type:"Repeated"`
	UnitNode                   *[]CreateGADInstanceUnitNode `position:"Query" name:"UnitNode"  type:"Repeated"`
	DBList                     string                       `position:"Query" name:"DBList"`
	CentralDBInstanceId        string                       `position:"Query" name:"CentralDBInstanceId"`
	CentralRdsDtsAdminPassword string                       `position:"Query" name:"CentralRdsDtsAdminPassword"`
}

// CreateGADInstanceTag is a repeated param struct in CreateGADInstanceRequest
type CreateGADInstanceTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateGADInstanceUnitNode is a repeated param struct in CreateGADInstanceRequest
type CreateGADInstanceUnitNode struct {
	DBInstanceStorage     string `name:"DBInstanceStorage"`
	ZoneIDSlave1          string `name:"ZoneIDSlave1"`
	ZoneIDSlave2          string `name:"ZoneIDSlave2"`
	EngineVersion         string `name:"EngineVersion"`
	DbInstanceClass       string `name:"DbInstanceClass"`
	SecurityIPList        string `name:"SecurityIPList"`
	VSwitchID             string `name:"VSwitchID"`
	RegionID              string `name:"RegionID"`
	Engine                string `name:"Engine"`
	DtsInstanceClass      string `name:"DtsInstanceClass"`
	VpcID                 string `name:"VpcID"`
	ZoneID                string `name:"ZoneID"`
	DBInstanceDescription string `name:"DBInstanceDescription"`
	PayType               string `name:"PayType"`
	DtsConflict           string `name:"DtsConflict"`
}

// CreateGADInstanceResponse is the response struct for api CreateGADInstance
type CreateGADInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateGADInstanceRequest creates a request to invoke CreateGADInstance API
func CreateCreateGADInstanceRequest() (request *CreateGADInstanceRequest) {
	request = &CreateGADInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateGADInstance", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGADInstanceResponse creates a response to parse from CreateGADInstance response
func CreateCreateGADInstanceResponse() (response *CreateGADInstanceResponse) {
	response = &CreateGADInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
