package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQuotaApplication invokes the quotas.GetQuotaApplication API synchronously
func (client *Client) GetQuotaApplication(request *GetQuotaApplicationRequest) (response *GetQuotaApplicationResponse, err error) {
	response = CreateGetQuotaApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// GetQuotaApplicationWithChan invokes the quotas.GetQuotaApplication API asynchronously
func (client *Client) GetQuotaApplicationWithChan(request *GetQuotaApplicationRequest) (<-chan *GetQuotaApplicationResponse, <-chan error) {
	responseChan := make(chan *GetQuotaApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQuotaApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQuotaApplicationWithCallback invokes the quotas.GetQuotaApplication API asynchronously
func (client *Client) GetQuotaApplicationWithCallback(request *GetQuotaApplicationRequest, callback func(response *GetQuotaApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQuotaApplicationResponse
		var err error
		defer close(result)
		response, err = client.GetQuotaApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQuotaApplicationRequest is the request struct for api GetQuotaApplication
type GetQuotaApplicationRequest struct {
	*requests.RpcRequest
	OriginalContext string `position:"Body" name:"OriginalContext"`
	ApplicationId   string `position:"Body" name:"ApplicationId"`
}

// GetQuotaApplicationResponse is the response struct for api GetQuotaApplication
type GetQuotaApplicationResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	QuotaApplication QuotaApplication `json:"QuotaApplication" xml:"QuotaApplication"`
}

// CreateGetQuotaApplicationRequest creates a request to invoke GetQuotaApplication API
func CreateGetQuotaApplicationRequest() (request *GetQuotaApplicationRequest) {
	request = &GetQuotaApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "GetQuotaApplication", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetQuotaApplicationResponse creates a response to parse from GetQuotaApplication response
func CreateGetQuotaApplicationResponse() (response *GetQuotaApplicationResponse) {
	response = &GetQuotaApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
