package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBClusterSSL invokes the polardb.ModifyDBClusterSSL API synchronously
func (client *Client) ModifyDBClusterSSL(request *ModifyDBClusterSSLRequest) (response *ModifyDBClusterSSLResponse, err error) {
	response = CreateModifyDBClusterSSLResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBClusterSSLWithChan invokes the polardb.ModifyDBClusterSSL API asynchronously
func (client *Client) ModifyDBClusterSSLWithChan(request *ModifyDBClusterSSLRequest) (<-chan *ModifyDBClusterSSLResponse, <-chan error) {
	responseChan := make(chan *ModifyDBClusterSSLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBClusterSSL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBClusterSSLWithCallback invokes the polardb.ModifyDBClusterSSL API asynchronously
func (client *Client) ModifyDBClusterSSLWithCallback(request *ModifyDBClusterSSLRequest, callback func(response *ModifyDBClusterSSLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBClusterSSLResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBClusterSSL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBClusterSSLRequest is the request struct for api ModifyDBClusterSSL
type ModifyDBClusterSSLRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBEndpointId         string           `position:"Query" name:"DBEndpointId"`
	SSLAutoRotate        string           `position:"Query" name:"SSLAutoRotate"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NetType              string           `position:"Query" name:"NetType"`
	SSLEnabled           string           `position:"Query" name:"SSLEnabled"`
}

// ModifyDBClusterSSLResponse is the response struct for api ModifyDBClusterSSL
type ModifyDBClusterSSLResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBClusterSSLRequest creates a request to invoke ModifyDBClusterSSL API
func CreateModifyDBClusterSSLRequest() (request *ModifyDBClusterSSLRequest) {
	request = &ModifyDBClusterSSLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ModifyDBClusterSSL", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBClusterSSLResponse creates a response to parse from ModifyDBClusterSSL response
func CreateModifyDBClusterSSLResponse() (response *ModifyDBClusterSSLResponse) {
	response = &ModifyDBClusterSSLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
