package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateApplication invokes the oos.UpdateApplication API synchronously
func (client *Client) UpdateApplication(request *UpdateApplicationRequest) (response *UpdateApplicationResponse, err error) {
	response = CreateUpdateApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateApplicationWithChan invokes the oos.UpdateApplication API asynchronously
func (client *Client) UpdateApplicationWithChan(request *UpdateApplicationRequest) (<-chan *UpdateApplicationResponse, <-chan error) {
	responseChan := make(chan *UpdateApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateApplicationWithCallback invokes the oos.UpdateApplication API asynchronously
func (client *Client) UpdateApplicationWithCallback(request *UpdateApplicationRequest, callback func(response *UpdateApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateApplicationResponse
		var err error
		defer close(result)
		response, err = client.UpdateApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateApplicationRequest is the request struct for api UpdateApplication
type UpdateApplicationRequest struct {
	*requests.RpcRequest
	Description string            `position:"Query" name:"Description"`
	Tags        map[string]string `position:"Query" name:"Tags"  type:"Map"`
	Name        string            `position:"Query" name:"Name"`
}

// UpdateApplicationResponse is the response struct for api UpdateApplication
type UpdateApplicationResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Application Application `json:"Application" xml:"Application"`
}

// CreateUpdateApplicationRequest creates a request to invoke UpdateApplication API
func CreateUpdateApplicationRequest() (request *UpdateApplicationRequest) {
	request = &UpdateApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "UpdateApplication", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateApplicationResponse creates a response to parse from UpdateApplication response
func CreateUpdateApplicationResponse() (response *UpdateApplicationResponse) {
	response = &UpdateApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
