package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeTakeoutOrder invokes the ocr.RecognizeTakeoutOrder API synchronously
func (client *Client) RecognizeTakeoutOrder(request *RecognizeTakeoutOrderRequest) (response *RecognizeTakeoutOrderResponse, err error) {
	response = CreateRecognizeTakeoutOrderResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeTakeoutOrderWithChan invokes the ocr.RecognizeTakeoutOrder API asynchronously
func (client *Client) RecognizeTakeoutOrderWithChan(request *RecognizeTakeoutOrderRequest) (<-chan *RecognizeTakeoutOrderResponse, <-chan error) {
	responseChan := make(chan *RecognizeTakeoutOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeTakeoutOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeTakeoutOrderWithCallback invokes the ocr.RecognizeTakeoutOrder API asynchronously
func (client *Client) RecognizeTakeoutOrderWithCallback(request *RecognizeTakeoutOrderRequest, callback func(response *RecognizeTakeoutOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeTakeoutOrderResponse
		var err error
		defer close(result)
		response, err = client.RecognizeTakeoutOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeTakeoutOrderRequest is the request struct for api RecognizeTakeoutOrder
type RecognizeTakeoutOrderRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// RecognizeTakeoutOrderResponse is the response struct for api RecognizeTakeoutOrder
type RecognizeTakeoutOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeTakeoutOrderRequest creates a request to invoke RecognizeTakeoutOrder API
func CreateRecognizeTakeoutOrderRequest() (request *RecognizeTakeoutOrderRequest) {
	request = &RecognizeTakeoutOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeTakeoutOrder", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeTakeoutOrderResponse creates a response to parse from RecognizeTakeoutOrder response
func CreateRecognizeTakeoutOrderResponse() (response *RecognizeTakeoutOrderResponse) {
	response = &RecognizeTakeoutOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
