package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeQuotaInvoice invokes the ocr.RecognizeQuotaInvoice API synchronously
func (client *Client) RecognizeQuotaInvoice(request *RecognizeQuotaInvoiceRequest) (response *RecognizeQuotaInvoiceResponse, err error) {
	response = CreateRecognizeQuotaInvoiceResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeQuotaInvoiceWithChan invokes the ocr.RecognizeQuotaInvoice API asynchronously
func (client *Client) RecognizeQuotaInvoiceWithChan(request *RecognizeQuotaInvoiceRequest) (<-chan *RecognizeQuotaInvoiceResponse, <-chan error) {
	responseChan := make(chan *RecognizeQuotaInvoiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeQuotaInvoice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeQuotaInvoiceWithCallback invokes the ocr.RecognizeQuotaInvoice API asynchronously
func (client *Client) RecognizeQuotaInvoiceWithCallback(request *RecognizeQuotaInvoiceRequest, callback func(response *RecognizeQuotaInvoiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeQuotaInvoiceResponse
		var err error
		defer close(result)
		response, err = client.RecognizeQuotaInvoice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeQuotaInvoiceRequest is the request struct for api RecognizeQuotaInvoice
type RecognizeQuotaInvoiceRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// RecognizeQuotaInvoiceResponse is the response struct for api RecognizeQuotaInvoice
type RecognizeQuotaInvoiceResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Code      string                      `json:"Code" xml:"Code"`
	Message   string                      `json:"Message" xml:"Message"`
	Data      DataInRecognizeQuotaInvoice `json:"Data" xml:"Data"`
}

// CreateRecognizeQuotaInvoiceRequest creates a request to invoke RecognizeQuotaInvoice API
func CreateRecognizeQuotaInvoiceRequest() (request *RecognizeQuotaInvoiceRequest) {
	request = &RecognizeQuotaInvoiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeQuotaInvoice", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeQuotaInvoiceResponse creates a response to parse from RecognizeQuotaInvoice response
func CreateRecognizeQuotaInvoiceResponse() (response *RecognizeQuotaInvoiceResponse) {
	response = &RecognizeQuotaInvoiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
