package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantZonesRead invokes the oceanbasepro.DescribeTenantZonesRead API synchronously
func (client *Client) DescribeTenantZonesRead(request *DescribeTenantZonesReadRequest) (response *DescribeTenantZonesReadResponse, err error) {
	response = CreateDescribeTenantZonesReadResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantZonesReadWithChan invokes the oceanbasepro.DescribeTenantZonesRead API asynchronously
func (client *Client) DescribeTenantZonesReadWithChan(request *DescribeTenantZonesReadRequest) (<-chan *DescribeTenantZonesReadResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantZonesReadResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantZonesRead(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantZonesReadWithCallback invokes the oceanbasepro.DescribeTenantZonesRead API asynchronously
func (client *Client) DescribeTenantZonesReadWithCallback(request *DescribeTenantZonesReadRequest, callback func(response *DescribeTenantZonesReadResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantZonesReadResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantZonesRead(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantZonesReadRequest is the request struct for api DescribeTenantZonesRead
type DescribeTenantZonesReadRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
}

// DescribeTenantZonesReadResponse is the response struct for api DescribeTenantZonesRead
type DescribeTenantZonesReadResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	TenantZones []TenantZonesItem `json:"TenantZones" xml:"TenantZones"`
}

// CreateDescribeTenantZonesReadRequest creates a request to invoke DescribeTenantZonesRead API
func CreateDescribeTenantZonesReadRequest() (request *DescribeTenantZonesReadRequest) {
	request = &DescribeTenantZonesReadRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTenantZonesRead", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantZonesReadResponse creates a response to parse from DescribeTenantZonesRead response
func CreateDescribeTenantZonesReadResponse() (response *DescribeTenantZonesReadResponse) {
	response = &DescribeTenantZonesReadResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
