package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOmsOpenAPIProject invokes the oceanbasepro.CreateOmsOpenAPIProject API synchronously
func (client *Client) CreateOmsOpenAPIProject(request *CreateOmsOpenAPIProjectRequest) (response *CreateOmsOpenAPIProjectResponse, err error) {
	response = CreateCreateOmsOpenAPIProjectResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOmsOpenAPIProjectWithChan invokes the oceanbasepro.CreateOmsOpenAPIProject API asynchronously
func (client *Client) CreateOmsOpenAPIProjectWithChan(request *CreateOmsOpenAPIProjectRequest) (<-chan *CreateOmsOpenAPIProjectResponse, <-chan error) {
	responseChan := make(chan *CreateOmsOpenAPIProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOmsOpenAPIProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOmsOpenAPIProjectWithCallback invokes the oceanbasepro.CreateOmsOpenAPIProject API asynchronously
func (client *Client) CreateOmsOpenAPIProjectWithCallback(request *CreateOmsOpenAPIProjectRequest, callback func(response *CreateOmsOpenAPIProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOmsOpenAPIProjectResponse
		var err error
		defer close(result)
		response, err = client.CreateOmsOpenAPIProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOmsOpenAPIProjectRequest is the request struct for api CreateOmsOpenAPIProject
type CreateOmsOpenAPIProjectRequest struct {
	*requests.RpcRequest
	DestConfig         CreateOmsOpenAPIProjectDestConfig         `position:"Body" name:"DestConfig"  type:"Struct"`
	PageNumber         requests.Integer                          `position:"Body" name:"PageNumber"`
	PageSize           requests.Integer                          `position:"Body" name:"PageSize"`
	TransferMapping    CreateOmsOpenAPIProjectTransferMapping    `position:"Body" name:"TransferMapping"  type:"Struct"`
	TransferStepConfig CreateOmsOpenAPIProjectTransferStepConfig `position:"Body" name:"TransferStepConfig"  type:"Struct"`
	WorkerGradeId      string                                    `position:"Body" name:"WorkerGradeId"`
	ProjectName        string                                    `position:"Body" name:"ProjectName"`
	SourceConfig       CreateOmsOpenAPIProjectSourceConfig       `position:"Body" name:"SourceConfig"  type:"Struct"`
	BusinessName       string                                    `position:"Body" name:"BusinessName"`
	LabelIds           *[]string                                 `position:"Body" name:"LabelIds"  type:"Json"`
}

// CreateOmsOpenAPIProjectDestConfig is a repeated param struct in CreateOmsOpenAPIProjectRequest
type CreateOmsOpenAPIProjectDestConfig struct {
	SendMsgTimeout         string `name:"SendMsgTimeout"`
	SequenceStartTimestamp string `name:"SequenceStartTimestamp"`
	Partition              string `name:"Partition"`
	SerializerType         string `name:"SerializerType"`
	EndpointType           string `name:"EndpointType"`
	EndpointId             string `name:"EndpointId"`
	SequenceEnable         string `name:"SequenceEnable"`
	PartitionMode          string `name:"PartitionMode"`
	EnableMsgTrace         string `name:"EnableMsgTrace"`
	TopicType              string `name:"TopicType"`
	MsgTags                string `name:"MsgTags"`
	ProducerGroup          string `name:"ProducerGroup"`
}

// CreateOmsOpenAPIProjectTransferMapping is a repeated param struct in CreateOmsOpenAPIProjectRequest
type CreateOmsOpenAPIProjectTransferMapping struct {
	Mode      string                                                 `name:"Mode"`
	Databases *[]CreateOmsOpenAPIProjectTransferMappingDatabasesItem `name:"Databases" type:"Repeated"`
}

// CreateOmsOpenAPIProjectTransferStepConfig is a repeated param struct in CreateOmsOpenAPIProjectRequest
type CreateOmsOpenAPIProjectTransferStepConfig struct {
	IncrSyncStepTransferConfig CreateOmsOpenAPIProjectTransferStepConfigIncrSyncStepTransferConfig `name:"IncrSyncStepTransferConfig" type:"Struct"`
	EnableFullSync             string                                                              `name:"EnableFullSync"`
	EnableIncrSync             string                                                              `name:"EnableIncrSync"`
	EnableStructSync           string                                                              `name:"EnableStructSync"`
}

// CreateOmsOpenAPIProjectSourceConfig is a repeated param struct in CreateOmsOpenAPIProjectRequest
type CreateOmsOpenAPIProjectSourceConfig struct {
	SendMsgTimeout         string `name:"SendMsgTimeout"`
	SequenceStartTimestamp string `name:"SequenceStartTimestamp"`
	Partition              string `name:"Partition"`
	SerializerType         string `name:"SerializerType"`
	EndpointType           string `name:"EndpointType"`
	EndpointId             string `name:"EndpointId"`
	SequenceEnable         string `name:"SequenceEnable"`
	PartitionMode          string `name:"PartitionMode"`
	EnableMsgTrace         string `name:"EnableMsgTrace"`
	TopicType              string `name:"TopicType"`
	MsgTags                string `name:"MsgTags"`
	ProducerGroup          string `name:"ProducerGroup"`
}

// CreateOmsOpenAPIProjectTransferMappingDatabasesItem is a repeated param struct in CreateOmsOpenAPIProjectRequest
type CreateOmsOpenAPIProjectTransferMappingDatabasesItem struct {
	MappedName   string                                                           `name:"MappedName"`
	Tables       *[]CreateOmsOpenAPIProjectTransferMappingDatabasesItemTablesItem `name:"Tables" type:"Repeated"`
	DatabaseName string                                                           `name:"DatabaseName"`
	TenantName   string                                                           `name:"TenantName"`
	DatabaseId   string                                                           `name:"DatabaseId"`
	Type         string                                                           `name:"Type"`
}

// CreateOmsOpenAPIProjectTransferStepConfigIncrSyncStepTransferConfig is a repeated param struct in CreateOmsOpenAPIProjectRequest
type CreateOmsOpenAPIProjectTransferStepConfigIncrSyncStepTransferConfig struct {
	StoreTransactionEnabled string    `name:"StoreTransactionEnabled"`
	RecordTypeList          *[]string `name:"RecordTypeList" type:"Repeated"`
	TransferStepType        string    `name:"TransferStepType"`
	StoreLogKeptHour        string    `name:"StoreLogKeptHour"`
	StartTimestamp          string    `name:"StartTimestamp"`
}

// CreateOmsOpenAPIProjectTransferMappingDatabasesItemTablesItem is a repeated param struct in CreateOmsOpenAPIProjectRequest
type CreateOmsOpenAPIProjectTransferMappingDatabasesItemTablesItem struct {
	MappedName     string                                                                      `name:"MappedName"`
	FilterColumns  *[]string                                                                   `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateOmsOpenAPIProjectTransferMappingDatabasesItemTablesItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	TableId        string                                                                      `name:"TableId"`
	WhereClause    string                                                                      `name:"WhereClause"`
	ShardColumns   *[]string                                                                   `name:"ShardColumns" type:"Repeated"`
	TableName      string                                                                      `name:"TableName"`
	Type           string                                                                      `name:"Type"`
}

// CreateOmsOpenAPIProjectTransferMappingDatabasesItemTablesItemAdbTableSchema is a repeated param struct in CreateOmsOpenAPIProjectRequest
type CreateOmsOpenAPIProjectTransferMappingDatabasesItemTablesItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateOmsOpenAPIProjectResponse is the response struct for api CreateOmsOpenAPIProject
type CreateOmsOpenAPIProjectResponse struct {
	*responses.BaseResponse
	Success     bool        `json:"Success" xml:"Success"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	Advice      string      `json:"Advice" xml:"Advice"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int64       `json:"TotalCount" xml:"TotalCount"`
	Cost        string      `json:"Cost" xml:"Cost"`
	Data        string      `json:"Data" xml:"Data"`
	ErrorDetail ErrorDetail `json:"ErrorDetail" xml:"ErrorDetail"`
}

// CreateCreateOmsOpenAPIProjectRequest creates a request to invoke CreateOmsOpenAPIProject API
func CreateCreateOmsOpenAPIProjectRequest() (request *CreateOmsOpenAPIProjectRequest) {
	request = &CreateOmsOpenAPIProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateOmsOpenAPIProject", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOmsOpenAPIProjectResponse creates a response to parse from CreateOmsOpenAPIProject response
func CreateCreateOmsOpenAPIProjectResponse() (response *CreateOmsOpenAPIProjectResponse) {
	response = &CreateOmsOpenAPIProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
